package org.biolegato.ezmenu;

/*
 * CommandWindow.java
 *
 * Created on October 22, 2008, 1:10 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

import java.awt.Dimension;
import java.util.Hashtable;
import org.biolegato.ezmenu.variables.GDEVariable;
import java.awt.Container;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import org.biolegato.core.main.ProgramWindow;

/**
 *
 * @author alvare
 */
public class CommandWindow extends JDialog {
	/**
	 * The container to add variables to.
	 */
	protected Container variablePane = new Box(BoxLayout.PAGE_AXIS);
	/**
	 * The container to add buttons to.
	 */
	protected Container buttonPane = new Box(BoxLayout.LINE_AXIS);
	/**
	 * This constant is used for Serialization
	 */
	private static final long serialVersionUID = 7526472295622776150L;

	/**
	 * Creates a new instance of CommandWindow
	 *
	 * @param parent the parent window (BLMain)
	 * @param name the name of program to run
	 */
	public CommandWindow (ProgramWindow parent, String name) {
		// call the superclass constructor and make the window modal
		super(parent, "BioLegato: " + name, true);

		// create the pane and make it scrollable
		setContentPane(new JScrollPane(new Box(BoxLayout.PAGE_AXIS) {
			/* used for serialization */
			private static final long serialVersionUID = 7526472295622777003L;


			{
				add(variablePane);
				add(buttonPane);
			}
		}));

		// clean up and display the window
		setMinimumSize(new Dimension(50,50));
		setSize(new Dimension(100,100));
		setLocationRelativeTo(parent);
		setVisible(false);
	}

	/**
	 * Adds a button to the window.
	 *
	 * @param run the AbstractAction used to create the button
	 */
	public void addButton (Action run) {
		buttonPane.add(new JButton(run));
		pack();
	}

	/**
	 * This function is used to add variables to the window.
	 *
	 * @param variable the variable to add to the window
	 */
	public void addVariable (GDEVariable variable) {
		Container panel = null;
		if (variable != null) {
			panel = variable.display();
			if (panel != null) {
				variablePane.add(panel);
			}
			pack();
		}
	}

}