package org.biolegato.ezmenu.variables;


import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import org.biolegato.core.main.BLMain;
/*
 * BLComboBox.java
 *
 * Created on June 16, 2008, 1:40 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

/**
 *
 * @author alvare
 */
public class GDEChoiceList extends GDEVariable {
	/**
	 * The list of choices
	 */
	protected HashMap<Object, Object> choices = null;
	/** The combobox contianing the data */
	protected JList choice_list = null;
	/** The contianer used for display purposes */
	protected Box container = new Box(javax.swing.BoxLayout.LINE_AXIS);
	/** used for serialization */
	private static final long serialVersionUID = 7526472295622776158L;

    /**
     * Creates a new instance of GDEComboBox (represents "choice_list" in GDE menu files).
     *
     * @param data the data to create the combobox with
     */
	public GDEChoiceList (java.util.Map data) {
		super(data);

		int defaultEntry = 0;
		String[] orderChoices = null;         // used for default values

		// a combo box which returns its value when toString is called
		if (data.containsKey("description")) {
			container.add(new JLabel(data.get("description").toString()));
		}

		if (data.containsKey("choices") && data.get("choices") instanceof java.util.Map) {
			choices = new HashMap<Object, Object>((java.util.Map<? extends Object, ? extends Object>) data.get("choices"));
			if (data.containsKey("choiceorder") && data.get("choiceorder") instanceof java.util.LinkedList) {
				orderChoices = ((LinkedList<String>) data.get("choiceorder")).toArray(new String[0]);
				choice_list = new JList(orderChoices);
			} else {
				choice_list = new JList(choices.keySet().toArray());
			}

            // handle the default value for the list
			if (data.containsKey("default")) {
                if (data.containsKey("choiceorder")) {
                    try {
                        choice_list.setSelectedIndex(Integer.parseInt(data.get("default").toString()));
                    } catch (NumberFormatException nfe) {
                    }
                } else {
                    choice_list.setSelectedValue(data.get("default").toString(), true);
                }
			}
            // make the choice_list only support single selection
            choice_list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

            // add the choice list (and make it scrollable)
			container.add(new JScrollPane(choice_list, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED));
		} else {
			BLMain.error("Invalid argument (missing choice list)", "BLComboBox");
		}
	}

	/**
	 * Returns the name of this type of variable
	 * @return	the name of the variable type
	 */
	public static String getType () {
		return "choice_list";
	}

	/**
	 * Returns the value of the variable.
	 *
	 * @return	the value of the variable
	 */
	public Object getValue () {
		return choices.get(choice_list.getSelectedValue());
	}

	/**
	 * Used for displaying the plugin
	 * @return	the panel to display the plugin on
	 */
    @Override
	public java.awt.Container display () {
		return container;
	}
}
