package org.biolegato.ezmenu.variables;


import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
/*
 * BLComboBox.java
 *
 * Created on June 16, 2008, 1:40 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

/**
 *
 * @author alvare
 */
public class GDEComboBox extends GDEVariable {
	/**
	 * The list of choices
	 */
	protected HashMap<Object, Object> choices = null;
	/** The combobox contianing the data */
	protected JComboBox combobox = null;
	/** The contianer used for display purposes */
	protected Box container = new Box(javax.swing.BoxLayout.LINE_AXIS);
    /**
     * The UI to enable scrolling of the JComboBox.
     */
    public final BasicComboBoxUI comboboxUI = new BasicComboBoxUI() {
        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup uipopup = new BasicComboPopup(comboBox){
                @Override
                protected JScrollPane createScroller() {
                        return new JScrollPane( list, ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,
                                ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED );
              }
            };
            return uipopup;
        }
    };
	/** used for serialization */
	private static final long serialVersionUID = 7526472295622776158L;

    /**
     * Creates a new instance of GDEComboBox (represents "choice_list" in GDE menu files).
     *
     * @param data the data to create the combobox with
     */
	public GDEComboBox (java.util.Map data) {
		super(data);

		int defaultEntry = 0;
		String[] orderChoices = null;         // used for default values

		// a combo box which returns its value when toString is called
		if (data.containsKey("description")) {
			container.add(new JLabel(data.get("description").toString()));
		}

		if (data.containsKey("choices") && data.get("choices") instanceof java.util.Map) {
			choices = new HashMap<Object, Object>((java.util.Map<? extends Object, ? extends Object>) data.get("choices"));
			if (data.containsKey("choiceorder") && data.get("choiceorder") instanceof java.util.LinkedList) {
				orderChoices = ((LinkedList<String>) data.get("choiceorder")).toArray(new String[0]);
				combobox = new JComboBox(orderChoices);
			} else {
				combobox = new JComboBox(choices.keySet().toArray());
			}
			if (data.containsKey("default")) {
                if (data.containsKey("choiceorder")) {
                    try {
                        combobox.setSelectedIndex(Integer.parseInt(data.get("default").toString()));
                    } catch (NumberFormatException nfe) {
                    }
                } else {
                    combobox.setSelectedItem(data.get("default").toString());
                }
			}
			container.add(combobox);
		} else {
			org.biolegato.core.main.BLMain.error("Invalid argument (missing choice list)", "BLComboBox");
		}
        combobox.setUI(comboboxUI);
        combobox.updateUI();
	}

	/**
	 * Returns the name of this type of variable
	 * @return	the name of the variable type
	 */
	public static String getType () {
		return "choice_menu";
	}

	/**
	 * Returns the value of the variable.
	 *
	 * @return	the value of the variable
	 */
	public Object getValue () {
		return choices.get(combobox.getItemAt(combobox.getSelectedIndex()));
	}

	/**
	 * Used for displaying the plugin
	 * @return	the panel to display the plugin on
	 */
    @Override
	public java.awt.Container display () {
		return container;
	}
}
