package org.biolegato.ezmenu.variables;

/*
 * BLTextField.java
 *
 * Created on June 16, 2008, 2:08 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;

/**
 *
 * @author alvare
 */
public class GDETextField extends GDEVariable {
    /** The contianer used for display purposes */
    private Box container = new Box(javax.swing.BoxLayout.LINE_AXIS);
    /** The textfield contianing the data */
    private JTextField textfield = null;
    /** used for serialization */
    private static final long serialVersionUID = 7526472295622776159L;
    
    /** Creates a new instance of BLTextField */
    public GDETextField(java.util.Map data) {
	super(data);
	// a textbox which returns its value when toString is called
	textfield = new JTextField (20);
	
	// a combo box which returns its value when toString is called
	if (data.containsKey("description")) {
	    container.add(new JLabel (data.get("description").toString()));
	}
	if (data.containsKey("default")) {
	    textfield.setText(data.get("default").toString());
	}
	container.add(textfield);
    }
    /**
     * Returns the name of this type of variable
     * @return	the name of the variable type
     */
    public static String getType() {
	return "text";
    }
    /**
     * Returns the value of the variable.
     *
     * @return	the value of the variable
     */
    public Object getValue() {
	return textfield.getText();
    }
    /**
     * Used for displaying the plugin
     * @return	the panel to display the plugin on
     */
    @Override
    public java.awt.Container display() {
	return container;
    }
}
