/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas;

import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import org.biolegato.core.plugintypes.PropertiesExtension;
import org.biolegato.core.properties.BLProperties;
import org.biolegato.core.properties.PropertiesCheckbox;

/**
 *
 * @author graham
 */
public class GDECanvasProperties implements PropertiesExtension {
    /**
     * Used for serialization purposes
     */
    private static final long serialVersionUID = 7526472295622777011L;
    private final BLProperties properties;

    public GDECanvasProperties (final BLProperties properties) {
        this.properties = properties;

        properties.setProperty("sequence.protection.alignment", "false");
        properties.setProperty("sequence.protection.ambiguos", "true");
        properties.setProperty("sequence.protection.unambiguos", "true");
        properties.setProperty("font.bold", "false");
    }
    
    public void propertiesComponent(Container propertiesBox) {
        Box protectionBox = new Box(BoxLayout.PAGE_AXIS);
        PropertiesCheckbox boldCB = new PropertiesCheckbox(properties, "Use bold fonts", "font.bold");

        propertiesBox.add(boldCB);
    }
}
