/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import org.biolegato.gdesupport.canvas.colour.GDEColourMaskFile;
import org.biolegato.gdesupport.canvas.colour.GDEColourMaskMap;

/**
 *
 * @author graham
 */
public class ImportFileAction extends AbstractAction {
    private JDialog window;
    private JComboBox box;
    private static final long serialVersionUID = 7526472295622777037L;

    public ImportFileAction(JDialog window, JComboBox box) {
        super("Import file...");
        this.window = window;
        this.box = box;
    }
    public void actionPerformed (ActionEvent e) {
        File file = null;
        int number = 1;
        JFileChooser openDialog = new JFileChooser();
        GDEColourMaskMap[] importMasks = null;

        openDialog.setCurrentDirectory(new File(System.getProperty("user.dir")));
        openDialog.setAcceptAllFileFilterUsed(true);

        // if a file is selected, open it
        if (openDialog.showOpenDialog(window) == JFileChooser.APPROVE_OPTION && openDialog.getSelectedFile() != null && openDialog.getSelectedFile().exists() && openDialog.getSelectedFile().isFile()) {
            importMasks = GDEColourMaskFile.readColourMapFile(openDialog.getSelectedFile());
            for (GDEColourMaskMap mask : importMasks) {
                box.addItem(mask.getName());
            }
        }
    }
}
