/*
 * SelectByNameWindow.java
 *
 * Created on June 18, 2009, 2:18 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;

/**
 *
 * @author alvare
 */
public class SelectByNameWindow extends JDialog implements ActionListener {
    
    private JList list;
    private JTextField nameSelector = new JTextField();
    private JButton selectButton = new JButton("Select");
    private JButton closeButton = new JButton("Close");
    
    /**
     * Creates a new instance of SelectByNameWindow
     */
    public SelectByNameWindow(JFrame window, JList list) {
        super (window, "Select by name");
        
        this.list = list;
        
        Box mainPanel = new Box(BoxLayout.PAGE_AXIS);
        
        Box entryPanel = new Box(BoxLayout.LINE_AXIS);
        entryPanel.add(new JLabel("Name:"));
        entryPanel.add(nameSelector);
        mainPanel.add(entryPanel);
        
        Box buttonPanel = new Box(BoxLayout.LINE_AXIS);
        buttonPanel.add(selectButton);
        buttonPanel.add(closeButton);
        mainPanel.add(buttonPanel);
        
        selectButton.addActionListener(this);
        selectButton.setActionCommand("Select");
        
        closeButton.addActionListener(this);
        closeButton.setActionCommand("Close");
        
        add(mainPanel);
        pack();
        setLocationRelativeTo(window);
        setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        String test;
        ListModel model;
        
        if (e.getActionCommand().equalsIgnoreCase("select")) {
            model = list.getModel();
            test = nameSelector.getText().toLowerCase();
            
            for (int count = 0; count < model.getSize(); count++) {
                if (model.getElementAt(count).toString().toLowerCase().contains(test)) {
                    list.addSelectionInterval(count, count);
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase("close")) {
            setVisible(false);
        }
    }
    
}
