/*
 * SequenceListModel.java
 *
 * Created on June 11, 2009, 11:17 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas;

import java.util.LinkedList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.core.data.seqdoc.SeqDocListener;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.data.sequence.SequenceListener;

/**
 *
 * @author alvare
 */
public class SequenceListModel implements ListModel, SeqDocListener {
    private SeqDoc data;
    private LinkedList<ListDataListener> listeners = new LinkedList<ListDataListener>();
    
    /** Creates a new instance of SequenceListModel */
    public SequenceListModel(SeqDoc data) {
        this.data = data;
        
        data.addListener(this);
    }

    public int getSize() {
        return data.getLineCount();
    }

    public Object getElementAt(int index) {
        String name = "";
        Sequence seq = data.getSequence(index);
        
        if (seq != null) {
            name = seq.getField("name").toString();
        }
        return name;
    }

    public void addListDataListener(ListDataListener l) {
        listeners.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
        listeners.remove(l);
    }

    public void sequenceChanged(SeqDoc source, int index, Sequence sequence, String key) {
        for (ListDataListener l : listeners) {
            l.contentsChanged(new ListDataEvent(this, ListDataEvent.CONTENTS_CHANGED, index, index));
        }
    }

    public void sequenceAdded(SeqDoc source, int index, Sequence sequence) {
        for (ListDataListener l : listeners) {
            l.intervalAdded(new ListDataEvent(this, ListDataEvent.CONTENTS_CHANGED, index, index));
        }
    }

    public void sequenceRemoved(SeqDoc source, int index, Sequence sequence) {
        for (ListDataListener l : listeners) {
            l.intervalRemoved(new ListDataEvent(this, ListDataEvent.CONTENTS_CHANGED, index, index));
        }
    }
    
}
