package org.biolegato.gdesupport.canvas.colour;

import org.biolegato.gdesupport.canvas.*;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import org.biolegato.core.main.BLMain;

/**
 * Used to select colour masks.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDEColourMaskFile extends Box {
    /**
     * The combobox for selecting colour maps.
     */
    private JComboBox combobox;
    /**
     * The list of all colour masks loaded in the system.
     */
    protected static Hashtable<String, GDEColourMaskMap> colourMasks = new Hashtable<String, GDEColourMaskMap>();
    /**
     * Used for serialization purposes
     */
    private static final long serialVersionUID = 7526472295622777024L;
    
    /**
     * Creates a new instance of GDEColourMaskFile
     *
     * @param window the window to load the
     * @param defaultMask the default mask for the combobox.
     */
    public GDEColourMaskFile(final JDialog window, final Object defaultMask) {
	super(BoxLayout.LINE_AXIS);
	String defaultMaskName = "";
	
	if (defaultMask instanceof GDEColourMaskMap) {
	    defaultMaskName = ((GDEColourMaskMap)defaultMask).getName();
	}
	combobox = new JComboBox(colourMasks.keySet().toArray());
	
	add(combobox);
	add(new JButton(new ImportFileAction(window, combobox)));
    }
    
    public static GDEColourMaskMap[] readColourMapFile(File file) {
	int number = 1;
	int length = 0;
	Color addColour = null;
	String name = "";
	boolean stopSequence = false;
	boolean nodash = false;
	BufferedReader reader = null;
	GDEColourMaskMap mask = null;
	LinkedList<Color> colourList = new LinkedList<Color>();
	LinkedList<GDEColourMaskMap> colourMapList = new LinkedList<GDEColourMaskMap>();
	String line = "";
	
	if (file != null && file.exists() && file.isFile()) {
	    try {
		reader = new BufferedReader(new FileReader(file.getPath()));
		do {
		    line = reader.readLine();
		    if (line != null) {
			line = line.trim().toLowerCase();
			if (line.startsWith("name:")) {
			    name = line.substring(line.indexOf("name:") + 5);
			} else if (line.startsWith("length:")) {
			    try {
				length = Integer.parseInt(line.substring(line.indexOf("length:") + 7));
			    } catch (Throwable nfe) {
				nfe.printStackTrace();
			    }
			} else if (line.startsWith("nodash:")) {
			    nodash = true;
			} else if (!name.equals("") && line.toLowerCase().startsWith("start:")) {
			    stopSequence = false;
			    while (!stopSequence && length > 0 && line != null) {
				line = reader.readLine();
				addColour = null;
				if (line != null) {
				    line = line.trim().toLowerCase();
				    if (line.equals("1")) {
					addColour = ColourMap.colour1;
				    } else if (line.equals("2")) {
					addColour = ColourMap.colour2;
				    } else if (line.equals("3")) {
					addColour = ColourMap.colour3;
				    } else if (line.equals("4")) {
					addColour = ColourMap.colour4;
				    } else if (line.equals("5")) {
					addColour = ColourMap.colour5;
				    } else if (line.equals("6")) {
					addColour = ColourMap.colour6;
				    } else if (line.equals("7")) {
					addColour = ColourMap.colour7;
				    } else if (line.equals("8")) {
					addColour = ColourMap.colour8;
				    } else if (line.equals("9")) {
					addColour = ColourMap.colour9;
				    } else if (line.equals("10")) {
					addColour = ColourMap.colour10;
				    } else if (line.equals("11")) {
					addColour = ColourMap.colour11;
				    } else if (line.equals("12")) {
					addColour = ColourMap.colour12;
				    } else if (line.equals("13")) {
					addColour = ColourMap.colour13;
				    } else if (line.equals("14")) {
					addColour = ColourMap.colour14;
				    } else if (line.equals("15")) {
					addColour = ColourMap.colour15;
				    } else if (line.toLowerCase().startsWith("name:") || line.toLowerCase().startsWith("length:")
				    || line.toLowerCase().startsWith("nodash:") || line.toLowerCase().startsWith("start:")) {
					stopSequence = true;
				    }
				    if (addColour != null) {
					colourList.add(addColour);
					length--;
				    }
				}
			    }
			    if (length != 0) {
				BLMain.error("Reached end of file before end of colour", "GDEColourMaskColourMap");
			    }
			    // handle duplicae names
			    number = 1;
			    mask = new GDEColourMaskMap(name, colourList.toArray(new Color[0]), nodash);
			    if (colourMasks.contains(mask.getName())) {
				while (colourMasks.contains(mask.getName() + " (" + number + ")")) {
				    number++;
				}
				mask.setName(mask.getName() + " (" + number + ")");
			    }
			    
			    // add the map to the list
			    colourMasks.put(mask.getName(), mask);
			    colourMapList.add(mask);
			    colourList.clear();
			    
			    // reset values for next pass
			    nodash = false;
			    name = "";
			} else if (name.equals("") && line.toLowerCase().startsWith("start:")) {
			    BLMain.error("Unnamed colour mask", "GDEColourMaskColourMap");
			}
		    }
		} while (line != null);
	    } catch (Throwable exception) {
		exception.printStackTrace();
	    }
	} else {
	    BLMain.error("Invalid colour map file", "GDEColourMaskColourMap");
	}
	
	return colourMapList.toArray(new GDEColourMaskMap[0]);
    }
    
    public Object getSelectedItem() {
	return combobox.getSelectedItem();
    }
}