/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.colour;

import org.biolegato.gdesupport.canvas.BLTextArea;
import java.awt.Color;
import java.awt.Graphics;
import org.biolegato.core.data.sequence.Sequence;

/**
 * A colour map class that will give support for GDE colour masks
 */
public class GDEColourMaskMap extends ColourMap {
    private Color[] colourArray = new Color[0];
    private String name = "";
    private boolean nodash = false;

    public GDEColourMaskMap (String name, Color[] colourArray, boolean nodash) {
        this.name = name;
        this.colourArray = colourArray;
        this.nodash = nodash;
    }

    /**
     * Draws a sequence mapping the appropriate colours to each character rendered
     *
     * @param ta the textarea to use for obtaining metrics from.
     * @param gfx the graphics object to draw the string to.
     * @param xstart the x co-ordinate to start drawing from.
     * @param ystart the y co-ordinate to start drawing from.
     * @param seq the sequence to draw.
     */
    @Override
    public void regularDrawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, Sequence seq) {
        int count = 0;
        char[] stringArray = seq.getField("sequence").toString().toCharArray();

        for (count = 0; count < stringArray.length; count++) {
            if ((!nodash || stringArray[count] != '-') && count < colourArray.length) {
                drawString(ta, gfx, xstart, ystart, "" + stringArray[count], colourArray[count], background);
            } else {
                drawString(ta, gfx, xstart, ystart, "" + stringArray[count], foreground, background);
            }
            xstart += ta.columnSize();
        }
    }

    /**
     * Returns the name of the colour mask.
     * @return the name of the colour mask.
     */
    public String getName() {
        return name;
    }

    /**
     * Changes the name of the colour mask.
     * @param string the new name for the colour mask.
     */
    public void setName (String string) {
        name = string;
    }
}
