/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.colour;

import org.biolegato.gdesupport.canvas.BLTextArea;
import java.awt.Color;
import java.awt.Graphics;
import org.biolegato.core.data.sequence.Sequence;

/**
 *
 * @author graham
 */
public class MonochromeColourMap extends ColourMap {

    public MonochromeColourMap () {
    }

    public MonochromeColourMap (Color foreground, Color background, Color foregroundSelect, Color backgroundSelect) {
        this.foreground = foreground;
        this.background = background;
        this.foregroundSelect = foregroundSelect;
        this.backgroundSelect = backgroundSelect;
    }

    /**
     * Draws a sequence mapping the appropriate colours to each character rendered
     *
     * @param ta the textarea to use for obtaining metrics from.
     * @param gfx the graphics object to draw the string to.
     * @param xstart the x co-ordinate to start drawing from.
     * @param ystart the y co-ordinate to start drawing from.
     * @param seq the sequence to draw.
     */
    @Override
    public void regularDrawString (BLTextArea ta, Graphics gfx, int xstart, int ystart, Sequence seq) {
        drawString(ta, gfx, xstart, ystart, seq.getField("sequence").toString(), foreground, background);
    }
}
