/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.selections;

import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.gdesupport.canvas.BLTextArea;
import java.util.LinkedList;
import org.biolegato.core.data.sequence.Sequence;

/**
 * Used to handle rectangle selections (using CTRL)
 */
public class TextRectangle extends Selection {

    /**
     * Creates a new TextRectangle object (with default parameters).
     */
    public TextRectangle () {
        super();
    }
    
    /**
     * Deep copies a selection
     *
     * @param s the section to obtain x1,y1,x2,y2 from
     */
    public TextRectangle (Selection s) {
        super(s);
    }

    /**
     * Returns the intersection between a line of text and the current object
     *
     * @param line the line number of the line to test
     * @param length the total length of the line
     * @return the interstection (null if the line does not intersect)
     */
    public LineSelection intersect (int line, int length) {
        Integer int1 = axisIntersect(0, length, getX1(), getX2());
        Integer int2 = axisIntersect(0 - length, 0, 0 - getX2(), 0 - getX1());
        LineSelection intersect = null;

        if (int1 != null && int2 != null && ((line >= getY1() && line <= getY2()) || (line <= getY1() && line >= getY2()))) {
            intersect = new LineSelection(int1.intValue(), 0 - int2.intValue());
        }
        return intersect;
    }

    /**
     * Used to obtain all of the text selected within a document according
     * to the current selection shape object.
     *
     * @param document the document to obtain the selection from
     * @return the text selected
     */
    public Sequence[] getSelectionSequences (SeqDoc document) {
        int length;
        String currentSequence = "";
        Sequence current = null;
        LinkedList<Sequence> result = new LinkedList<Sequence>();

        if ( ! isEmpty()) {
            for (int count = getMinY(); count <= getMaxY(); count ++) {
                length = document.getLineLength(count);
                if (getMinX() < length) {
                    current = document.getSequence(count);
                    if (current != null) {
                        current = (Sequence) current.clone();
                        currentSequence = current.getField("sequence").toString();
                        if (getMaxX() < length) {
                            currentSequence = currentSequence.substring(0, getMaxX());
                        }
			if (getMinX() > 0) {
                            currentSequence = currentSequence.substring(getMinX());
                        }
			if (!currentSequence.equals(current.getField("sequence").toString())) {
			    current.setField("sequence", currentSequence);
			}
                        result.add(current);
                    }
                }
            }
        }
        return result.toArray(new Sequence[0]);
    }

    /**
     * Used to delete all of the text selected within a document according
     * to the current selection shape object.
     *
     * @param textarea the textarea to delete the selection from
     * @return whether the deletion was successful
     */
    public boolean delete (BLTextArea textarea) {
        boolean result = true;
        if ( ! isEmpty()) {
            for (int count = getMaxY(); count >= getMinY(); count --) {
                result = result && textarea.delete(textarea.getSeqDoc().getLineStartOffset(count) + getMinX(), Math.min(textarea.getSeqDoc().getLineLength(count), getMaxX() - getMinX()));
            }
        }
        return result;
    }

}
