package org.biolegato.gdesupport.files;

/*
 * GDEFlatfile.java
 *
 * Created on January 30, 2008, 11:58 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.data.sequence.Sequence.Type;
import org.biolegato.core.plugintypes.DataFormat;
import java.io.File;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;

/**
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDEFlatfile extends DataFormat {

    /**
     * Creates a new instance of GDEFlatfile
     */
    public GDEFlatfile () {
    }

    /**
     * Translates a string from the BioLegato internal format to the given file format
     * @param seq the string to convert
     * @return the resulting string
     */
    public String translateTo(Sequence seq) {
	char type = '#';
	StringBuffer result = new StringBuffer();
	java.util.Map<String, Object> sequence;
        // translate the data
	if (seq != null) {
            type = typeToFlatFile((Type) seq.getField("type"));
            if (type != '%' && type != '@' && type != '\"') {
                type = '#';
            }
            // NOTE: append is faster than + or concat operators
            result.append(type).append(seq.getField("name")).append("\n").append(seq.getField("sequence")).append("\n");
	}
	return result.toString();
    }

    /**
     * Translates a string from the given file format into the BioLegato internal format
     * @param data  the string to convert
     * @return  the resulting string
     */
    public Sequence[] translateFrom (java.io.BufferedReader data) throws
            java.io.IOException {
        String line = "";
        LinkedList<Sequence> result = new LinkedList<Sequence>();
        java.util.Map<String, Object> sequence = new HashMap<String, Object>();

        while ((line = data.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith("%") || line.startsWith(
                    "@") || line.startsWith("\"")) {
                if ( ! sequence.isEmpty()) {
                    result.add(new Sequence(sequence));
                    sequence.clear();
                }
                if (line.indexOf(' ') > 0) {
                    line = line.substring(0, line.indexOf(' '));
                }
                if (line.indexOf('\t') > 0) {
                    line = line.substring(0, line.indexOf('\t'));
                }
                if (line.indexOf('\n') > 0) {
                    line = line.substring(0, line.indexOf('\n'));
                }
                if (line.indexOf('\r') > 0) {
                    line = line.substring(0, line.indexOf('\r'));
                }
                sequence.put("type", flatFileToType(line.trim().charAt(0)));
                sequence.put("name", line.trim().substring(1));
            } else {
                sequence.put("sequence", (sequence.containsKey("sequence") ? sequence.get("sequence")
                                          : "") + line.trim());
            }
        }
        if ( ! sequence.isEmpty()) {
            result.add(new Sequence(sequence));
        }
        return result.toArray(new Sequence[0]);
    }

    /**
     * Determines whether or not the file should be accepted by the filter
     * @param	file	the file to test
     * @return	whether or not the file is accepted
     * @see javax.swing.filechooser.FileFilter#accept
     */
    public boolean accept (File file) {
        return (file.isDirectory() || file.getAbsolutePath().toLowerCase().
                endsWith(".flat"));
    }

    /**
     * Obtains the name of the file format for File Chooser purposes
     * @return  the name of the file format
     */
    @Override
    public String getName () {
        return "flat";
    }

    /**
     * The file description to display inside the JFileChooser
     * @return	the string description of the DataFormat
     * @see javax.swing.filechooser.FileFilter#getDescription
     */
    public String getDescription () {
        return "GDE Flatfile (*.flat)";
    }

    /**
     * Converts a GDE flatfile type into a Sequence.Type structure
     * @param	test	the character to test for type
     * @return	the resulting type
     */
    private static Type flatFileToType (char test) {
        Type result = Type.DNA;
        switch (test) {
            case '%':
                result = Type.PROTEIN;
                break;
            case '@':
                result = Type.MASK;
                break;
            case '\"':
                result = Type.TEXT;
                break;
        }
        return result;
    }

    /**
     * Converts a Sequence.Type structure into a GDE flatfile type character
     * @param test the type to convert into a character
     * @return the resulting character
     */
    private static char typeToFlatFile (Type t) {
        char result = '#';
        switch (t) {
            case PROTEIN:
                result = '%';
                break;
            case MASK:
                result = '@';
                break;
            case TEXT:
                result = '\"';
                break;
        }
        return result;
    }
    
    /**
     * Used to auto-detect Bio Legato formats
     *
     * @param test the string to test
     * @return whether or not the format is correct
     */
    @Override
    public boolean isFormat (Reader test) {
        int check = ' ';
        try {
            while (check == ' ' || check == '\t' || check == '\n' || check ==
                                                                     '\r') {
                test.mark(2);
                check = test.read();
            }
            test.reset();
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return (check == '#' || check == '%' || check == '@' || check == '\"');
    }

}
