/*
 * GDEFlatfile.java
 *
 * Created on January 30, 2008, 11:58 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.plugintypes.DataFormat;
import java.io.File;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;

/**
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class FastAFile extends DataFormat {

    /**
     * Creates a new instance of GDEFlatfile
     */
    public FastAFile () {
    }

    /**
     * Translates a string from the BioLegato internal format to the given file format
     * 
     * @param seq  the sequence to convert
     * @return the resulting string
     */
    public String translateTo(Sequence seq) {
	String result = "";
	java.util.Map<String, Object> sequence;
        
        // translate the sequence
	if (seq != null) {
            result = ">" + seq.getField("name") + "\n" + seq.getField("sequence") + "\n";
	}
	return result;
    }

    /**
     * Translates a string from the given file format into the BioLegato internal format
     * @param data  the string to convert
     * @return  the resulting string
     */
    public Sequence[] translateFrom (java.io.BufferedReader data) throws
            java.io.IOException {
        String line = "";
        LinkedList<Sequence> result = new LinkedList<Sequence>();
        java.util.Map<String, Object> sequence = new HashMap<String, Object>();

        while ((line = data.readLine()) != null) {
            if (line.startsWith(">")) {
                if ( ! sequence.isEmpty()) {
                    result.add(new Sequence(sequence));
                    sequence.clear();
                }
                if (line.indexOf(' ') > 0) {
                    line = line.substring(0, line.indexOf(' '));
                }
                if (line.indexOf('\t') > 0) {
                    line = line.substring(0, line.indexOf('\t'));
                }
                if (line.indexOf('\n') > 0) {
                    line = line.substring(0, line.indexOf('\n'));
                }
                if (line.indexOf('\r') > 0) {
                    line = line.substring(0, line.indexOf('\r'));
                }
                sequence.put("type", line.trim().charAt(0));
                sequence.put("name", line.trim().substring(1));
            } else if (line.trim().startsWith("#")) {
            } else if ( ! line.trim().startsWith(";")) {
                sequence.put("sequence", (sequence.containsKey("sequence") ? sequence.get("sequence")
                                          : "") + line.trim().replaceAll(
                        "[^A-Za-z\\*\\-]", ""));
            }
        }
        if ( ! sequence.isEmpty()) {
            result.add(new Sequence(sequence));
        }
        return result.toArray(new Sequence[0]);
    }

    /**
     * Determines whether or not the file should be accepted by the filter
     * @param	file	the file to test
     * @return	whether or not the file is accepted
     * @see javax.swing.filechooser.FileFilter#accept
     */
    public boolean accept (File file) {
        return (file.isDirectory() ||
                file.getAbsolutePath().toLowerCase().endsWith(".wrp") ||
                file.getAbsolutePath().toLowerCase().endsWith(".fasta") ||
                file.getAbsolutePath().toLowerCase().endsWith(".fsa"));
    }

    /**
     * Obtains the name of the file format for File Chooser purposes
     * @return  the name of the file format
     */
    @Override
    public String getName () {
        return "fasta";
    }

    /**
     * The file description to display inside the JFileChooser
     * @return	the string description of the DataFormat
     * @see javax.swing.filechooser.FileFilter#getDescription
     */
    public String getDescription () {
        return "FastA file (*.wrp,*.fasta,*.fsa)";
    }

    /**
     * Used to auto-detect Bio Legato formats
     *
     * @param test the string to test
     * @return whether or not the format is correct
     */
    @Override
    public boolean isFormat (Reader test) {
        int check = ' ';
        try {
            while (check == ' ' || check == '\t' || check == '\n' || check ==
                                                                     '\r') {
                test.mark(2);
                check = test.read();
            }
            test.reset();
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return (check == '>');
    }

}
