/*
 * SeqDocListener.java
 *
 * Created on June 9, 2009, 2:52 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.core.data.seqdoc;

import org.biolegato.core.data.sequence.Sequence;

/**
 * The listener class for sequence document objects.
 * <p>
 *  This interface is used to receive document changes within a SeqDoc file.
 *  All SeqDoc listeners will receive notification when sequences are added to,
 *  changed within or removed from the SeqDoc.  Notification for sequence modification
 *  will be sent if the sequence is inside the SeqDoc structure regardless of whether
 *  the modification originated from the containing SeqDoc class.
 * </p>
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public interface SeqDocListener {
    /**
     * This method is called when a sequence is added to a SeqDoc.
     *
     * @param source the source of the sequence insertion event.
     * @param index the location (line number) where the sequence was added within the SeqDoc structure.
     * @param sequence the sequence object added to the SeqDoc structure.
     */
    public void sequenceAdded(SeqDoc source, int index, Sequence sequence);
    /**
     * This method is called when a field in a sequence is modified.  The field may either be
     * modified by the SeqDoc class or by an external class so long as the sequence is contained
     * within the SeqDoc class.
     *
     * @param source the source of the sequence alteration message.
     * @param index the location (line number) of the sequence which was modified.
     * @param sequence the modified sequence object.
     * @param key the field key of the sequence object which was modified.
     */
    public void sequenceChanged(SeqDoc source, int index, Sequence sequence, String key);
    /**
     * This method is called when a sequence is removed from the SeqDoc class.
     *
     * @param source the source of the sequence removal message.
     * @param index the location (line number) where the sequence was removed from.
     * @param sequence the sequence removed from the SeqDoc.
     */
    public void sequenceRemoved(SeqDoc source, int index, Sequence sequence);
}
