/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.biolegato.core.data.seqdoc.undo;

import org.biolegato.core.data.seqdoc.SeqDoc;

/**
 * This object is used to undo an insertion of text to a SeqDoc object.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class UndoInsert implements Undoable {

    /**
     * The offset of the start of the insert.
     */
    private int offset;
    /**
     * The length of text inserted.
     */
    private int length;
    /**
     * The data container to associate the UndoInsert with.
     */
    private SeqDoc data;

    /**
     * Creates a new UndoInsert object for undoing text insertions.
     *
     * @param data the document to attach the object to.
     * @param offset the offset of the insertion.
     * @param length the length of text inserted.
     */
    public UndoInsert (SeqDoc data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    /**
     * Undoes the text insertion.
     *
     * @return an redo event for the text insertion.
     */
    public Undoable undo () {
        // get the text which was inserted and store it in a string.
        String deleted = data.getText(offset, length);

        // delete the inserted text
        data.delete(offset, length);
        
        // returns an object for redoing the undone text insertion.
        return new UndoDelete(data, 0, offset, deleted);
    }

}
