package org.biolegato.ezmenu.variables;

/*
 * BLNumberSelector.java
 *
 * Created on 2007/11/26, 11:24
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * Wraps a widget(s) for selecting numeric values.
 * 
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDESlider extends GDEVariable implements ChangeListener {
	/**
     * The slider portion of the number selector widget.
     */
	private JSlider slider = null;
	/**
     * The slider portion of the number selector widget.
     */
	private JSpinner spinner = null;
	/**
     * The contianer used to display the slider and spinner.
     */
	private Box container = new Box(javax.swing.BoxLayout.LINE_AXIS);
	/**
     * Used for serialization purposes.
     */
	private static final long serialVersionUID = 7526472295622776161L;

	/**
	 * Creates a new instance of GDESlider
     *
	 * @param data the map containing all of the information required to make the number selector.
	 */
	public GDESlider (java.util.Map data) {
		super(data);

		int defaultValue = 0;
		int minimum = 0;
		int maximum = 5000;
		Box panel = new Box(javax.swing.BoxLayout.LINE_AXIS);
		if (data.containsKey("description")) {
			container.add(new JLabel(data.get("description").toString() + ":"));
		}
		if (data.containsKey("minimum") && data.get("minimum") instanceof Integer) {
			minimum = ((Integer) data.get("minimum")).intValue();
		}
		if (data.containsKey("maximum") && data.get("maximum") instanceof Integer) {
			maximum = ((Integer) data.get("maximum")).intValue();
		}
		if (data.containsKey("default")) {
			try {
				defaultValue = Integer.parseInt(data.get("default").toString());
			} catch (NumberFormatException nfe) {
			}
		}
		//add the spinner
		spinner = new JSpinner(new SpinnerNumberModel(defaultValue, minimum, maximum, 1));
		spinner.addChangeListener(this);
		panel.add(spinner);

		panel.add(new JLabel("" + minimum));
		// add the slider
		slider = new JSlider(JSlider.HORIZONTAL, minimum, maximum, defaultValue);
		slider.addChangeListener(this);
		panel.add(slider);
		panel.add(new JLabel("" + maximum));
		container.add(panel);
	}

	/**
	 * Handles synchronization between the slider and the spinner.
     * 
	 * @param e used to determine which widget was changed.
	 */
	public void stateChanged (ChangeEvent e) {
		if (e.getSource() instanceof JSpinner) {
			slider.setValue(((Number) spinner.getValue()).intValue());
		} else {
			spinner.setValue(slider.getValue());
		}
	}

	/**
	 * Returns the name of this type of variable.
     *
	 * @return the name of the variable type -- "slider".
	 */
	public static String getType () {
		return "slider";
	}

	/**
	 * Returns the current value of the variable.
	 *
	 * @return the value selected by the slider/spinner.
	 */
	public Object getValue () {
		return spinner.getValue().toString();
	}

	/**
	 * Used for displaying the widget.
	 * @return a panel to display the plugin on.
	 */
    @Override
	public java.awt.Container display () {
		return container;
	}
}
