/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import org.biolegato.gdesupport.canvas.colour.GDEColourMaskFile;
import org.biolegato.gdesupport.canvas.colour.GDEColourMaskMap;

/**
 * The menu item to handle importing colour masks
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class ImportFileAction extends AbstractAction {
    /**
     * The window to associate the import with.
     */
    private JDialog window;
    /**
     * The combobox to use for selecting imported colour masks from.
     */
    private JComboBox box;
    /**
     * Used for serialization purposes.
     */
    private static final long serialVersionUID = 7526472295622777037L;

    /**
     * Creates a new ImportFileAction object.
     *
     * @param window the window to associate the import with.
     * @param box the combobox to use for selecting imported colour masks from.
     */
    public ImportFileAction(JDialog window, JComboBox box) {
        super("Import file...");
        this.window = window;
        this.box = box;
    }

    /**
     * Performs all of the import file functionality.
     *
     * @param e is ignored by this function.
     */
    public void actionPerformed (ActionEvent e) {
        JFileChooser openDialog = new JFileChooser();   // the JFileChooser for selecting the file to import.
        GDEColourMaskMap[] importMasks = null;          // the colour masks that were imported.

        // set the parameters for the open file dialog box
        openDialog.setCurrentDirectory(new File(System.getProperty("user.dir")));
        openDialog.setAcceptAllFileFilterUsed(true);

        // if a file is selected, open it
        if (openDialog.showOpenDialog(window) == JFileChooser.APPROVE_OPTION && openDialog.getSelectedFile() != null
                && openDialog.getSelectedFile().exists() && openDialog.getSelectedFile().isFile()) {
            importMasks = GDEColourMaskFile.readColourMapFile(openDialog.getSelectedFile());
            for (GDEColourMaskMap mask : importMasks) {
                box.addItem(mask.getName());
            }
        }
    }
}
