//=====================================================================
// File:    AnalysisOp.java
// Class:   AnalysisOp
// Package: AFLPcore
//
// Author:  James J. Benham
// Date:    August 6, 1998
// Contact: james_benham@hmc.edu
//
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPcore;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/**
 * This abstract class represents methods used to analyize a gel. These
 * methods should provide information about the gel in a text format.
 * For example, <code>BinAnalysis</code> displays the location, range,
 * overall score information, and the scoring for each lane of every bin
 * in the gel. Other methods could do something like print out the cutoffs
 * for each lane, or maybe calculate total signal strengths for all of the
 * lanes in the gel, or just about anything else.
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date August 6, 1998
 */

public abstract class AnalysisOp extends Operation implements Cloneable
{
  /**
   * This method should provide some sort of information about the gel.
   * Since the gel contains almost all of the information contained in the
   * program, this method can return a string signifying almost anything.
   *
   * @param labels  the gel object to use.
   *
   * @return a string that contains the results of the analysis.
   */
  public abstract String analyze(Gel gel);

 /**
   * Gives an object where every field has been copied from this object
   * to the new object.
   *
   * @return a copy of this object.
   */
  public Object clone()
  {
    try
      {
     return super.clone();
      }
    catch(CloneNotSupportedException e)
      {
     System.err.println("Could not clone Analysis Operation. " +
                  e.getMessage());
      }
    return null;
  }
}
