//=====================================================================
// File:    SearchReturn.java
// Class:   SearchReturn
// Package: AFLPcore
//
// Author:  James J. Benham
// Date:    August 10, 1998
// Contact: james_benham@hmc.edu
//
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPcore;

/**
 * This class contains a pair of values used in searches. The first is
 * the location of the data being searched for. It is -1 if the data is not
 * found. If the data is not found, then the insertIndex holds the location
 * where the value should appear.
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date August 10, 1998
 */

public class SearchReturn
{
  /** The location of value in a list */
  public int location;
  /** The position where the value would go if it is not in the list*/
  public int insertIndex;

  /**
   * Creates a new pair of return values, with the location initialized to
   * -1 and the insertIndex initialized to 0.
   */
  SearchReturn()
  {
    location = -1;
    insertIndex = 0;
  }
}
