//=====================================================================
// File:    AboutDialog.java
// Class:   AboutDialog
// Package: AFLPgui
//
// Author:  James J. Benham
// Date:    December 5, 2000
// Contact: james_benham@hmc.edu
//
// Genographer v1.4 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPgui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import AFLPcore.Constants;

/**
 * This is the about dialog box for the program. The text is stored in
 * the constants file
 *
 * @see AFLPcore.Constants
 *
 * @author James J. Benham
 * @version 1.4.0
 * @date December 5, 2000
 */

public class AboutDialog extends Dialog implements ActionListener,
                                                       WindowListener
{
  // Layout Constants

  // GUI components
  private TextArea infoTA;
  private Button okB;

  /**
   * Creates a new about dialog with the 
   *
   * @param parent   the owner of the dialog
   */
  public AboutDialog(Frame parent)
  {
    this(parent, "");
  }

  /**
   * Creates a new about dialog with the specified parameters
   *
   * @param parent   the owner of the dialog
   * @param title    the name of the dialog box
   */
  public AboutDialog(Frame parent, String title)
  {
    super(parent, title, true);

    addWindowListener(this);

    setLayout(null);
    setBackground(Color.lightGray);
    setSize(400, 400);

    infoTA = new TextArea();
    okB = new Button("Close");
    okB.addActionListener(this);

    infoTA.setEditable(false);

    add(infoTA);
    add(okB);

    infoTA.setBounds(5, 25, 390, 340);
    okB.setBounds(5, 368, 390, 28);

    infoTA.setText(Constants.ABOUT_STR);
  }

  /**
   * Closes the dialog box when ok is hit.
   */
  public void actionPerformed(ActionEvent e)
  {
    if(e.getSource() == okB)
      {
	dispose();
	setVisible(false);
      }
  }

  /** 
   * Closes the dialog and is equivalent to clicking ok.
   */
  public void windowClosing(WindowEvent e)
  {
    dispose();
    setVisible(false);
  }

  // ==================Unused methods required by interfaces=================
  /**Unused*/ public void windowOpened(WindowEvent e) {}
  /**Unused*/ public void windowClosed(WindowEvent e) {}
  /**Unused*/ public void windowIconified(WindowEvent e) {}
  /**Unused*/ public void windowDeiconified(WindowEvent e) {}
  /**Unused*/ public void windowActivated(WindowEvent e) {}
  /**Unused*/ public void windowDeactivated(WindowEvent e) {}
}
