//=====================================================================
// File:    ImgButton.java
// Class:   ImgButton
// Package: AFLPgui
//
// Author:  James J. Benham
// Date:    August 12, 1998
// Contact: james_benham@hmc.edu
//
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPgui;

import java.awt.Button;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

/**
 * A button with an image on it. The image position is adjusted when
 * the button is pressed, and then moved back when it is released.
 * The image is drawn at (2, 2) when the button is "up" and (3, 3) when
 * it is "down".
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date August 12, 1998
 */

public class ImgButton extends Button implements MouseListener
{
  protected Image image;
  private int pos_x;
  private int pos_y;

  /**
   * Creates a new ImgButton with the specified image.
   *
   * @param img  the image for the button to display on it's face.
   */
  public ImgButton(Image img)
  {
    super();
    image = img;
    pos_x = 2;
    pos_y = 2;

    addMouseListener(this);
    
    repaint();
  }

  /**
   * Draws the button. The super class handles all of the drawing except
   * for the image. The image is drawn at a position depending on it's state.
   * If the button is "pressed" the image is drawn lower and farther to
   * the right.
   *
   * @param g  the graphics object to draw on.
   */
  public void paint(Graphics g)
  {
    super.paint(g);
    Dimension dimen = getSize();
    g.drawImage(image, pos_x, pos_y, this);
  }

  /** Unused*/
  public void mouseClicked(MouseEvent e) {}

  /**
   * Shifts the image position down and to the right. See the class 
   * description for the value.
   */
  public void mousePressed(MouseEvent e)
  {
    pos_x = 3;
    pos_y = 3;
  }

  /**
   * Moves the image position back to it's normal state.
   */
  public void mouseReleased(MouseEvent e)
  {
    pos_x = 2;
    pos_y = 2;
  }

  /** Unused*/
  public void mouseEntered(MouseEvent e) {}

  /**
   * Moves the image position back to it's normal state.
   */  
  public void mouseExited(MouseEvent e)
  {
    pos_x = 2;
    pos_y = 2;
  }

}
