#!/bin/csh
# For systems on which there is no PostScript viewer (an increasing
# number of systems), this script runs ps2pdf and then opens the
# PDF viewer to view the PDF file. After viewing, the 
# temporary file is deleted.  
# $ACE_Viewer is the name of the program. 
# $1 is the file for the program to use.

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif

#Choose a .pdf viewer
if !(${?ACE_PDF_COMMAND}) setenv ACE_PDF_COMMAND gv

echo Converting $1 to PDF...

set tempfile = acedb_$$
ps2pdf $1 ./$tempfile

#ls -l ./$tempfile

($ACE_PDF_COMMAND $tempfile; $RM_CMD -f $tempfile) &
