#!/bin/sh

# Synopsis: birchtmpdir.sh
#
# returns the location of a temporary directory
# that can be used by scripts which require
# large amounts of disk space for temporary files.

# for test purposes, uncomment one of these
#BIRCH_TMP=""
#BIRCH_TMP="/usr/local/tmp"

USER_TMP=""
USERID=`whoami`


if [ ! "$BIRCH_TMP" = "" ]
  then 
    if [ -d $BIRCH_TMP ]     
       then  
	  cd $BIRCH_TMP
	  if [ ! -d $USERID ]
            then      
	       mkdir $USERID
	       chmod 700 $USERID
	  fi
	  	
	  USER_TMP=$BIRCH_TMP/$USERID  
    fi    
fi

echo $USER_TMP
