#!/bin/csh

# browser.csh Version 6/4/07
# Open a browser window to a specific URL


# Synopsis: browser.csh  URL

# URL must be fully qualified. For example, for a web site
#     http://home.cc.umanitoba.ca/~frist
#
# For a file, the path does NOT need to begin with file:///
#     


# BIRCH_NETSCAPE is an environment variable telling
# the command to run your browser.
# It has been commented out below to allow it to be set
# by the user's environment
#set BIRCH_NETSCAPE = 'netscape'
#set BIRCH_NETSCAPE = 'mozilla'
#set BIRCH_NETSCAPE = 'firefox'
if ( -z "$BIRCH_NETSCAPE" ) set BIRCH_NETSCAPE = 'mozilla'

# Older versions of netscape/mozilla need to be called using the
# openURL() argument, if you try to launch a new page while 
# a copy of the browser is already running. The variable BROWSER_OPENURL
# is set to 0 by default. If you are using an older browser
# such as Netscape 7.1 and earlier, BROWSER_OPENURL should be set 
# to 1.
#set BROWSER_OPENURL = 1
if ( -z "$BROWSER_OPENURL" ) BROWSER_OPENURL = 0


# Universal command for removing files or directories
switch ($BIRCH_PLATFORM)
  case "solaris-*" :
    set PS_CMD = 'ps -u'
    set RM_CMD = /usr/bin/rm
    breaksw
  case "sun" : # DEPRECATED
    set PS_CMD = 'ps -u'
    set RM_CMD = /usr/bin/rm
    breaksw
  case "linux-intel" :
    set PS_CMD = 'ps U'
    set RM_CMD = /bin/rm
    breaksw
  case "linux-x86_64" :
    set PS_CMD = 'ps U'
    set RM_CMD = /bin/rm
    breaksw
  default:
    set PS_CMD = 'ps -u'
    set RM_CMD = rm
    breaksw
endsw

set USERID = `whoami`
set URL = $1


# Make sure that if URL is a local file, that
# it is a fully-qualified file path
set UCOUNT = `echo $URL | egrep -c -e 'http://'`
set FCOUNT = `echo $URL | egrep -c -e 'file:///'`
if ( "$UCOUNT"  == "0"  &&  "$FCOUNT" == "0" ) then        
   


	# Now, we have to handle cases where the path is specified
	# using an environment variable eg.
	# browser.sh $doc/Phylip/main.html
      set DNAME = `dirname $URL`
#      echo 'DNAME= '$DNAME
      set BNAME = `basename $URL`
#      echo 'BNAME =  '$BNAME

	# Special case where the file is in the current directory
	# eg. broswer.sh somethingorother.html  
	#      
	# This is the silliest piece of code I've ever written.
	# The Bourne shell is very bizzare about when and
	# where it chooses to translate "." into $PWD.
	# After trying about a million things, including escapes
	# and octal representations of ".", this appears to work
	# for the Bourne shell on both Solaris and Linux.
      set CDIR = $PWD
#      echo 'CDIR= '$CDIR
      cd $DNAME

      if ( "$CDIR" == "$PWD"  ) then
	  set DNAME = $PWD
      else
          set DNAME = "$DNAME" # force evaluation of $DNAME	 
      endif
      cd $CDIR
      set URL = file://$DNAME/$BNAME
endif

echo Opening document: $URL


if ( "$BROWSER_OPENURL" == "0" ) then

      # The most recent mozilla family of browsers automatically
      # detects whether there is already a copy of the brower
      # running, which saves a lot of headaches
      $BIRCH_NETSCAPE $URL 
else
      # For older browsers eg. Netscape 4.79 - Netscape 7.1
      #
      # Find out if there is a copy of netscape already running.
      # If there is, call netscape using -remote option, otherwise
      # launch a new netscape job.
      # See http://wp.netscape.com/newsref/std/x-remote.html
      set TEMPFILE = /tmp/browser.sh.$$
      $PS_CMD $USERID > $TEMPFILE

      set PATTERN = `basename $BIRCH_NETSCAPE` 
      set COUNT = `egrep -c -e $PATTERN < $TEMPFILE`

      if ( "$COUNT" == "0" ) then
	    $BIRCH_NETSCAPE $URL 
      else
            set REMOTESTRING = "openURL($URL,new-window)"
            $BIRCH_NETSCAPE -remote $REMOTESTRING 
      endif
      $RM_CMD $TEMPFILE
endif



