#!/bin/sh
# For all documentation in a directory, create ACEDB file
# objects in ace flatfile format

# RM_CMD - command to be used for removing files and directories
if [ -f /usr/bin/rm ]
then
   RM_CMD=/usr/bin/rm
else
   if [ -f /bin/rm ]
   then
      RM_CMD=/bin/rm
   else
      RM_CMD=rm
   fi
fi

CURRENT=$PWD
FULLPATH=$1
DIR=`echo $FULLPATH | sed -e 's%/.*/%%'`
COUNT=`echo $FULLPATH | grep -c "local"`

if [ -d $FULLPATH  ]
then
   cd $FULLPATH
   for file in `ls *.pdf *.ps *.doc *.txt *.asc *.PDF *.PS *.html *.htm *.HTML *.HTM\
           *.man *.sxw *.sxc *.sxi *.odt`
       do

	 # Strip off leading path components, and retain the name of current directory    
	 if [ "$COUNT" = "0" ]
	 	then
            FN='$doc/'$DIR'/'$file
	 else
            FN='$local/doc/'$DIR'/'$file
	 fi
	 echo 'File : "'$FN'"' >> $CURRENT/TEMPFILE
	 echo 'Pick_me_to_call "$ACE_FILE_LAUNCHER" "'$FN'"' >> $CURRENT/TEMPFILE
	 echo '' >> $CURRENT/TEMPFILE
     done
   sed -e 's%/%\\/%g' < $CURRENT/TEMPFILE > $CURRENT/docfiles.ace
   $RM_CMD -f  $CURRENT/TEMPFILE
else
   echo Directory $FULLPATH not found.
fi
