#!/bin/csh

# Create an infile for fastDNAml

#Version  11/25/06
#Synopsis: fastDNAml.csh infile qadd global\
#                       jmble jseed bstrap tratio spout outgrp usertree ufn

#Convert arguments to variables
set INFILE      = $1
set QADD        = $2
set GLOBAL      = $3
set JMBLE       = $4
set JSEED       = $5
set BSTRAP      = $6
set TRATIO      = $7
set SPOUT       = $8
set OUTGRP      = $9
set USERTREE    = $10
set UFN         = $11

# Bootstrapping will automatically jumble the sequence.
# If fastDNAml_boot finds a Jumble auxiliary line, it
# will generate an error message and quit.
if ($BSTRAP == y) set JMBLE = "N"

################################################
# Set up $INFILE for fastDNAml
################################################
#----------------- generate first line  -----------------

set FIRSTLINE = `head -1 $INFILE`
set FIRSTLINE = "$FIRSTLINE Y F T"
if ($QADD == Y) set FIRSTLINE = "$FIRSTLINE Q"
if ($GLOBAL == Y) set FIRSTLINE = "$FIRSTLINE G"
if ($JMBLE == Y) set FIRSTLINE = "$FIRSTLINE J"
if ($SPOUT == Y)  set FIRSTLINE = "$FIRSTLINE O"
if ($USERTREE == Y) set FIRSTLINE = "$FIRSTLINE U"


#---------------- Write first line and optional command lines------
echo $FIRSTLINE
echo T $TRATIO 
if ($JMBLE == Y) echo J $JSEED 
if ($SPOUT == Y)  echo O $OUTGRP 

#--------------- Write sequence part of file ----------------------
   #tail +2 $INFILE 
   # We can no longer use tail +n because the syntax is no longer consistent
   # between Unix and Linux
   @ NUMLINES = (`wc -l $INFILE | sed -e "s/^[ ]*//" | cut -f1 -d" "`) - 1
   tail -$NUMLINES $INFILE 
   
#--------------- Write user treefile, if supplied ----------------------
if ($USERTREE == Y) then 
   # Make sure that treefile begins with number of trees on first
   # line of file. If first line in file has parentheses, the
   # number must be added.
   if (`head -1 $UFN | grep '('` != "" ) then
      grep ';' $UFN | wc -l 
   endif
   cat $UFN 
endif





