#!/usr/local/bin/python
# November 29, 2004, Dr. Brian Fristensky, University of Manitoba

# Description: Convert a GDE flat file to a file of tokens.
# The input file contains a single nonblank
# string on each line.

# Synopsis: list2flat.py infile outfile

# Files: infile      GDE flat file, containing a comma separated
#                    list of tokens
#        outfile     file of tokens

import sys
import string
import os.path

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Read in old and new strings, striping 
# leading and trailing whitespace, including
# newline characters.
def GETGDELIST(FN) :

    FILE = open(FN,'r')
    # skip name line
    LINE = FILE.readline()
    
    # GDE wraps the flat file with newlines every 60
    # characters. 
    # Next, we have to delete the newlines to turn the entire
    # file into a single long string called BIGLINE
    BIGLINE = "" 
    LINE = FILE.readline()
    while (LINE != '') :
          LINE = LINE.strip()
	  BIGLINE = BIGLINE + LINE
	  LINE = FILE.readline()
  
    # parse the string as a comma separated list
    LST = BIGLINE.split(',')

    FILE.close()
    return LST

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Write the list as a single line of comma-separated values
def WRITENAMEFILE(FN,LST) :
    if len(LST) > 0:
       for i in range(0,len(LST)) :
           LINE = LST[i].strip()
	   if LINE != "" :
              LINE = LINE + '\n'	   
              OUTFILE.write(LINE)

    
#======================== MAIN PROCEDURE ==========================

#---------- Set global variables
IFN = sys.argv[1]
OFN = sys.argv[2]
OUTFILE = open(OFN,'w')

if os.path.exists(IFN) :

   # Read in GDE flat file
   IDLIST = GETGDELIST(IFN)

   #Write the list with one token per line
   WRITENAMEFILE(OUTFILE,IDLIST)

OUTFILE.close()



