#!/usr/local/bin/python
# January 4, 2006, Dr. Brian Fristensky, University of Manitoba

" Description: Convert a GDE flat file to a file of trees."


" Synopsis: flat2tree.py infile outfile"

# Files: infile      GDE flat file, containing one tree per line
#        outfile     file of trees

import sys
import string
import os.path

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Read in old and new strings, striping 
# leading and trailing whitespace, including
# newline characters.
def GETTREES(FN) :

    FILE = open(FN,'r')
    # skip name line
    LINE = FILE.readline()
    TREES = []
    # GDE wraps the flat file with newlines every 60
    # characters. 
    # Therefore, we read through the file, ignoring any name
    # lines which begin with (") and concatenating lines
    # together, until the line read ends in (;), indicating
    # the end of a tree. We add this BIGLINE to TREES, and
    # reset BIGLINE to empty.
    BIGLINE = "" 
    LINE = FILE.readline()
    while (LINE != '') :
          LINE = LINE.strip()
          if  LINE.startswith('\"') :
             pass
          else :
	     BIGLINE = BIGLINE + LINE
             if BIGLINE.endswith(';'):
                TREES.append(BIGLINE)
                BIGLINE= ""
	  LINE = FILE.readline()
  

    FILE.close()
    return TREES

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Write one tree per line
def WRITETREEFILE(FN,LST) :
    if len(TREES) > 0:
       for T in TREES :
           LINE = T.strip()
	   if LINE != "" :
              LINE = LINE + '\n'	   
              OUTFILE.write(LINE)

    
#======================== MAIN PROCEDURE ==========================

#---------- Set global variables
IFN = sys.argv[1]
OFN = sys.argv[2]
OUTFILE = open(OFN,'w')

if os.path.exists(IFN) :

   # Read in GDE flat file containing trees
   TREES = GETTREES(IFN)

   #Write one tree per line, stripping out the names
   WRITETREEFILE(OUTFILE,TREES)

OUTFILE.close()



