#!/usr/local/bin/python
# September 22, 2004, Dr. Brian Fristensky, University of Manitoba

# Description: Convert a GDE flatfile into another format 

# Synopsis: flatcnv.py infile outfile

# Files: infile      GDE flat file, with name on line 1, followed by
#                    comma separated list of tokens GI numbers
#        outfile     GDE flat file, with name on line 1, followed by
#                    comma-separated list of integers 

import sys
import string
import os

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
class Parameters :
      "Wrapper class for command line parameters"
      def __init__(self) :
          self.IFN = ""
          self.OFN = ""
	  self.OUTTYPE = ""

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
class FILE :
      "Wrapper class for files"
     
      def __init__(self,FILENAME,MODE) :
          self.FN = FILENAME
	  self.F = open(FILENAME,MODE)
	  self.LINE = "" # most recent line read

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
def READARGS(P) :
    "Read command line arguments into a Parameter object"
    NUMARGS = len(sys.argv)
    I = 1
    while (I < NUMARGS)  :
	  if sys.argv[I] == "-csv" :
             I = I + 1
             P.OUTTYPE = "csv"
	  elif sys.argv[I] == "-list" :
             I = I + 1
             P.OUTTYPE = "list"
	  else :
	     if P.IFN == "" :
	        P.IFN = sys.argv[I]
             else :
	        P.OFN = sys.argv[I]
             I = I + 1	             	
    return

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
class IDLST :
      "Wrapper class for ID lists"
     
      def __init__(self) :
          self.NAME = ""
	  self.LST = []
	  	  
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Read in old and new strings, striping 
# leading and trailing whitespace, including
# newline characters.
def GETGDELIST(INFILE,NAMEFLAG,L) :

    # Read name line
    while (INFILE.LINE != "" and L.NAME == "") :
          INFILE.LINE = INFILE.LINE.strip()
	  if len(INFILE.LINE) > 0 :
             if INFILE.LINE[0] == NAMEFLAG :
                L.NAME = INFILE.LINE[1:]
          INFILE.LINE = INFILE.F.readline()	  
    
    # Read GI list 
    L.LST = []   
    if L.NAME != "" :
       # GDE wraps the flat file with newlines every 60
       # characters. 
       # Next, we have to delete the newlines to turn the entire
       # file into a single long string called BIGLINE
       BIGLINE = ""  
       # Python 2.3 introduced a boolean type, but we'll do it
       # the crude way for backward compatability.
       DONE =  0     
       while (INFILE.LINE != "" and DONE == 0) :
             TMPLINE = INFILE.LINE.strip()
	     if len(TMPLINE) > 0 :
	        if TMPLINE[0] == NAMEFLAG :
		   DONE = 1
	        else:
		   BIGLINE = BIGLINE + TMPLINE
	           INFILE.LINE = INFILE.F.readline()

       # parse the string as a comma separated list
       L.LST = BIGLINE.split(',')

    return


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Write the list as a single line of comma-separated values
def WRITECSVFILE(F,L) :
    # Write name
    if L.NAME != "" :
       F.write(L.NAME)
    # Write list
    LEN = len(L.LST)
    if  LEN > 0 :
       F.write(',')
       for i in range(0,LEN) :
           F.write(L.LST[i])
	   if i < LEN-1 :
	      F.write(",")	   
    F.write('\n')
	      
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Write the list with one item per line
def WRITENAMEFILE(F,LST) :
    if len(LST) > 0:
       for i in range(0,len(LST)) :
           LINE = LST[i].strip()
           if LINE != "" :
              LINE = LINE + '\n'           
              F.write(LINE)
	      
	        
#======================== MAIN PROCEDURE ==========================

#---------- Set global variables
P = Parameters ()
READARGS(P)

NAMEFLAG = '"'  # 1st character on the name line, indicating
                # the beginning of the next data list

INFILE = FILE(P.IFN,'r')
OUTFILE = FILE(P.OFN,'w')


INFILE.LINE = INFILE.F.readline() # LINE contains the most recently-read line

while (INFILE.LINE != "") :

   # Read in GDE flat file
   L = IDLST()
   GETGDELIST(INFILE,NAMEFLAG,L)
      
   #Write the list
   if P.OUTTYPE == "list" :
      WRITENAMEFILE(OUTFILE.F,L.LST)
   else :
      WRITECSVFILE(OUTFILE.F,L)


INFILE.F.close()
OUTFILE.F.close()



