<?xml version='1.0' encoding='ISO-8859-1'?>

<!-- =============================================================== -->
<!--                                                                 -->
<!-- This XSLT stylesheet is part of the Seahawk data                -->
<!-- visualization project. http://bluejay.ucalgary.ca               -->
<!--                                                                 -->
<!-- It produces an XHTML 1.1 file from the MOBY data format. This   -->
<!-- type of data is generated by running MOBY clients such as the   -->
<!-- jMOBY MobyRequest (see http://www.biomoby.org/).                -->
<!--                                                                 -->
<!-- The XHTML built by this document includes style in HTML 3.2     -->
<!-- format so that the output can be displayed on even primitive    -->
<!-- HTML browser, such as Java's JEditorPane.                       -->
<!--                                                                 -->
<!-- MOBY data version taken into account on 2003-05-26:             -->
<!--                                                                 -->
<!--     Author: Paul Gordon (gordonp@ucalgary.ca)                   -->
<!--                                                                 -->
<!-- Note that most of the XPath statements in this stylesheet allow -->
<!-- elements and attributes to either have the moby namespace or    -->
<!-- none-at-all.  We are being lenient, but you really should       -->
<!-- assign data to the moby namespace when you're creating          -->
<!-- documents.  Please!                                             -->
<!--                                                                 -->
<!-- This stylesheet may not be redistributed without the author's   -->
<!-- consent, in whole or in part, but may be used freely with no    -->
<!-- warranty of ANY KIND.                                           -->
<!--                                                                 -->
<!-- =============================================================== -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0"
                xmlns:moby="http://www.biomoby.org/moby"
	        xmlns:mobys="http://www.biomoby.org/moby-s">

<!-- Normally, the calling transformer would pass in the URL for the moby document.
  it is used by the stylesheet as part of the XPointer to the original data in the HTML
  output. -->
<xsl:param name="sourceURL" select="''"/>

<!-- Output is actually XHTML 1.1 -->
<xsl:output method="html"
            version="3.2"
            indent="yes"
            encoding="ISO-8859-1"/>

  <!-- This is for the midline elements top come later on in
       the templates.  Spaces there are part of the alignment,
       and therefore should not be lost!  -->
      <xsl:preserve-space elements="*" />

  <!-- ****************************************************** -->
  <!-- * Root template. Sets page layout.                   * -->
  <!-- ****************************************************** -->

  <xsl:template match="moby:mobyContent | mobys:MobyContent">
       <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
       <head>
         <meta name="Author" content="Paul Gordon/Seahawk" />
       </head>

       <body>
         <xsl:if test="@moby:authority | @mobys:authority | @authority">
           <h2 id="start"><a href="http://www.biomoby.org">MOBY</a> Data from <xsl:value-of select="@moby:authority | @mobys:authority | @authority" />
           </h2>
         </xsl:if>

       <xsl:apply-templates select="moby:serviceNotes | serviceNotes | mobys:serviceNotes | moby:ServiceNotes | moby:ServiceNotes | mobys:ServiceNotes"/>
    
    <xsl:variable name="num_elements" select="count(moby:mobyData | mobys:mobyData | mobyData)" />
    <xsl:choose>
      <xsl:when test="$num_elements = 1">
        <p>The MOBY data is:</p>
      </xsl:when>
      <xsl:when test="$num_elements > 1">
        <p>There are <xsl:value-of select="$num_elements" /> data sets:</p>
      </xsl:when>
      <xsl:otherwise>
        <p>Sorry, there is no MOBY data to present.  Please try another query/selection, or
           contact the service provider.</p> 
      </xsl:otherwise>
    </xsl:choose>

         <!-- For each child MOBY data block (corresponding usually to 
              multiple input queries submitted at once), process and
              display as a table -->
         <xsl:apply-templates select="moby:mobyData | mobys:mobyData | mobyData"/>

         <!-- HTML output footer/end -->
       </body>
       </html>
  </xsl:template> <!-- end base template -->

  <!-- ServiceNotes have things like bibliographic or credit information in them
       for the service being provided, also excpetions are held here -->
  <xsl:template match="moby:serviceNotes | mobys:serviceNotes | serviceNotes">
    <p>
     <xsl:variable name="exceptions" select="moby:mobyException | mobys:mobyException | mobyException"/>
     <xsl:choose>
      <xsl:when test="count($exceptions) > 0">
        <table width="100%" border="0" cellspacing="0">
          <xsl:apply-templates select="$exceptions"/>
        </table>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="." disable-output-escaping="yes" />
      </xsl:otherwise>
     </xsl:choose>
    </p>
  </xsl:template>

  <xsl:template match="moby:mobyException | mobys:mobyException | mobyException">

    <xsl:variable name="severity" select="@severity"/>
    <xsl:choose>
      <xsl:when test="$severity = 'error'">
        <tr bgcolor="red"><th colspan="2">Error</th> </tr>
      </xsl:when>
      <xsl:when test="$severity = 'warning'">
        <tr bgcolor="yellow"><th colspan="2">Warning</th></tr>
      </xsl:when>
      <xsl:otherwise>
        <tr bgcolor="#A0A0A0"><th colspan="2">Information on this Service Call</th></tr>
      </xsl:otherwise>
    </xsl:choose>

    <tr bgcolor="#808080"><th colspan="2">
    <xsl:variable name="query" select="@refQueryID"/>
    <xsl:if test="string-length($query) > 0">
      Query "<xsl:value-of select="$query"/>"
    </xsl:if>
    <xsl:variable name="ref" select="@refElement"/>
    <xsl:if test="string-length($ref) > 0">
      Input "<xsl:value-of select="$ref"/>"
    </xsl:if>
    </th></tr>

    <tr bgcolor="#F0FFE0">
    <xsl:variable name="code" select="moby:exceptionCode | mobys:exceptionCode | exceptionCode" />
    <xsl:variable name="message" select="moby:exceptionMessage | exceptionMessage" />
    <xsl:choose>
      <xsl:when test="starts-with($code, '2')">
        <td>Input Data Issue(<xsl:value-of select="$code"/>):</td> 
      </xsl:when>
      <xsl:when test="starts-with($code, '3')">
        <td>Execution/Server Issue(<xsl:value-of select="$code"/>):</td> 
      </xsl:when>
      <xsl:when test="starts-with($code, '4')">
        <td>Metadata Issue(<xsl:value-of select="$code"/>):</td> 
      </xsl:when>
      <xsl:when test="starts-with($code, '5')">
        <td>Notification/Protocol Issue(<xsl:value-of select="$code"/>):</td> 
      </xsl:when>
      <xsl:when test="starts-with($code, '6')">
        <td>General Issue(<xsl:value-of select="$code"/>):</td> 
      </xsl:when>
      <xsl:when test="starts-with($code, '7')">
        <td>Service Intrinsic Issue(<xsl:value-of select="$code"/>):</td> 
      </xsl:when>
      <xsl:otherwise>
        <td><xsl:value-of select="$code"/>:</td> 
      </xsl:otherwise>
    </xsl:choose>

       <td><xsl:value-of select="moby:exceptionMessage | mobys:exceptionMessage | exceptionMessage"/></td>
    </tr>
  </xsl:template>

  <!-- ****************************************************** -->
  <!-- * Wrapper element for each query response            * -->
  <!-- ****************************************************** -->

  <xsl:template match="moby:mobyData | mobys:mobyData | mobyData">

    <!-- Create the hit summary information  -->
    <table width="100%" border="1" cellpadding="2" cellspacing="0">
      <tr align="left" colspan="2"><th>MOBY Data for query 
      <xsl:value-of select="@moby:queryID | @mobys:queryID | @queryID"/>
      </th></tr>

      <!-- One row per top level child of the mobyData, either Simples 
           or Collections (basically arrays), do HTML setup -->
      <xsl:for-each select="moby:Collection | @mobys:Collection | Collection | moby:Simple | mobys:Simple | Simple">

        <!-- Alternate row colors for readability -->
        <xsl:choose>
	  <xsl:when test="position() mod 2 = 0">
            <tr bgcolor="#EEEEAA">
              <!-- Apply the appropriate templates for the row contents -->
              <td><xsl:apply-templates select="."/></td>
            </tr>
	  </xsl:when>
	  <xsl:otherwise>
            <tr bgcolor="#DCDDAA">
              <!-- Apply the appropriate template (Simple or Collection) for the row contents -->
              <td><xsl:apply-templates select="."/></td>
            </tr>
	  </xsl:otherwise>
        </xsl:choose>

      </xsl:for-each>
    </table>  

  </xsl:template>  <!-- end mobyData template -->

  <!-- ****************************************************** -->
  <!-- * Prints the contents of the template data elements  * -->
  <!-- ****************************************************** -->

  <xsl:template match="moby:Simple | mobys:Simple | Simple">
    <xsl:apply-templates select="*" mode="elucidate"/>
  </xsl:template> <!-- end Simple template -->

  <xsl:template match="moby:CrossReference | mobys:CrossReference | CrossReference" mode="elucidate">
    <br />Xref: <xsl:apply-templates select="*" mode="elucidate"/>
  </xsl:template>

  <!-- Base Object class, has a namespace and ID. That's it. -->
  <xsl:template match="moby:Object | mobys:Object | Object" mode="elucidate">
    <a href="http://moby/{@moby:namespace | @mobys:namespace | @namespace}?id={@moby:id | @mobys:id | @id}&amp;name={@moby:articleName | @mobys:articleName | @articleName}">ID <xsl:value-of select="@moby:namespace | @mobys:namespace | @namespace"/>:<xsl:value-of select="@moby:id | @mobys:id | @id"/> (<xsl:value-of select="@moby:articleName | @mobys:articleName | @articleName"/>)</a><xsl:text> </xsl:text>
    <xsl:apply-templates select="moby:CrossReference | mobys:CrossReference | CrossReference" mode="elucidate"/>
  </xsl:template> <!-- end Object template -->

  <xsl:template match="moby:String | mobys:String | String" mode="elucidate">
    <xsl:variable name="xptr"><xsl:call-template name="getXPointer"/></xsl:variable>
    <a href="{$sourceURL}#{$xptr}">String <xsl:if test="string-length(@moby:namespace | @mobys:namespace | @namespace)"><xsl:value-of select="@moby:namespace | @mobys:namespace | @namespace"/>:</xsl:if><xsl:if test="string-length(@moby:id | @mobys:id | @id)"><xsl:value-of select="@moby:id | @mobys:id | @id"/> </xsl:if>(<xsl:value-of select="@moby:articleName | @mobys:articleName | @articleName"/>)</a>: <xsl:value-of select="."/><br/>
    <xsl:apply-templates select="moby:CrossReference | mobys:CrossReference | CrossReference" mode="elucidate"/>
  </xsl:template> <!-- end String template -->

  <xsl:template match="moby:Integer | mobys:Integer | Integer | moby:Float | mobys:Float | Float | moby:Boolean | mobys:Boolean | Boolean | moby:DateTime | mobys:DateTime | DateTime" mode="elucidate">
    <xsl:value-of select="@moby:articleName | @mobys:articleName | @articleName"/>: <xsl:value-of select="."/><br/>
  </xsl:template> <!-- end Integer template -->

  <!-- Should match more complex objects -->
  <xsl:template match="*" mode="elucidate">
    <xsl:variable name="num_members" select="count(*)"/>
    <xsl:variable name="xptr"><xsl:call-template name="getXPointer"/></xsl:variable>
    <table border="1"><tr><th align="left" colspan="{$num_members+1}"><a href="{$sourceURL}#{$xptr}">
    <xsl:value-of select="local-name(.)"/> (ID <xsl:value-of select="@moby:namespace | @mobys:namespace | @namespace"/>:<xsl:value-of select="@moby:id | @mobys:id | @id"/>)</a></th></tr>
    <xsl:for-each select="*">
      <tr><td><xsl:apply-templates select="." mode="elucidate"/></td></tr>
    </xsl:for-each>
    </table>
  </xsl:template> <!-- end Simple template -->

  <!-- ******************************************************* -->
  <!-- * Prints the cardinality of the set, then its members * -->
  <!-- ******************************************************* -->
  <!-- A collection is just provides an array facility in MOBY for Simples -->

  <xsl:template match="moby:Collection | mobys:Collection | Collection">
    <xsl:variable name="xptr"><xsl:call-template name="getXPointer"/></xsl:variable>
    <xsl:variable name="itemcount" select="count(moby:Simple | mobys:Simple | Simple)"/>
      <a href="{$sourceURL}#{$xptr}">Collection</a> of <xsl:value-of select="$itemcount"/> data element<xsl:if test="$itemcount != 1">s</xsl:if> <br/>
    <ol>
    <xsl:for-each select="moby:Simple | mobys:Simple | Simple">
      <li><xsl:apply-templates select="."/></li>
    </xsl:for-each>
    </ol>
  </xsl:template> <!-- end Collection template -->

<!-- utility to get an xpointer for the source node-->
<xsl:template name="getXPointer">
   <xsl:param name="node" select="."/>
   <xsl:param name="suffix" select="''"/>

   <xsl:choose>
   <xsl:when test="generate-id($node) = generate-id(/)">
      <!-- document root, end recursion -->
      <xsl:value-of select="$suffix"/>
   </xsl:when>
   <xsl:otherwise>
      <xsl:for-each select="$node/../*">
         <xsl:choose>
         <xsl:when test="generate-id($node) = generate-id(.)">
	      <xsl:call-template name="getXPointer">
               <xsl:with-param name="node"
		              select="$node/.."/>
		<xsl:with-param name="suffix" select="concat('/', position(), $suffix)"/>
		</xsl:call-template>
	   </xsl:when>
         </xsl:choose>
      </xsl:for-each>
   </xsl:otherwise>
   </xsl:choose>

</xsl:template>

</xsl:stylesheet>
