/*
 * Copyright @ 2001-2003, The Institute for Genomic Research (TIGR).
 * All rights reserved.
 *
 * DatPrep.java
 *
 * Created on April 15, 2003, 11:04 AM
 * @author  wliang
 * @version
 */

package org.tigr.midas.engine;

import java.io.*;
import java.util.*;
import java.math.*;
import java.lang.*;
import org.tigr.midas.math.*;
import org.tigr.midas.util.*;

public class DataPrep {
    
    private int totalRowCount;
    private int nonZeroCount;
    private int zeroCount;
    private boolean[] flag;
    private float[] cy3Column;
    private float[] cy5Column;
    private float[] wholeLogRatio;
    private float[] wholeLogProd;
    private float[] nonZeroLogRatio;
    private float[] nonZeroLogProd;
    private float[] sortedLogProd;
    private float[] newNonZeroLogRatio;
    private int[] nonZeroRawIdx;
    private int[] newNonZeroRawIdx;
    private CyToLogProdRatio cyTran;
    
    public DataPrep(ColumnWorker fileCW) {

        totalRowCount = fileCW.getRowCounts();
        cy3Column = fileCW.getColumnOneArray();
        cy5Column = fileCW.getColumnTwoArray();
        flag = fileCW.getRowFlagArray();
        
        convert(cy3Column, cy5Column);
    }
    
    public DataPrep(float[] a, float[] b){
        totalRowCount = a.length;
        flag = new NegateFlags(new boolean[totalRowCount]).getNegateFlag();
        
        convert(a, b);
    }
        
    private void convert(float[] x, float[] y){
        
        cyTran = new CyToLogProdRatio(x, y, flag);
        
        wholeLogRatio = new float[totalRowCount];
        nonZeroLogRatio = new float[totalRowCount];
        wholeLogProd = new float[totalRowCount];
        nonZeroLogProd = new float[totalRowCount];
        nonZeroRawIdx = new int[totalRowCount];
        nonZeroCount = 0;
        
        for (int rowIndex = 0; rowIndex < totalRowCount; rowIndex ++){
            //System.out.println("~~~~ rowIndex = " + rowIndex + ", x = " + x[rowIndex] + ", y = " + y[rowIndex]);
            if( (x[rowIndex] <= 1) || (y[rowIndex] <= 1) || !flag[rowIndex]){
                x[rowIndex] = 0;
                y[rowIndex] = 0;
                wholeLogRatio[rowIndex] = 0;
                wholeLogProd[rowIndex] = 0;
            }else{
                wholeLogRatio[rowIndex] = MathTools.log2(y[rowIndex]/x[rowIndex]);
                wholeLogProd[rowIndex] = MathTools.log10(y[rowIndex]*x[rowIndex]);
                nonZeroLogRatio[nonZeroCount] = wholeLogRatio[rowIndex];
                nonZeroLogProd[nonZeroCount] = wholeLogProd[rowIndex];
                nonZeroRawIdx[nonZeroCount] = rowIndex;
                nonZeroCount++;
                //System.out.println("~~~~ nonZeroIndex incremented.");
            }
        }
        System.out.println("    ---- totalRowCount = " + totalRowCount);
        System.out.println("    ---- nonZeroCount = " + nonZeroCount);
        
        nonZeroLogProd = new ArrayResizer(nonZeroLogProd, nonZeroCount).getFArray();
        nonZeroLogRatio = new ArrayResizer(nonZeroLogRatio, nonZeroCount).getFArray();
        nonZeroRawIdx = new ArrayResizer(nonZeroRawIdx, nonZeroCount).getIArray();
        
        //****** Sort *******
        QSort sort = new QSort(nonZeroLogProd);
        sortedLogProd = sort.getSorted();
        int[] bb = sort.getOrigIndx();
        newNonZeroLogRatio = new float[sortedLogProd.length];
        newNonZeroRawIdx = new int[sortedLogProd.length];
        for (int i = 0; i < sortedLogProd.length; i++){
            newNonZeroLogRatio[i] = nonZeroLogRatio[bb[i]];
            newNonZeroRawIdx[i] = nonZeroRawIdx[bb[i]];
        }
    }
    
    public int getNonZeroCount(){
        return nonZeroCount;
    }
    
    public float[] getX(){
        return cy3Column;
    }
    
    public float[] getY(){
        return cy5Column;
    }
    
    public float[] getLogX(){
        return cyTran.getLogX();
    }
    
    public float[] getLogY(){
        return cyTran.getLogY();
    }
    
    public float[] getLogProd(){
        return sortedLogProd;
    }
    
    public float[] getLogRatio(){
        return newNonZeroLogRatio;
    }
    
    public int[] getRawNdx(){
        return newNonZeroRawIdx;
    }
    
}
