/*
 * Copyright @ 2001-2003, The Institute for Genomic Research (TIGR).
 * All rights reserved.
 *
 *
 * IterLinReg.java
 *
 * Created on February 5, 2003, 2:58 PM
 * @author  wliang
 * @version
 */

package org.tigr.midas.engine;

import java.io.*;
import java.util.*;
import java.math.*;
import java.lang.*;
// Mod for MeV import org.tigr.midas.display.*;
import org.tigr.midas.math.*;
import org.tigr.midas.util.*;
import org.tigr.midas.Constant;

public class IterativeLinReg extends Module {
    
    private ColumnWorker fCW;
    //private int totalRowCount;
    private float[] cy3Column;
    private float[] cy5Column;
    private float[] logCy3;
    private float[] logCy5;
    private boolean[] inputFlag;
    private float slope;
    private float intercept;
    private String linearEquation;
    private String[] linearEquations;
    private float r2;
    private float[] r2s;
    private int m = 0;
    private int[] ms;
    
    //private String preName = "";
    //private String postName = "";
    //private int processedCount = 0;
    
    public IterativeLinReg(ColumnWorker fileCW, float nSD, String processMode, String ref) throws Exception {
        
        super();

        /*
        FileBrowser projFolderFB = new FileBrowser(proj.getProjPath(), Constant.READ_FILE);
        String iterLinRegFB = projFolderFB.createSubDir("iter_linear_regression");
        */
        
        //Output pre-normalization RI results
        //DataPrep dataPrep;
        //DataReporter dr;
        //String prePrcName = super.proj.getProjPath() + "iter_linear_regression" + FileBrowser.fsep + fileCW.getFileName() + "_pre.prc";
        //dataPrep = new DataPrep(fileCW);
        //dr = new DataReporter(preName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
        
        try{
            fCW = fileCW;

            cy3Column = fCW.getColumnOneArray();
            cy5Column = fCW.getColumnTwoArray();
            int totalRowCount = fCW.getRowCounts();
            
            boolean[] tempFlag = fCW.getRowFlagArray();
            inputFlag = new boolean[tempFlag.length];
            System.arraycopy(tempFlag, 0, inputFlag, 0, tempFlag.length);
            
            boolean[] iterLogFlag = new boolean[fileCW.getRowCounts()];
            iterLogFlag = new NegateFlags(iterLogFlag).getNegateFlag();
            iterLogFlag = new AndFlags(iterLogFlag, inputFlag).getAndFlag();
            
            System.out.println("    Pre-normalized global results outputing ...");

            //  Mod for MeV DataReporter dr;
            DataPrep dataPrep;
            /*  Mod for MeV
            String preLtyName = super.proj.getProjPath() + "iter_linear_regression" + FileBrowser.fsep + fileCW.getFileName() + "_pre.lty";
            String prePrcName = super.proj.getProjPath() + "iter_linear_regression" + FileBrowser.fsep + fileCW.getFileName() + "_pre.prc";
            */
            dataPrep = new DataPrep(fileCW);
            // Mod for MeV dr = new DataReporter(prePrcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            CyToLogProdRatio cyTran = new CyToLogProdRatio(cy3Column, cy5Column, inputFlag);
            // Mod for MeV dr = new DataReporter(preLtyName, cyTran.getLogX(), cyTran.getLogY());
            
            StatsTools s = new StatsTools();
            
            if (processMode.equalsIgnoreCase("block")){
                BlockFiller blockFiller = new BlockFiller(fileCW);
                totalRowCount = fCW.getRowCounts();
                int blockNumber = blockFiller.getBlockNumber();
                linearEquations = new String[blockNumber];
                r2s = new float[blockNumber];
                ms = new int[blockNumber];
                float[] blockCy3Column;
                float[] blockCy5Column;
                
                for (int blockCount = 0; blockCount < blockNumber; blockCount++){
                    blockCy3Column = blockFiller.getBlockCy3(blockCount);
                    blockCy5Column = blockFiller.getBlockCy5(blockCount);
                    int[] blockRawNdx = blockFiller.getOrigIndex(blockCount);
                    int blockSize = blockFiller.getBlockSize(blockCount);
                    System.out.println("    ============================");
                    System.out.println("              Block " + blockCount);
                    System.out.println("    ============================");
                    
                    float[] residue = new float[blockSize];
                    float[] logCy3;
                    float[] logCy5;
                    float lastR2 = 1.0f;
                    r2 = 0.0f;
                    slope = 0.0f;
                    intercept = 0.0f;
                    int residueCount = 0;
                    m = 0;
                    
                    while (true){
                        
                        if ( (Math.abs(lastR2 - r2) <= 0.001) ){                             //Convergent condition reached
                            //Get linear equation
                            System.out.println("    *********************************");
                            linearEquations[blockCount] = "log(cy5) = log(cy3) * " + slope + " + " + intercept;
                            r2s[blockCount] = r2;
                            ms[blockCount] = m;
                            System.out.println("    Block final linear equation: " + linearEquations[blockCount]);
                            break;
                        }else if (m > 100){                                                 //Avoid dead iteration, max iteration number = 100
                            //Get linear equation
                            System.out.println("    *********************************");
                            System.out.println("    Maximum iteration number 100 reached! ");
                            linearEquations[blockCount] = "log(cy5) = log(cy3) * " + slope + " + " + intercept;
                            r2s[blockCount] = r2;
                            ms[blockCount] = m;
                            System.out.println("    Block final linear equation: " + linearEquations[blockCount]);
                            break;
                        }else{
                            if (m > 0) System.out.println("    residueCount        = " + residueCount);
                            lastR2 = r2;
                            m++;
                        }
                        
                        //log-transformation for cy3 and cy5
                        cyTran = new CyToLogProdRatio(blockCy3Column, blockCy5Column, blockRawNdx, iterLogFlag);
                        logCy3 = cyTran.getLogX();
                        logCy5 = cyTran.getLogY();
                        
                        //Linear regression on (log-cy3, log-cy5)
                        s.linearRegression(logCy3, logCy5);
                        slope = s.getSlope();
                        intercept = s.getIntercept();
                        r2 = s.getCorrelationCoeff() * s.getCorrelationCoeff();
                        System.out.println("    ------ iteration " + m + " ------");
                        System.out.println("    Datasize            = " + s.getDataSize());
                        System.out.println("    Slope               = " + slope);
                        System.out.println("    Intercept           = " + intercept);
                        System.out.println("    Corr.Coeff^2        = " + r2);
                        
                        //Get residue for each gene
                        for (int ndx = 0; ndx < blockSize; ndx++){
                            if (blockCy3Column[ndx] > 1 && blockCy5Column[ndx] > 1 && iterLogFlag[blockRawNdx[ndx]]){
                                residue[ndx] = Math.abs(MathTools.log10(blockCy5Column[ndx]) - (MathTools.log10(blockCy3Column[ndx]) * slope + intercept));
                            }else{
                                residue[ndx] = 0;
                            }
                        }
                        
                        //Get smaller data set by removing outliers with residue > nSD of residue spread
                        s.computeMeanSDforNonZero(residue);
                        residueCount = 0;
                        for (int ndx = 0; ndx < blockSize; ndx++){
                            if ( iterLogFlag[blockRawNdx[ndx]] & (Math.abs(residue[ndx]) < (s.getXSD() * nSD)) ){
                                iterLogFlag[blockRawNdx[ndx]] = true;
                                residueCount++;
                            }else{
                                iterLogFlag[blockRawNdx[ndx]] = false;
                            }
                        }
                    }
                    
                    //Use linear equation to normalize
                    if (ref.equalsIgnoreCase("Cy3")){         //We will change cy5 column
                        for (int ndx = 0; ndx < blockSize; ndx++){
                            if( (blockCy3Column[ndx] == 0) || (blockCy5Column[ndx] == 0) || !inputFlag[blockRawNdx[ndx]] ){
                            }else{
                                //System.out.println("--" + blockRawNdx[ndx]);
                                //blockCy5Column[ndx] = Math.pow(10.0, (MathTools.log10(blockCy5Column[ndx])-intercept)/slope);
                                cy5Column[blockRawNdx[ndx]] = (float)Math.pow(10.0, (MathTools.log10(cy5Column[blockRawNdx[ndx]])-intercept)/slope);
                            }
                        }
                    }else{                                                      //We will change cy3 column
                        for (int ndx = 0; ndx < blockSize; ndx++){
                            if( (blockCy3Column[ndx] == 0) || (blockCy5Column[ndx] == 0) || !inputFlag[blockRawNdx[ndx]] ){
                            }else{
                                blockCy3Column[ndx] = (float)Math.pow(10.0, MathTools.log10(blockCy3Column[ndx]) * slope + intercept);
                                cy3Column[blockRawNdx[ndx]] = (float)Math.pow(10.0, MathTools.log10(cy3Column[blockRawNdx[ndx]]) * slope + intercept);
                            }
                        }
                    }
                }
                
            }else{
                float[] residue = new float[totalRowCount];
                float[] logCy3;
                float[] logCy5;
                float lastR2 = 1.0f;
                r2 = 0.0f;
                slope = 0.0f;
                intercept = 0.0f;
                int residueCount = 0;
                
                while (true){
                    
                    if ( (Math.abs(lastR2 - r2) <= 0.001)){                             //Convergent condition reached
                        //Get linear equation
                        linearEquation = "log(cy5) = log(cy3) * " + slope + " + " + intercept;
                        System.out.println("    *********************************");
                        System.out.println("    Final linear equation: " + linearEquation);
                        break;
                    }else if (m > 100){                                                 //Avoid dead iteration, max iteration number = 100
                        //Get linear equation
                        linearEquation = "log(cy5) = log(cy3) * " + slope + " + " + intercept;
                        System.out.println("    *********************************");
                        System.out.println("    Maximum iteration number 100 reached! ");
                        System.out.println("    Final linear equation: " + linearEquation);
                        break;
                    }else{
                        if (m > 0) System.out.println("    residueCount        = " + residueCount);
                        lastR2 = r2;
                        m++;
                    }
                    
                    //log-transformation for cy3 and cy5
                    cyTran = new CyToLogProdRatio(cy3Column, cy5Column, iterLogFlag);
                    logCy3 = cyTran.getLogX();
                    logCy5 = cyTran.getLogY();
                    
                    //Linear regression on (log-cy3, log-cy5)
                    s.linearRegression(logCy3, logCy5);
                    slope = s.getSlope();
                    intercept = s.getIntercept();
                    r2 = s.getCorrelationCoeff() * s.getCorrelationCoeff();
                    System.out.println("    ------ iteration " + m + " ------");
                    System.out.println("    Datasize            = " + s.getDataSize());
                    System.out.println("    Slope               = " + slope);
                    System.out.println("    Intercept           = " + intercept);
                    System.out.println("    Corr.Coeff^2        = " + r2);
                    
                    //Get residue for each gene
                    for (int rawNdx = 0; rawNdx < totalRowCount; rawNdx++){
                        if (cy3Column[rawNdx] > 1 && cy5Column[rawNdx] > 1 && iterLogFlag[rawNdx]){
                            residue[rawNdx] = Math.abs(MathTools.log10(cy5Column[rawNdx]) - (MathTools.log10(cy3Column[rawNdx]) * slope + intercept));
                        }else{
                            residue[rawNdx] = 0;
                        }
                    }
                    
                    //Get smaller data set by removing outliers with residue > nSD of residue spread
                    s.computeMeanSDforNonZero(residue);
                    residueCount = 0;
                    for (int rawNdx = 0; rawNdx < totalRowCount; rawNdx++){
                        if ( iterLogFlag[rawNdx] & (Math.abs(residue[rawNdx]) < (s.getXSD() * nSD)) ){
                            iterLogFlag[rawNdx] = true;
                            residueCount++;
                        }else{
                            iterLogFlag[rawNdx] = false;
                        }
                    }
                    
                    //Use linear equation to normalize
                    if (Parameter.pRefStr.equalsIgnoreCase("Cy3")){         //We will change cy5 column
                        for (int rawNdx = 0; rawNdx < totalRowCount; rawNdx++){
                            if( (cy3Column[rawNdx] == 0) || (cy5Column[rawNdx] == 0) || !inputFlag[rawNdx] ){
                            }else{
                                cy5Column[rawNdx] = (float)Math.pow(10.0, (MathTools.log10(cy5Column[rawNdx])-intercept)/slope);
                            }
                        }
                    }else{                                                      //We will change cy3 column
                        for (int rawNdx = 0; rawNdx < totalRowCount; rawNdx++){
                            if( (cy3Column[rawNdx] == 0) || (cy5Column[rawNdx] == 0) || !inputFlag[rawNdx] ){
                            }else{
                                cy3Column[rawNdx] = (float)Math.pow(10.0, MathTools.log10(cy3Column[rawNdx]) * slope + intercept);
                            }
                        }
                    }
                }
            }
            
            //Get normalized cy3 and cy5
            fCW.setColOneArray(cy3Column);
            fCW.setColTwoArray(cy5Column);
            System.out.println("    Post-normalized global results outputing ...");

            /* Mod for MeV
            String postLtyName = super.proj.getProjPath() + "iter_linear_regression" + FileBrowser.fsep + fileCW.getFileName() + "_post.lty";
            String postPrcName = super.proj.getProjPath() + "iter_linear_regression" + FileBrowser.fsep + fileCW.getFileName() + "_post.prc";
            */
            
            dataPrep = new DataPrep(fileCW);
            // Mod for MeV dr = new DataReporter(postPrcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            int outCount = dataPrep.getNonZeroCount();
            cyTran = new CyToLogProdRatio(cy3Column, cy5Column, inputFlag);
            // Mod for MeV dr = new DataReporter(postLtyName, cyTran.getLogX(), cyTran.getLogY());
          
            /* Mod for MeV
            Hashtable hash = new Hashtable();
            hash.put(new String("pre_lty_name"), preLtyName);
            hash.put(new String("pre_prc_name"), prePrcName);
            hash.put(new String("post_lty_name"), postLtyName);
            hash.put(new String("post_prc_name"), postPrcName);
            hash.put(new String("out_row_count"), new Integer(outCount));
            proj.insertReportItem("iter_lin_reg_for_" + fileCW.getFileName(), hash);
            */
            
            //Final normalized equation
            //s.linearRegression(cyTran.getLogX(), cyTran.getLogY());
            //slope = s.getSlope();
            //intercept = s.getIntercept();
            //r2 = s.getCorrelationCoeff() * s.getCorrelationCoeff();

        }catch (Exception ex){
            throw ex;
        }
        
        //Output post-normalization RI results
        
    }
    
    public final ColumnWorker getIterLinRegColumnWorker(){
        return fCW;
    }
    
    public final String getLinearEquation(){
        return linearEquation;
    }
    
    public final String[] getLinearEquations(){
        return linearEquations;
    }
    
    public final float getCorrCoeff(){
        return r2;
    }
    
    public final float[] getCorrCoeffs(){
        return r2s;
    }

    public static void main(String args[]) {
        try{
            ColumnWorker fileCW = new ColumnWorker("C:\\DataFiles0\\32K\\SimonData\\1233259D2F.tav");
            fileCW.setColumnsForMeta(2, 3);
            fileCW.setColumns(6, 7, 15, 16);
            fileCW.computeGoodRatiosAndLogRatios(0, 0);
            IterativeLinReg iterLinReg = new IterativeLinReg(fileCW, 2.0f, "block", "Cy3");
        }catch (FileNotFoundException nfex){
            nfex.printStackTrace();
        }catch (NumberFormatException nex){
            nex.printStackTrace();
        }catch (Exception ex){
            ex.printStackTrace();
        }
    }
    
}

