/*
 * Copyright @ 2001-2003, The Institute for Genomic Research (TIGR).
 * All rights reserved.
 *
 *
 * ArrayResizer.java
 *
 * Created on February 7, 2003, 11:30 AM
 * @author  wliang
 * @version 
 */

package org.tigr.midas.util;

import java.io.*;
import java.util.*;
import java.math.*;
import java.lang.*;

public class ArrayResizer {

    private float[] fArray;
    private int[] iArray;
    private boolean[] bArray;
    private String[] sArray;
    
    public ArrayResizer(float[] array, int newSize) {
        float[] t = new float[array.length];
        System.arraycopy(array, 0, t, 0, array.length);
        array = new float[newSize];
        System.arraycopy(t, 0, array, 0, newSize);    
        fArray = array;
    }
    
    public ArrayResizer(int[] array, int newSize) {
        int[] t = new int[array.length];
        System.arraycopy(array, 0, t, 0, array.length);
        array = new int[newSize];
        System.arraycopy(t, 0, array, 0, newSize);
        iArray = array;
    }
    
    public ArrayResizer(boolean[] array, int newSize) {
        boolean[] t = new boolean[array.length];
        System.arraycopy(array, 0, t, 0, array.length);
        array = new boolean[newSize];
        System.arraycopy(t, 0, array, 0, newSize);
        bArray = array;
    }
    
    public ArrayResizer(String[] array, int newSize) {
        String[] t = new String[array.length];
        System.arraycopy(array, 0, t, 0, array.length);
        array = new String[newSize];
        System.arraycopy(t, 0, array, 0, newSize);
        sArray = array;
    }
    
    public final float[] getFArray(){
        return fArray;
    }
    
    public final int[] getIArray(){
        return iArray;
    }
    
    public final boolean[] getBArray(){
        return bArray;
    }
    
    public final String[] getSArray(){
        return sArray;
    }
    
    public static void main(String args[]) {
        int[] x = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        float[] y = {0.9f, 1.8f, 3.1f, 4.3f, 4.8f, 5.9f, 7.2f, 8.0f, 9.2f, 9.9f};    
        boolean[] z = {true, false, true, true, true, false};
        String[] w = {"abc", "sdc", "ddf", "eer", "rrf", "nkn", "mnm"};
        ArrayResizer ar;
        
        ar = new ArrayResizer(x, 5);
        for (int i = 0; i < ar.getIArray().length; i++){
            System.out.println(ar.getIArray()[i]);
        }
    
        //y = new ArrayResizer(y, 5);
        for (int i = 0; i < new ArrayResizer(y, 5).getFArray().length; i++){
            System.out.println(new ArrayResizer(y, 5).getFArray()[i]);
        }
        
        ar = new ArrayResizer(z, 5);
        for (int i = 0; i < ar.getBArray().length; i++){
            System.out.println(ar.getBArray()[i]);
        }
        
        ar = new ArrayResizer(w, 5);
        for (int i = 0; i < ar.getSArray().length; i++){
            System.out.println(ar.getSArray()[i]);
        }
    }
}
