package embl.ebi.trace;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.zip.*;


/** 
This application aims to provide a simple way to 
display individual DNA sequence chromatograms (traces).
I hacked Eugen Buehler's original applet about to use
org.omg.CORBA methods to provide the input through an
applet, and then created this CORBA-free wrapper for 
local trace file viewing. 
@see ChromatogramViewer
@see TraceStore
@author Eugen Buehler buehler@agave.humgen.upenn.edu
@author Jeremy D. Parsons jparsons@ebi.ac.uk
*/

/**

Copyright (c) 1998 by European Bioinformatics Institute, Cambridge, UK.


You are hereby granted permission to use, copy, modify, and distribute 
this software and its documentation for any purpose and without fee,
provided that the above copyright notices appear in all copies and that 
both the above copyright notices and this permission notice appear in 
supporting documentation, and that neither the name of the European 
Molecular Biology Laboratory nor European Bioinformatics Institute are 
used in advertising or publicity pertaining to distribution of the 
software without specific written prior permission. You HEREBY AGREE 
THAT SINCE THE FOREGOING LICENCE IS GRANTED WITHOUT CHARGE, IT IS 
REASONABLE THAT THIS SOFTWARE IS PROVIDED "AS IS" AND THAT THE 
EUROPEAN MOLECULAR BIOLOGY LABORATORY AND EUROPEAN BIOINFORMATICS 
INSTITUTE DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, WITH REGARD TO 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED WARRANTIES OF 
SATISFACTORY QUALITY OR FITNESS FOR A PARTICULAR PURPOSE, AND IN NO 
EVENT SHALL THE EUROPEAN MOLECULAR BIOLOGY LABORATORY OR EUROPEAN 
BIOINFORMATICS INSTITUTE BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT 
(INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN 
CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

*************************************************************************/

public class TraceView extends Frame implements TraceRequestListener, ActionListener{
	ChromatogramViewer	myView;
	String			currentDir;
	MenuItem		quitMenuItem;

	public TraceView() {
		super("Trace Viewer");
		
		MenuBar		mainMenuBar;
		Menu		fileMenu;

		// Create a quit button on the main menu bar
		quitMenuItem = new MenuItem("Quit");
		quitMenuItem.addActionListener(this);
		fileMenu = new Menu("File");
		fileMenu.add(quitMenuItem);
		mainMenuBar = new MenuBar();
		mainMenuBar.add(fileMenu);
		setMenuBar(mainMenuBar);

		// Add another way to quit
		WindowListener winListener = new WindowAdapter(){
			public void windowClosing(WindowEvent e) {System.exit(0);}
			};
		this.addWindowListener(winListener);
		this.currentDir = System.getProperty("user.dir");
		myView = new ChromatogramViewer();
		this.setLayout(new BorderLayout());
		this.add("Center", myView);
		this.pack();
		this.setVisible(true);
		}

	public static void main(String[] args) {

		if (args.length < 1){
			UserComms.warn("Too few arguments - Usage: TraceView gzip'ped_trace_filename");
			System.exit(-1);
			}
		TraceView traceView = new TraceView();
		String storeName = "File";
		String traceName = args[0];
		if ((storeName != null) && (traceName != null)){
			TraceRequestEvent firstTraceCall = new TraceRequestEvent(traceView, storeName, traceName);
			traceView.traceRequested(firstTraceCall);
			}
		}
	
	public void actionPerformed(ActionEvent event){
		if (event.getSource() == quitMenuItem){
			// Apoptosis time
			//dispose();
			System.exit(0);
			}
		}

	public String getApplicationInfo() {
		return("DNA sequence trace viewer developed by Jeremy Parsons (jparsons@ebi.ac.uk)" +
			" and Eugen Buehler (buehler@agave.humgen.upenn.edu)"
			);
		}
		
        public void traceRequested(TraceRequestEvent reqE){
                // Child control panel has asked for a new sequence
                reloadTrace(reqE.getStore(), reqE.getAccession());
                }

	void reloadTrace(String database, String filename) {
		// Working with local files, database should always be "File"

		String		traceName = filename;
		byte[] 		unCompByteArr;
		Chromatogram	chromData = null;

		UserComms.inform("Requested " + database + ":" + traceName);
		try	{
			// File traceFile = new File(currentDir, filename);
			File traceFile = new File(filename);
			unCompByteArr = TraceUtils.gzipStream2bytes(new FileInputStream(traceFile));
			ByteArrayInputStream bufferIn = new ByteArrayInputStream(unCompByteArr);
			chromData = Chromatogram.createChromatogramSubType(bufferIn);
			bufferIn.close();
	
			// Get the trace display refreshed
			chromData.setDatabaseName(database);
			chromData.setAccession(traceName);
			myView.loadTrace(chromData);	
			}
			
		catch (IOException ex) {
			String exMessage = ex.getMessage();
			String exName = ex.getClass().getName();
			System.err.println("IO ERROR: " + exName + " : " + exMessage);
			}
		}
}	
