package embl.ebi.trace;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;

/**
A class defining static variables and methods to use when
giving feedback to a user. These methods can all be upgraded
centrally when new interface components are defined, or at
runtime to allow simple switching from applet to application
feedback. If used with JFC, it would make sense to use OptionPane
for the warn() method. There are many possible extensions to
this class to handle multi-level debugging, feedback etc.
*/

public class UserComms {
	public static Applet	applet = null;
	
	public UserComms(){
		// Implicit call to super
		}

	// Print message and carry on
	public static void inform (String message) {
		System.out.println(message);
		if (applet != null) {
			applet.showStatus(message);
			}
		}

	// create a warning window which should distract the user until clicked away
	public static void warn (String message) {
		System.err.println(message);
		if (applet != null) {
			applet.showStatus(message);
			}
		Frame warnFrame = new Frame("Warning");
		warnFrame.add("Center", new Label(message, Label.CENTER));
		Button	okButton = new Button("OK");
		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent action){
				((Frame)(((Component)(action.getSource())).getParent())).dispose();
				return;
				}
			});
		warnFrame.add("South", okButton);
		warnFrame.pack();
		warnFrame.show();
		}
}
	
