package embl.ebi.trace;
import org.omg.CosNaming.NameComponent;
import java.util.Vector;
import java.util.StringTokenizer;;

/**
TraceServerNaming.java is the location where I am putting
naming information to allow both server and client to
locate the names of DNA sequence chromatogram servers.
*/
public abstract class TraceServerNaming {
	public static NameComponent[]	NAME_PATH;
	public final static String	CONTENT_TYPE = "EST_Traces";
	public final static String	TRACE_SERVER_NAME_PATH = embl.ebi.trace.TraceStore.TOP_TRACE_NAME_CONTEXT;
		
	static	{
		// Do a contrived initialization but be careful that nulls or
		// array bounds exceptions do not creep in
		NameComponent component;
		Vector partsVec = new Vector();
		StringTokenizer nameTokens = new StringTokenizer(TRACE_SERVER_NAME_PATH, "/\\");
		while (nameTokens.hasMoreTokens()){
			component = new NameComponent(nameTokens.nextToken(), "");
			partsVec.addElement(component);
			}
		NAME_PATH = new NameComponent[partsVec.size()];
		partsVec.copyInto(NAME_PATH);
		}
}

