#! /bin/csh
#
#	 Dump zoom frame and convert to PS file
#        Reads zoom.corners data file, uses sed.com script.
#
#
#
echo " "
@ click = 200
while ( $click > 0 )
@ click = $click - 1
end
if (-e dump.ras) then
     rm dump.ras
endif
if (-e dump.ppm) then 
     rm dump.ppm
endif
if (-e dump.ps) then 
     rm dump.ps
endif
if (-e $1) then  
     rm $1
endif
set number = (`cat zoom.corners`)
echo $number[1]
echo $number[2]
echo $number[3]
echo $number[4]
set w = $number[4]
if(($w % 2) != 0) then
   @ w = $w + 1
endif
set h = $number[3] 
if(($h % 2) != 0) then
    @ h = $h + 1
endif
echo $number[1]
echo $number[2]
echo $w
echo $h
echo "dump started"
screendump -x$number[1] -y$number[2] -X$w -Y$h dump.ras
echo "dump to raster finished"
rasttoppm dump.ras > dump.ppm
echo converted to portable pix map 
ppmtops -scale .6 dump.ppm > dump.ps
echo converted to PostScript file 
sed -f sed.com dump.ps > $1
echo edited by SED to $1
#rm dump.tmp
#
echo " "
echo Done.
echo " "
