/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.data.seqdoc;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Stack;
import org.biolegato.core.data.seqdoc.SeqDocListener;
import org.biolegato.core.data.seqdoc.SeqWrap;
import org.biolegato.core.data.seqdoc.undo.UndoDelete;
import org.biolegato.core.data.seqdoc.undo.UndoInsert;
import org.biolegato.core.data.seqdoc.undo.Undoable;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.data.sequence.SequenceListener;
import org.biolegato.core.main.BLMain;

public class SeqDoc
implements SequenceListener {
    protected Stack<Undoable> undoStack = new Stack();
    protected Stack<Undoable> redoStack = new Stack();
    private final LinkedList<SeqWrap> lines = new LinkedList();
    private final LinkedList<SeqDocListener> listeners = new LinkedList();

    public boolean insert(int lineNumber, int offset, String string) {
        boolean result = false;
        if (!this.lines.isEmpty() && lineNumber >= 0 && lineNumber < this.getLineCount()) {
            String current = this.lines.get(lineNumber).getField("sequence").toString();
            if (offset > 0 && offset < current.length()) {
                this.lines.get(lineNumber).setField("sequence", current.substring(0, offset) + string + current.substring(offset));
            } else if (offset >= current.length()) {
                this.lines.get(lineNumber).setField("sequence", current + string);
            } else {
                this.lines.get(lineNumber).setField("sequence", string + current);
            }
            while (lineNumber > 0 && lineNumber < this.lines.size()) {
                this.lines.get(lineNumber).setStart(this.getLineEndOffset(lineNumber - 1) + 1);
                ++lineNumber;
            }
            this.undoStack.push(new UndoInsert(this, offset, string.length()));
            result = true;
        } else {
            BLMain.error("Bad offset: " + offset + " (line: " + lineNumber + ")", "SeqDoc.insert(int, String)");
        }
        return result;
    }

    public boolean insert(int offset, Sequence[] sequences) {
        int lineNumber = this.getLineNumber(offset);
        int cutpos = offset - this.getLineStartOffset(lineNumber);
        boolean result = false;
        Sequence split = null;
        String splitStr = "";
        if (sequences != null && sequences.length > 0 && lineNumber >= 0 && lineNumber <= this.getLineCount()) {
            split = (Sequence)this.lines.get(lineNumber).getSequence().clone();
            splitStr = split.getField("sequence").toString();
            if (!this.lines.isEmpty() && cutpos > 0 && cutpos < splitStr.length()) {
                if (sequences.length - 1 > 0) {
                    this.lines.get(lineNumber).setField("sequence", splitStr.substring(0, cutpos) + sequences[0].getField("sequence"));
                    split.setField("sequence", sequences[sequences.length - 1].getField("sequence").toString() + splitStr.substring(cutpos));
                    this.addSequence(lineNumber + 1, split);
                } else {
                    this.insert(lineNumber, cutpos, sequences[0].getField("sequence").toString());
                }
            } else {
                if (cutpos >= splitStr.length()) {
                    ++lineNumber;
                }
                this.addSequence(lineNumber, sequences[0]);
                if (sequences.length - 1 > 0) {
                    this.addSequence(lineNumber + 1, sequences[sequences.length - 1]);
                }
            }
            ++lineNumber;
            for (int count = 1; count < sequences.length - 1; ++count) {
                this.addSequence(lineNumber, sequences[count]);
                ++lineNumber;
            }
            result = true;
        } else if (sequences == null || sequences.length <= 0) {
            BLMain.error("Invalid sequence parameter", "SeqDoc.insert(int, Sequence[])");
        } else if (this.getLineCount() <= 0) {
            this.addSequences(sequences);
        } else if (lineNumber < 0 && lineNumber > this.getLineCount()) {
            BLMain.error("Invalid offset", "SeqDoc.insert(int, Sequence[])");
        }
        return result;
    }

    public boolean delete(int offset, int length) {
        int lineNumber = Math.max(0, this.getLineNumber(offset));
        int cutpos = 0;
        String data = "";
        if (!this.lines.isEmpty() && this.lines.size() > 0 && offset >= 0 && offset < this.getLineEndOffset(this.getLineCount() - 1)) {
            length = Math.max(0, Math.min(offset + length, this.getLength()) - offset);
            String deleted = this.getText(offset, length);
            while (this.getLineEndOffset(lineNumber) < offset + length && lineNumber + 1 < this.lines.size()) {
                this.lines.get(lineNumber).setField("sequence", this.lines.get(lineNumber).getField("sequence").toString() + "\n" + this.lines.get(lineNumber + 1).getField("sequence").toString());
                this.lines.remove(lineNumber + 1);
            }
            data = this.lines.get(lineNumber).getField("sequence").toString();
            cutpos = Math.max(0, offset - this.getLineStartOffset(lineNumber));
            this.lines.get(lineNumber).setField("sequence", data.substring(0, cutpos) + data.substring(Math.min(data.length(), cutpos + length)));
            while (lineNumber > 0 && lineNumber < this.lines.size()) {
                this.lines.get(lineNumber).setStart(this.getLineEndOffset(lineNumber - 1) + 1);
                ++lineNumber;
            }
        }
        return true;
    }

    public boolean delete(int lineNumber, int offset, int length) {
        boolean cutpos = false;
        String data = "";
        if (!this.lines.isEmpty() && this.lines.size() > 0 && offset >= 0 && length >= 0 && offset < this.getLineLength(lineNumber)) {
            String deleted = this.getSequence(lineNumber).getField("sequence").toString().substring(offset, length);
            this.lines.get(lineNumber).setField("sequence", data.substring(0, offset) + data.substring(offset + length));
            while (lineNumber > 0 && lineNumber < this.lines.size()) {
                this.lines.get(lineNumber).setStart(this.getLineEndOffset(lineNumber - 1) + 1);
                ++lineNumber;
            }
            this.undoStack.push(new UndoDelete(this, lineNumber, offset, deleted));
        }
        return true;
    }

    public void addSequences(int lineNumber, Sequence[] sequenceList) {
        lineNumber = Math.max(0, Math.min(this.getLineCount(), lineNumber));
        int offset = lineNumber > 0 ? this.getLineEndOffset(lineNumber - 1) + 1 : 0;
        int length = 0;
        if (sequenceList != null) {
            for (Sequence seq : sequenceList) {
                if (seq != null) {
                    SeqWrap addLine = new SeqWrap(offset, seq);
                    addLine.addListener(this);
                    this.lines.add(lineNumber, addLine);
                    length += seq.getField("sequence").toString().length();
                    ++lineNumber;
                }
                for (SeqDocListener listener : this.listeners) {
                    listener.sequenceAdded(this, lineNumber, seq);
                }
            }
            while (lineNumber > 0 && lineNumber < this.lines.size()) {
                this.lines.get(lineNumber).setStart(this.getLineEndOffset(lineNumber - 1) + 1);
                ++lineNumber;
            }
            this.undoStack.push(new UndoInsert(this, offset, length));
        }
    }

    public void removeSequences(int[] lineNumbers) {
        Arrays.sort(lineNumbers);
        if (!this.lines.isEmpty()) {
            for (int count = lineNumbers.length - 1; count >= 0; --count) {
                int lineNumber = lineNumbers[count];
                if (this.lines.size() > lineNumber && lineNumber >= 0) {
                    SeqWrap removed = this.lines.remove(lineNumber);
                    String text = removed.getField("sequence").toString();
                    int offset = removed.getStart();
                    int length = text.length();
                    for (SeqDocListener listener : this.listeners) {
                        listener.sequenceRemoved(this, lineNumber, removed.getSequence());
                    }
                }
                while (lineNumber > 0 && lineNumber < this.lines.size()) {
                    this.lines.get(lineNumber).setStart(this.getLineEndOffset(lineNumber - 1) + 1);
                    ++lineNumber;
                }
            }
        }
    }

    public void addSequence(Sequence seq) {
        this.addSequence(this.getLineCount(), seq);
    }

    public void addSequence(int lineNumber, Sequence seq) {
        this.addSequences(lineNumber, new Sequence[]{seq});
    }

    public void addSequences(Sequence[] sequenceList) {
        this.addSequences(this.getLineCount(), sequenceList);
    }

    public void removeSequence(int lineNumber) {
        this.removeSequences(new int[]{lineNumber});
    }

    public boolean undo() {
        boolean result = !this.undoStack.empty();
        Undoable undone = null;
        if (result && (undone = this.undoStack.pop().undo()) != null) {
            this.redoStack.push(undone);
        }
        return result;
    }

    public boolean redo() {
        boolean result = !this.redoStack.empty();
        Undoable redone = null;
        if (result && (redone = this.redoStack.pop().undo()) != null) {
            this.undoStack.push(redone);
        }
        return result;
    }

    public int getLength() {
        return this.lines.size() > 0 ? this.lines.getLast().getStart() + this.lines.getLast().getField("sequence").toString().length() - this.lines.getFirst().getStart() : 0;
    }

    public int getLineNumber(int offset) {
        int high = this.lines.size() - 1;
        int low = 0;
        int index = -1;
        SeqWrap current = null;
        if (this.lines.size() > 0 && offset >= 0 && offset <= this.getLength()) {
            do {
                index = index == (low + high) / 2 && index != high ? ++index : (index == (low + high) / 2 ? --index : (low + high) / 2);
                current = this.lines.get(index);
                if (current == null) continue;
                if (current.getStart() + current.getField("sequence").toString().length() < offset) {
                    low = index;
                    continue;
                }
                if (current.getStart() <= offset) continue;
                high = index;
            } while (current != null && low != high && (current.getStart() + current.getField("sequence").toString().length() < offset || current.getStart() > offset));
        }
        return index;
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public String getLine(int lineNumber) {
        return lineNumber >= 0 && lineNumber < this.lines.size() ? this.lines.get(lineNumber).getField("sequence").toString() : "";
    }

    public int getLineStartOffset(int lineNumber) {
        return lineNumber >= 0 && lineNumber < this.lines.size() ? this.lines.get(lineNumber).getStart() : 0;
    }

    public int getLineEndOffset(int lineNumber) {
        return lineNumber >= 0 && lineNumber < this.lines.size() ? this.getLineStartOffset(lineNumber) + this.lines.get(lineNumber).getField("sequence").toString().length() : 0;
    }

    public int getLineLength(int lineNumber) {
        return lineNumber >= 0 && lineNumber < this.lines.size() ? this.getLineEndOffset(lineNumber) - this.getLineStartOffset(lineNumber) : 0;
    }

    public String getText(int offset, int length) {
        int minOffset = Math.max(0, Math.min(offset, offset + length));
        int maxOffset = Math.min(this.getLength() - 1, Math.max(offset, offset + length));
        int minLine = this.getLineNumber(minOffset);
        int maxLine = this.getLineNumber(maxOffset);
        int cutpos = Math.max(0, offset - this.getLineStartOffset(minLine));
        String result = this.getLine(minLine);
        StringBuffer lineBuffer = new StringBuffer();
        if (this.lines.size() > 0) {
            lineBuffer.append(result);
            for (int count = minLine + 1; count <= maxLine; ++count) {
                lineBuffer.append(this.getLine(count));
            }
            result = lineBuffer.toString();
            if (cutpos >= result.length() || length <= 0) {
                result = "";
            } else {
                if (cutpos > 0) {
                    result = result.substring(cutpos);
                }
                if (length < result.length()) {
                    result = result.substring(0, length);
                }
            }
        }
        return result;
    }

    public Sequence getSequence(int lineNumber) {
        return lineNumber >= 0 && lineNumber < this.lines.size() ? this.lines.get(lineNumber).getSequence() : null;
    }

    public Sequence[] getSequences(int[] lineNumbers) {
        Sequence seqAdd = null;
        LinkedList<Sequence> seqList = new LinkedList<Sequence>();
        for (int line : lineNumbers) {
            seqAdd = this.getSequence(line);
            if (seqAdd == null) continue;
            seqList.add(seqAdd);
        }
        return seqList.toArray(new Sequence[0]);
    }

    public void addListener(SeqDocListener listener) {
        this.listeners.add(listener);
    }

    public int getLongestLineLength() {
        int lineLength = 0;
        for (int count = 0; count < this.getLineCount(); ++count) {
            lineLength = Math.max(lineLength, this.getLineLength(count));
        }
        return lineLength;
    }

    public void sequenceChanged(Sequence sequence, String key) {
        for (SeqDocListener listener : this.listeners) {
            listener.sequenceChanged(this, this.lines.indexOf(sequence), sequence, key);
        }
    }
}

