/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.data.sequence;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.biolegato.core.data.sequence.SequenceListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sequence
extends Hashtable<String, Object>
implements Cloneable {
    private final LinkedList<SequenceListener> listeners = new LinkedList();
    private static final Hashtable<String, Object> defaults = new Hashtable<String, Object>(){
        private static final long serialVersionUID = 7526472295622777006L;
        {
            this.put("modified", Boolean.FALSE);
            this.put("name", "New Sequence");
            this.put("direction", Direction.FROM5TO3);
            this.put("strandedness", Strandedness.SINGLE);
            this.put("topology", Topology.LINEAR);
            this.put("type", Type.DNA);
            this.put("protect_align", Boolean.FALSE);
            this.put("protect_ambig", Boolean.TRUE);
            this.put("protect_unambig", Boolean.TRUE);
        }
    };
    private static final long serialVersionUID = 7526472295622777024L;

    public Sequence() {
        this("");
    }

    public Sequence(String string) {
        this((Map<String, Object>)defaults);
        this.put("sequence", string);
        this.detectType();
    }

    public Sequence(Map<String, Object> data) {
        super(data);
        if (!data.containsKey("type") || data.get("type") == null || !(data.get("type") instanceof Type)) {
            this.detectType();
        }
    }

    public void addListener(SequenceListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SequenceListener listener) {
        this.listeners.remove(listener);
    }

    public Object getField(String key) {
        return this.containsKey(key) ? this.get(key) : Sequence.getDefault(key);
    }

    public void setField(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Cannot call Sequence.setField(" + key + "," + value + ")");
        }
        if (value == null) {
            value = Sequence.getDefault(key);
        }
        this.put("modified", Boolean.TRUE);
        this.put(key, value);
        for (SequenceListener listener : this.listeners) {
            listener.sequenceChanged(this, key);
        }
    }

    public static Object getDefault(String key) {
        return defaults.containsKey(key) ? defaults.get(key) : "";
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("--- SEQUENCE DATA ---");
        for (String key : this.keySet()) {
            result.append("\t" + key + "=" + this.getField(key) + "\n");
        }
        return result.toString();
    }

    public Sequence subseq(int start) {
        Sequence split = (Sequence)this.clone();
        if (start <= split.getField("sequence").toString().length()) {
            split.setField("sequence", split.getField("sequence").toString().substring(start));
        } else {
            split.setField("sequence", "");
        }
        return split;
    }

    public Sequence subseq(int start, int end) {
        int length = end - start;
        Sequence split = this.subseq(start);
        if (end >= 0 && end <= split.getField("sequence").toString().length()) {
            split.setField("sequence", split.getField("sequence").toString().substring(0, end));
        }
        return split;
    }

    @Override
    public Object clone() {
        return new Sequence(this);
    }

    private void detectType() {
        Type result = Type.DNA;
        if (this.containsKey("sequence")) {
            String data = this.getField("sequence").toString().toUpperCase().trim();
            if (data.indexOf(85) >= 0) {
                result = Type.RNA;
            } else if (data.indexOf(70) >= 0 || data.indexOf(69) >= 0 || data.indexOf(74) >= 0 || data.indexOf(76) >= 0 || data.indexOf(79) >= 0 || data.indexOf(81) >= 0 || data.indexOf(88) >= 0 || data.indexOf(90) >= 0) {
                result = Type.PROTEIN;
            }
            this.setField("type", (Object)result);
        }
    }

    public CharacterClass charType(char test) {
        CharacterClass type = CharacterClass.ALIGNMENT;
        if (Type.DNA.equals(this.getField("type")) || Type.RNA.equals(this.getField("type"))) {
            switch (test) {
                case 'B': 
                case 'D': 
                case 'H': 
                case 'I': 
                case 'K': 
                case 'M': 
                case 'N': 
                case 'R': 
                case 'S': 
                case 'V': 
                case 'W': 
                case 'Y': 
                case 'b': 
                case 'd': 
                case 'h': 
                case 'i': 
                case 'k': 
                case 'm': 
                case 'n': 
                case 'r': 
                case 's': 
                case 'v': 
                case 'w': 
                case 'y': {
                    type = CharacterClass.AMBIGUOUS;
                    break;
                }
                case 'A': 
                case 'C': 
                case 'G': 
                case 'T': 
                case 'U': 
                case 'a': 
                case 'c': 
                case 'g': 
                case 't': 
                case 'u': {
                    type = CharacterClass.UNAMBIGUOUS;
                    break;
                }
                default: {
                    type = CharacterClass.ALIGNMENT;
                    break;
                }
            }
        } else if (Type.PROTEIN.equals(this.getField("type"))) {
            switch (test) {
                case '*': 
                case 'B': 
                case 'X': 
                case 'Z': 
                case 'b': 
                case 'x': 
                case 'z': {
                    type = CharacterClass.AMBIGUOUS;
                    break;
                }
                case 'A': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'V': 
                case 'W': 
                case 'Y': 
                case 'a': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'v': 
                case 'w': 
                case 'y': {
                    type = CharacterClass.UNAMBIGUOUS;
                    break;
                }
                default: {
                    type = CharacterClass.ALIGNMENT;
                }
            }
        }
        return type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharacterClass {
        ALIGNMENT,
        AMBIGUOUS,
        UNAMBIGUOUS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strandedness {
        SINGLE{

            public String toString() {
                return "Single stranded";
            }
        }
        ,
        DOUBLE{

            public String toString() {
                return "Double stranded";
            }
        }
        ,
        MIXED{

            public String toString() {
                return "Mixed strandedness";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Topology {
        LINEAR{

            public String toString() {
                return "Linear";
            }
        }
        ,
        CIRCULAR{

            public String toString() {
                return "Circular";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        FROM3TO5{

            public String toString() {
                return "From 3' to 5'";
            }
        }
        ,
        FROM5TO3{

            public String toString() {
                return "From 5' to 3'";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DNA{

            public String toString() {
                return "DNA";
            }
        }
        ,
        RNA{

            public String toString() {
                return "RNA";
            }
        }
        ,
        PROTEIN{

            public String toString() {
                return "Protein";
            }
        }
        ,
        MASK{

            public String toString() {
                return "Colour mask";
            }
        }
        ,
        TEXT{

            public String toString() {
                return "Text";
            }
        };

    }
}

