/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.main;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.text.BadLocationException;
import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.plugins.PluginLoader;
import org.biolegato.core.plugins.PluginWrapper;
import org.biolegato.core.plugintypes.DataCanvas;
import org.biolegato.core.plugintypes.DataFormat;
import org.biolegato.core.plugintypes.MenuType;
import org.biolegato.core.plugintypes.PropertiesExtension;
import org.biolegato.core.properties.BLProperties;
import org.biolegato.core.properties.PropertiesListener;

public final class BLMain
extends JFrame {
    protected BLProperties properties = new BLProperties();
    protected SeqDoc mainSeqDoc = new SeqDoc();
    protected Sequence[] clipboard = null;
    private JTabbedPane canvasPane = (JTabbedPane)this.add(new JTabbedPane());
    private Hashtable<String, JMenu> menuHeadings = new Hashtable();
    public static final String NAME = "BioLegato";
    public static final String PROGRAM_DIR = new File(BLMain.class.getProtectionDomain().getCodeSource().getLocation().getPath()).isDirectory() ? BLMain.class.getProtectionDomain().getCodeSource().getLocation().getPath() : new File(new File(BLMain.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent()).getPath();
    public static final String CURRENT_DIR = System.getProperty("user.dir");
    public static final String VERSION = "0.5.8";
    public static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    public static final int DOUBLE_CLICK_TIME = 300;
    public static final long serialVersionUID = 7526472295622776147L;

    public BLMain(String[] args) {
        super(NAME);
        DataCanvas currentCanvas = null;
        final BLMain window = this;
        Object currentMenuLoader = null;
        PluginLoader.loadPlugins(this.getProperty("plugins"));
        this.processArgs(args);
        for (PluginWrapper plugin : PluginLoader.getPlugins(PropertiesExtension.class)) {
            this.properties.addExtension((PropertiesExtension)plugin.create(new Class[]{BLProperties.class}, new Object[]{this.properties}));
        }
        this.setJMenuBar(new JMenuBar());
        this.addMenuItem("File", new JMenuItem(new AbstractAction("Open..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                super(x0);
                this.putValue("MnemonicKey", new Integer(79));
            }

            public void actionPerformed(ActionEvent evt) {
                JFileChooser openDialog = new JFileChooser();
                openDialog.setCurrentDirectory(new File(System.getProperty("user.dir")));
                openDialog.setAcceptAllFileFilterUsed(true);
                DataFormat.addFormats(openDialog, BLMain.this.getProperty("default.fileformat").toString());
                if (openDialog.showOpenDialog(window) == 0 && openDialog.getSelectedFile() != null && openDialog.getSelectedFile().exists() && openDialog.getSelectedFile().isFile()) {
                    try {
                        if (openDialog.getFileFilter() != null && !openDialog.getFileFilter().equals(openDialog.getAcceptAllFileFilter())) {
                            window.addData(((DataFormat)openDialog.getFileFilter()).readFile(openDialog.getSelectedFile()));
                        } else {
                            window.addData(DataFormat.auto(openDialog.getSelectedFile()));
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        }));
        this.addMenuItem("File", new JMenuItem(new AbstractAction("Save As..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                super(x0);
                this.putValue("MnemonicKey", new Integer(83));
            }

            public void actionPerformed(ActionEvent evt) {
                JFileChooser saveDialog = new JFileChooser();
                saveDialog.setCurrentDirectory(new File(System.getProperty("user.dir")));
                saveDialog.setAcceptAllFileFilterUsed(false);
                DataFormat.addFormats(saveDialog, BLMain.this.getProperty("default.fileformat").toString());
                if (!(saveDialog.showSaveDialog(window) != 0 || saveDialog.getSelectedFile() == null || saveDialog.getSelectedFile().exists() && JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Overwritehttp://www.harmonyhomestead.com/index_files/tip1.htm", 2, 3) == 2)) {
                    try {
                        ((DataFormat)saveDialog.getFileFilter()).writeFile(saveDialog.getSelectedFile(), window.getAllData());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        }));
        for (PluginWrapper plugin : PluginLoader.getPlugins(MenuType.class)) {
            plugin.smethod("loadMenu", new Class[]{BLMain.class}, new Object[]{this});
        }
        this.addMenuItem("Help", new JMenuItem(new AbstractAction("About..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                super(x0);
                this.putValue("MnemonicKey", new Integer(65));
            }

            public void actionPerformed(ActionEvent evt) {
                window.aboutPopup();
            }
        }));
        this.addMenuItem("File", new JMenuItem(new AbstractAction("Properties..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                super(x0);
                this.putValue("MnemonicKey", new Integer(80));
            }

            public void actionPerformed(ActionEvent evt) {
                BLMain.this.properties.showPropertiesWindow(window);
            }
        }));
        this.addMenuItem("File", new JMenuItem(new AbstractAction("Exit"){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                super(x0);
                this.putValue("MnemonicKey", new Integer(88));
            }

            public void actionPerformed(ActionEvent evt) {
                window.dispose();
            }
        }));
        for (PluginWrapper plugin : PluginLoader.getPlugins(DataCanvas.class)) {
            currentCanvas = (DataCanvas)plugin.create(new Class[]{BLMain.class}, new Object[]{this});
            if (currentCanvas == null) continue;
            this.canvasPane.addChangeListener(currentCanvas);
            this.canvasPane.add(currentCanvas.getTabName(), currentCanvas);
            if (currentCanvas.getTabName() == null || !currentCanvas.getTabName().equalsIgnoreCase(this.getProperty("default.canvas"))) continue;
            this.canvasPane.setSelectedComponent(currentCanvas);
        }
        this.pack();
        this.setVisible(true);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    private void processArgs(String[] args) {
        String value = "";
        File fileIn = null;
        Object dataIn = null;
        if (args != null) {
            for (String argument : args) {
                if (argument == null) continue;
                fileIn = new File(argument);
                if (fileIn != null && fileIn.exists() && fileIn.isFile() && fileIn.canRead()) {
                    this.mainSeqDoc.addSequences(DataFormat.auto(fileIn));
                    continue;
                }
                if (!argument.startsWith("/") && !argument.startsWith("-")) continue;
                if (argument.startsWith("--") && argument.length() > 2) {
                    argument = argument.substring(2);
                } else if ((argument.startsWith("/") || argument.startsWith("-")) && argument.length() > 1) {
                    argument = argument.substring(1);
                }
                if (argument.indexOf(61) > 0) {
                    value = argument.substring(argument.indexOf(61) + 1);
                    argument = argument.substring(0, argument.indexOf(61));
                }
                if ("help".equals(argument = argument.toLowerCase().trim()) || "h".equals(argument) || "?".equals(argument)) {
                    System.out.println("Usage: biolegato [options] [files]\nUse --optionlist  to see a detailed list of options\nUse --manpage     to see BioLegato's manpage");
                    System.exit(0);
                    continue;
                }
                if ("optionlist".equals(argument)) {
                    System.out.println("+-------------+------------------------------------------------------+\n| Option      | Description                                          |\n+-------------+------------------------------------------------------+\n| help,?      | Displays usage information for BioLegato             |\n| manpage,man | Displays the manpage entry for BioLegato             |\n| optionlist  | Displays the list of options for using BioLegato     |\n| version,v   | Displays the version information for BioLegato       |\n| pipe,p,in   | Inserts input from standard input into the canvas    |\n| debug       | Enables BioLegato's debug mode                       |\n| plugins     | Displays a list of loaded plugins                    |\n| properties  | Displays a list of BioLegato's properties            |\n+-------------+------------------------------------------------------+\n");
                    System.exit(0);
                    continue;
                }
                if ("manpage".equals(argument) || "man".equals(argument)) {
                    System.out.println("NAME\n    Bio Legato - A customizable GUI for running programs\n\nSYNOPSIS\n    biolegato [options] [files]\n\nDESCRIPTION\n    BioLegato is a customizable GUI for running programs.\n    Its initial intent is to be a replacement for GDE; however\n    with its large plugin API, it may be customized to run more\n    than just CLI programs.\n\n    With the versitility of BioLegato's plugin interface, it\n    supports a wide range of file formats which may be added to\n    at any time through addition of plugins.\n\nOPTIONS\n  NOTE: All command line parameters are case insensitive\n        and may optionally begin with -, --, or / to prevent\n        confusion with filenames\n\n    help,h,?\n        Displays usage information for BioLegato\n    manpage,man\n        Displays the manpage entry for BioLegato (this screen)\n    optionlist\n        Displays the list of options for using BioLegato\n    version,v\n        Displays the version information for BioLegato\n    pipe,p,in\n        Inserts input from standard input into the canvas\n    debug\n        Enables BioLegato's debug mode\n    plugins\n        Displays a list of loaded plugins\n    properties\n        Displays a list of BioLegato's properties\n\nEXAMPLES\n    biolegato\n\n    biolegato insequence.gb\n\n    biolegato --debug\n    biolegato /debug\n    biolegato -debug\n\n    biolegato --plugins --properties --debug\n\n    biolegato --plugins --properties --debug insequence.gb\n\nSUPPORTED PLUGINS\n    Currently BioLegato supports the following main types of Plugins:\n\n        Canvases\n           extends the class: Plugins.DataCanvases\n        File formats           extends the class: Plugins.DataFormat\n        Menu types\n           extends the class: Plugins.MenuType\n\n    For more information about plugins, please consult the BioLegato API\n\nFILES\n    biolegato\n        Script to run BioLegato\n    BioLegato.jar\n        BioLegato's core java code\n    Plugins/GDE.jar        Provides backward compatibility with GDE\n    Plugins/GenBankFile2008.class        Provides internal file support for GenBank files (2008 standard copliant)\n    Plugins/FastA.class        Provides internal file support for FastA files\n\nFILE FORMATS\n    All file formats in BioLegato are supported through plugins.\n    Below is a list of file formats supported by a default\n    installation of BioLegato (with all standard plugins):\n\n        BioLegato flatfiles\n        FastA files\n        GDE flatfiles\n        GDE format files\n        GenBank files (2008 standard compliant)\n\nBUGS\n    There are currently no known bugs in this version of BioLegato\n\n    Please report all bugs to: Graham Alvare <alvare@cc.umanitoba.ca>\nAUTHORS\n    Dr. Brian Fristensky\n    Department of Plant Science\n    University of Manitoba\n    Winnipeg, MB  Canada R3T 2N2\n\n    Email: frist@cc.umanitoba.ca\n    Web: http://home.cc.umanitoba.ca/~frist\n\n    Graham Alvare\n    Department of Plant Science\n    University of Manitoba\n    Winnipeg, MB  Canada R3T 2N2\n\n    Email: alvare@cc.umanitoba.ca\n    Web: http://home.cc.umanitoba.ca/~alvare\n");
                    System.exit(0);
                    continue;
                }
                if ("version".equals(argument) || "v".equals(argument)) {
                    System.out.println("BioLegato v0.5.8");
                    System.exit(0);
                    continue;
                }
                if ("pipe".equals(argument) || "p".equals(argument) || "in".equals(argument)) {
                    try {
                        this.mainSeqDoc.addSequences(DataFormat.auto(System.in));
                    }
                    catch (Throwable ex) {
                        BLMain.error("An error occurred reading canvas data from System.in", "processArgs");
                    }
                    continue;
                }
                if ("debug".equals(argument)) {
                    this.properties.setProperty("debug", "true");
                    continue;
                }
                if ("plugins".equals(argument)) {
                    String[] pluginList;
                    System.out.println("(Current plugins path: " + this.getProperty("plugins") + ")");
                    System.out.println("-- listing plugins loaded --");
                    for (String pluginName : pluginList = PluginLoader.getPluginHash().keySet().toArray(new String[0])) {
                        System.out.println("Plugin: " + pluginName);
                    }
                    System.out.println("-- end of plugin list --");
                    continue;
                }
                if ("properties".equals(argument)) {
                    System.out.println("**********");
                    System.out.println("PROPERTIES");
                    System.out.println("**********");
                    this.properties.list(System.out);
                    continue;
                }
                BLMain.error("Unknown argument: " + argument, "processArgs");
            }
        }
        if ("true".equalsIgnoreCase(this.getProperty("debug"))) {
            BLMain.message("Command line arguments read successfully", "processArgs");
        }
    }

    public Process safeExecute(String cmd) {
        Process result = null;
        StringBuffer message = new StringBuffer();
        String[] execute = new String[]{cmd};
        if (this.properties.getProperty("shell.name") != null) {
            execute = this.properties.getProperty("shell.parameter") != null ? new String[]{this.properties.getProperty("shell.name"), this.properties.getProperty("shell.parameter"), cmd} : new String[]{this.properties.getProperty("shell.name"), cmd};
        }
        if ("true".equalsIgnoreCase(this.getProperty("debug"))) {
            for (String parameter : execute) {
                message.append(parameter + " ");
            }
            BLMain.message(message.toString(), "safeExecute");
        }
        try {
            result = Runtime.getRuntime().exec(execute);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    public void shellCommand(String cmd, String data) {
        int result = -65535;
        final Process process = this.safeExecute(cmd);
        if (process != null) {
            try {
                if (data != null) {
                    new OutputStreamWriter(process.getOutputStream()).write(data);
                }
                new Thread(){

                    public void run() {
                        String line = "";
                        BufferedReader reader = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                            while ((line = reader.readLine()) != null) {
                                System.out.println(line);
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }.start();
                new Thread(){

                    public void run() {
                        String line = "";
                        BufferedReader reader = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                            while ((line = reader.readLine()) != null) {
                                System.err.println(line);
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }.start();
                if ("true".equalsIgnoreCase(this.getProperty("debug"))) {
                    BLMain.message("BioLegato: Command executed successfully, returned: " + process.waitFor(), "shellCommand");
                } else {
                    process.waitFor();
                }
            }
            catch (Throwable e) {
                BLMain.error("BioLegato: error executing command: " + cmd, "shellCommand");
                e.printStackTrace();
            }
        }
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    public void setClipboard(Sequence[] copy) {
        this.clipboard = copy;
    }

    public Sequence[] getClipboard() {
        return this.clipboard;
    }

    public SeqDoc getSeqDoc() {
        return this.mainSeqDoc;
    }

    public Sequence[] getData() throws BadLocationException {
        return ((DataCanvas)this.canvasPane.getSelectedComponent()).getData();
    }

    public Sequence[] getAllData() throws BadLocationException {
        return ((DataCanvas)this.canvasPane.getSelectedComponent()).getAllData();
    }

    public void addData(Sequence[] dataAdd) throws BadLocationException {
        if (dataAdd != null) {
            for (Sequence seq : dataAdd) {
                this.getSeqDoc().addSequence(seq);
            }
        }
    }

    public JMenu addMenuHeading(String name) {
        JMenu heading = this.menuHeadings.get(name);
        if (heading == null) {
            heading = new JMenu(name);
            if (name != null && name.length() >= 1 && (name.charAt(0) >= 'a' && name.charAt(0) <= 'z' || name.charAt(0) >= 'A' && name.charAt(0) <= 'Z')) {
                heading.setMnemonic(name.charAt(0));
            }
            this.menuHeadings.put(name, heading);
            this.getJMenuBar().add(heading);
        }
        return heading;
    }

    public JMenu addMenuHeading(int order, String name) {
        JMenu heading = this.addMenuHeading(name);
        if (this.getJMenuBar().getComponentIndex(heading) != order) {
            this.getJMenuBar().remove(heading);
            this.getJMenuBar().add((Component)heading, order);
        }
        return heading;
    }

    public void addMenuItem(String headingName, JMenuItem menuItem) {
        this.addMenuHeading(headingName).add(menuItem);
    }

    public void aboutPopup() {
        JOptionPane.showMessageDialog(this, "BioLegato version 0.5.8\nby Graham Alvare and Brian Fristensky\nUniveristy of Manitoba 2008-2009", "About BioLegato", 3);
    }

    public void addPropertiesListener(String key, PropertiesListener listener) {
        this.properties.addPropertiesListener(key, listener);
    }

    public static void main(String[] args) {
        for (String argument : args) {
            if (argument.startsWith("--") && argument.length() > 2) {
                argument = argument.substring(2);
            } else if ((argument.startsWith("/") || argument.startsWith("-")) && argument.length() > 1) {
                argument = argument.substring(1);
            }
            if (!argument.equalsIgnoreCase("version")) continue;
            System.out.println("BioLegato v0.5.8");
            System.exit(0);
        }
        new BLMain(args);
    }

    public static void error(String message) {
        BLMain.error(message, null);
    }

    public static void error(String message, String location) {
        System.err.println(NAME + (location != null && !"".equals(location.trim()) ? " (" + location + ")" : "") + ": ERROR --- " + message);
    }

    public static void warning(String message) {
        BLMain.warning(message, null);
    }

    public static void warning(String message, String location) {
        System.err.println(NAME + (location != null && !"".equals(location.trim()) ? " (" + location + ")" : "") + ": WARNING --- " + message);
    }

    public static void message(String message) {
        BLMain.message(message, null);
    }

    public static void message(String message, String location) {
        System.out.println(NAME + (location != null && !"".equals(location.trim()) ? " (" + location + ")" : "") + ": " + message);
    }

    public static String readStream(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        StringBuffer result = new StringBuffer();
        while (line != null) {
            result.append(line).append("\n");
            line = reader.readLine();
        }
        return result.toString();
    }
}

