/*
 * Decompiled with CFR 0.152.
 */
package forester.atv;

import forester.atv.ATVnodeFrame;
import forester.atv.DoubleDocument;
import forester.atv.IntegerDocument;
import forester.tree.Node;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

class ATVnodePanel
extends JPanel
implements ActionListener {
    private Node node;
    private ATVnodeFrame atvnodeframe;
    private boolean editable = false;
    private JLabel title;
    private JLabel seq_name_label;
    private JLabel Species_label;
    private JLabel EC_label;
    private JLabel Distance_parent_label;
    private JLabel Bootstrap_label;
    private JLabel LnL_label;
    private JLabel Sum_ext_nodes_label;
    private JLabel taxo_id_label;
    private JLabel orthologous_label;
    private JLabel super_orthologous_label;
    private JLabel message_label;
    private JTextField Seq_name_tf;
    private JTextField Species_tf;
    private JTextField EC_tf;
    private JTextField Distance_parent_tf;
    private JTextField taxo_id_tf;
    private JTextField Bootstrap_tf;
    private JTextField LnL_tf;
    private JTextField Sum_ext_nodes_tf;
    private JTextField orthologous_tf;
    private JTextField super_orthologous_tf;
    private JRadioButton Duplication_rb;
    private JRadioButton Speciation_rb;
    private JRadioButton NA_rb;
    private JSeparator sep;
    private JPanel buttonjpanel;
    private JPanel radiobuttonjpanel;
    private ButtonGroup radiobuttongroup;
    private JButton close_button;
    private JButton reset_button;
    private JButton write_button;
    private TitledBorder border;
    private static final Font label_font = new Font("Helvetica", 0, 9);
    private static final Font tf_font = new Font("Helvetica", 0, 9);
    private static final Font button_font = new Font("Helvetica", 0, 9);
    private static final Font message_font = new Font("Helvetica", 1, 10);
    private static final Color background_color = new Color(215, 215, 215);
    private static final Color label_text_color = new Color(0, 0, 0);
    private static final Color tf_text_color = new Color(0, 0, 0);
    private static final Color tf_background_color = new Color(250, 250, 250);
    private static final Color button_background_color = new Color(165, 165, 165);
    private static final Color button_text_color = new Color(0, 0, 0);
    private static final Color message_color = new Color(0, 0, 255);
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private String message = " ";

    ATVnodePanel(Node node, ATVnodeFrame aTVnodeFrame) {
        this.node = node;
        this.atvnodeframe = aTVnodeFrame;
        String string = "";
        this.editable = this.atvnodeframe.getATVgraphic().isEditable();
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.gbc.anchor = 17;
        this.setBackground(background_color);
        this.setLayout(this.gbl);
        string = this.node.isExternal() ? "External Node " + this.node.getID() : "Internal Node " + this.node.getID();
        this.border = new TitledBorder(string);
        this.border.setTitleColor(label_text_color);
        this.border.setTitleFont(label_font);
        this.border.setTitleJustification(2);
        this.setBorder(this.border);
        this.seq_name_label = new JLabel("Seq name");
        this.addJLabel(this.seq_name_label);
        this.Seq_name_tf = new JTextField(25);
        this.addJTF(this.Seq_name_tf);
        this.Species_label = new JLabel("Species");
        this.addJLabel(this.Species_label);
        this.Species_tf = new JTextField(25);
        this.addJTF(this.Species_tf);
        this.taxo_id_label = new JLabel("Taxonomy ID");
        this.addJLabel(this.taxo_id_label);
        this.taxo_id_tf = new JTextField(25);
        ((JTextComponent)this.taxo_id_tf).setDocument(new IntegerDocument());
        this.addJTF(this.taxo_id_tf);
        this.EC_label = new JLabel("EC number");
        this.addJLabel(this.EC_label);
        this.EC_tf = new JTextField(25);
        this.addJTF(this.EC_tf);
        this.Distance_parent_label = new JLabel("Distance to parent");
        this.addJLabel(this.Distance_parent_label);
        this.Distance_parent_tf = new JTextField(25);
        ((JTextComponent)this.Distance_parent_tf).setDocument(new DoubleDocument());
        this.addJTF(this.Distance_parent_tf);
        if (!this.node.isExternal()) {
            this.Bootstrap_label = new JLabel("Bootstrap value");
            this.addJLabel(this.Bootstrap_label);
            this.Bootstrap_tf = new JTextField(25);
            ((JTextComponent)this.Bootstrap_tf).setDocument(new IntegerDocument());
            this.addJTF(this.Bootstrap_tf);
        }
        if (this.node.isExternal()) {
            this.orthologous_label = new JLabel("Orthologous to X");
            this.addJLabel(this.orthologous_label);
            this.orthologous_tf = new JTextField(25);
            ((JTextComponent)this.orthologous_tf).setDocument(new IntegerDocument());
            this.addJTF(this.orthologous_tf);
            this.super_orthologous_label = new JLabel("S-Orthologous to X");
            this.addJLabel(this.super_orthologous_label);
            this.super_orthologous_tf = new JTextField(25);
            ((JTextComponent)this.super_orthologous_tf).setDocument(new IntegerDocument());
            this.addJTF(this.super_orthologous_tf);
        }
        this.LnL_label = new JLabel("log L on parent branch");
        this.addJLabel(this.LnL_label);
        this.LnL_tf = new JTextField(25);
        ((JTextComponent)this.LnL_tf).setDocument(new DoubleDocument());
        this.addJTF(this.LnL_tf);
        if (!this.node.isExternal()) {
            this.Sum_ext_nodes_label = new JLabel("Sum of ext nodes");
            this.addJLabel(this.Sum_ext_nodes_label);
            this.Sum_ext_nodes_tf = new JTextField(25);
            this.addJTF(this.Sum_ext_nodes_tf);
            this.Sum_ext_nodes_tf.setEditable(false);
        }
        if (!this.node.isExternal()) {
            this.radiobuttonjpanel = new JPanel();
            this.radiobuttongroup = new ButtonGroup();
            this.radiobuttonjpanel.setLayout(new GridLayout(1, 3, 0, 0));
            this.radiobuttonjpanel.setBackground(background_color);
            this.Duplication_rb = new JRadioButton("Duplication");
            this.Speciation_rb = new JRadioButton("Speciation");
            this.NA_rb = new JRadioButton("Not assigned");
            this.radiobuttongroup.add(this.Duplication_rb);
            this.radiobuttongroup.add(this.Speciation_rb);
            this.radiobuttongroup.add(this.NA_rb);
            this.Duplication_rb.setEnabled(this.editable);
            this.Duplication_rb.setFont(label_font);
            this.Duplication_rb.setForeground(label_text_color);
            this.Duplication_rb.setBackground(background_color);
            this.radiobuttonjpanel.add(this.Duplication_rb);
            this.Speciation_rb.setEnabled(this.editable);
            this.Speciation_rb.setFont(label_font);
            this.Speciation_rb.setForeground(label_text_color);
            this.Speciation_rb.setBackground(background_color);
            this.radiobuttonjpanel.add(this.Speciation_rb);
            this.NA_rb.setEnabled(this.editable);
            this.NA_rb.setFont(label_font);
            this.NA_rb.setForeground(label_text_color);
            this.NA_rb.setBackground(background_color);
            this.radiobuttonjpanel.add(this.NA_rb);
            this.gbc.gridwidth = 0;
            this.gbc.fill = 2;
            this.add((Component)this.radiobuttonjpanel, this.gbc);
            this.gbc.fill = 0;
        }
        this.sep = new JSeparator();
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(10, 0, 10, 0);
        this.add((Component)this.sep, this.gbc);
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.gbc.fill = 0;
        this.buttonjpanel = new JPanel();
        this.buttonjpanel.setLayout(new GridLayout(1, 0, 20, 40));
        this.buttonjpanel.setBackground(background_color);
        this.close_button = new JButton("Close");
        this.close_button.setFont(button_font);
        this.close_button.setForeground(button_text_color);
        this.close_button.setBackground(button_background_color);
        this.close_button.addActionListener(this);
        this.buttonjpanel.add(this.close_button);
        if (this.editable) {
            this.reset_button = new JButton("Reset");
            this.reset_button.setFont(button_font);
            this.reset_button.setForeground(button_text_color);
            this.reset_button.setBackground(button_background_color);
            this.reset_button.setToolTipText("Read values for this node from tree");
            this.reset_button.addActionListener(this);
            this.buttonjpanel.add(this.reset_button);
            this.write_button = new JButton("Write to tree");
            this.write_button.setFont(button_font);
            this.write_button.setForeground(button_text_color);
            this.write_button.setBackground(button_background_color);
            this.write_button.setToolTipText("Write the values for this node to the tree");
            this.write_button.addActionListener(this);
            this.gbc.gridwidth = 0;
            this.buttonjpanel.add(this.write_button);
        }
        this.gbc.anchor = 10;
        this.add((Component)this.buttonjpanel, this.gbc);
        this.message_label = new JLabel(" ");
        this.message_label.setFont(message_font);
        this.message_label.setForeground(message_color);
        this.gbc.insets = new Insets(14, 0, 0, 0);
        this.gbc.anchor = 10;
        this.add((Component)this.message_label, this.gbc);
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.close_button) {
            this.close();
        } else {
            if (this.editable && actionEvent.getSource() == this.reset_button) {
                this.reset();
            }
            if (this.editable && actionEvent.getSource() == this.write_button) {
                this.writeToTree();
            }
            this.atvnodeframe.getATVgraphic().getTree().recalculateAndReset();
            this.atvnodeframe.getATVgraphic().repaint();
        }
    }

    private void addJLabel(JLabel jLabel) {
        this.gbc.weightx = 0.3;
        jLabel.setFont(label_font);
        jLabel.setForeground(label_text_color);
        this.gbc.gridwidth = 1;
        this.add((Component)jLabel, this.gbc);
    }

    private void addJTF(JTextField jTextField) {
        this.gbc.weightx = 0.7;
        jTextField.setMinimumSize(jTextField.getPreferredSize());
        jTextField.setFont(tf_font);
        jTextField.setForeground(tf_text_color);
        jTextField.setBackground(tf_background_color);
        jTextField.setEditable(this.editable);
        this.gbc.gridwidth = 0;
        this.add((Component)jTextField, this.gbc);
    }

    void close() {
        this.atvnodeframe.remove();
        this.atvnodeframe.dispose();
        this.atvnodeframe = null;
    }

    private String replaceInappropriateChars(String string) {
        string = string.replace('[', '{');
        string = string.replace(']', '}');
        string = string.replace('(', '{');
        string = string.replace(')', '}');
        string = string.replace(':', '|');
        string = string.replace(',', '|');
        string = string.replace(' ', '_');
        return string;
    }

    void reset() {
        this.message_label.setText(" ");
        this.message = " ";
        if (!this.node.isPseudoNode()) {
            this.Seq_name_tf.setText(this.node.getSeqName());
        } else {
            this.Seq_name_tf.setText("*pseudo node*");
        }
        this.Species_tf.setText(this.node.getSpecies());
        if (this.node.getTaxonomyID() != -99) {
            this.taxo_id_tf.setText(String.valueOf(this.node.getTaxonomyID()));
        }
        this.EC_tf.setText(this.node.getECnumber());
        if (!this.node.isPseudoNode() && this.node.getDistanceToParent() != -99.0) {
            this.Distance_parent_tf.setText(String.valueOf(this.node.getDistanceToParent()));
        } else {
            this.Distance_parent_tf.setText("");
        }
        if (this.node.isLnLonParentBranchAssigned()) {
            this.LnL_tf.setText(String.valueOf(this.node.getLnLonParentBranch()));
        } else {
            this.LnL_tf.setText("");
        }
        if (!this.node.isExternal()) {
            if (this.node.getBootstrap() != -99) {
                this.Bootstrap_tf.setText(String.valueOf(this.node.getBootstrap()));
            } else {
                this.Bootstrap_tf.setText("");
            }
            this.Sum_ext_nodes_tf.setText(String.valueOf(this.node.getSumExtNodes()));
            if (!this.node.isDuplicationOrSpecAssigned()) {
                this.NA_rb.setSelected(true);
            } else if (this.node.isDuplication()) {
                this.Duplication_rb.setSelected(true);
            } else {
                this.Speciation_rb.setSelected(true);
            }
        }
        if (this.node.isExternal()) {
            if (this.node.getOrthologous() != 0 && this.node.getOrthologous() != -11) {
                this.orthologous_tf.setText(String.valueOf(this.node.getOrthologous()));
            } else {
                this.orthologous_tf.setText("");
            }
            if (this.node.getSuperOrthologous() != 0 && this.node.getSuperOrthologous() != -11) {
                this.super_orthologous_tf.setText(String.valueOf(this.node.getSuperOrthologous()));
            } else {
                this.super_orthologous_tf.setText("");
            }
        }
    }

    void writeToTree() {
        boolean bl = false;
        double d = 0.0;
        float f = 0.0f;
        int n = 0;
        this.message = " ";
        this.message_label.setText(" ");
        this.node.setSeqName(this.replaceInappropriateChars(this.Seq_name_tf.getText().trim()));
        this.node.setSpecies(this.replaceInappropriateChars(this.Species_tf.getText().trim()));
        this.node.setECnumber(this.replaceInappropriateChars(this.EC_tf.getText().trim()));
        if (this.taxo_id_tf.getText().trim().length() > 0) {
            bl = false;
            try {
                n = Integer.parseInt(this.taxo_id_tf.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
                this.message = "NumberFormatException. ";
            }
            if (!bl) {
                this.node.setTaxonomyID(n);
            }
        }
        if (this.Distance_parent_tf.getText().trim().length() > 0) {
            bl = false;
            try {
                d = Double.valueOf(this.Distance_parent_tf.getText().trim());
                if (d < 0.0) {
                    d = 0.0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
                this.message = "NumberFormatException. ";
            }
            if (!bl) {
                this.node.setDistanceToParent(d);
            }
        } else {
            this.node.setDistanceToParent(-99.0);
        }
        if (this.LnL_tf.getText().trim().length() > 0) {
            bl = false;
            try {
                f = Float.valueOf(this.LnL_tf.getText().trim()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
                this.message = "NumberFormatException. ";
            }
            if (!bl) {
                this.node.setLnLonParentBranch(f);
            }
        } else {
            this.node.setLnLonParentBranch(0.0f);
            this.node.setLnLonParentBranchAssigned(false);
        }
        if (!this.node.isExternal()) {
            if (this.Bootstrap_tf.getText().trim().length() > 0) {
                bl = false;
                try {
                    n = Integer.parseInt(this.Bootstrap_tf.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    this.message = "NumberFormatException. ";
                }
                if (!bl) {
                    this.node.setBootstrap(n);
                }
            } else {
                this.node.setBootstrap(-99);
            }
            if (this.Duplication_rb.isSelected()) {
                this.node.setDuplication(true);
            } else if (this.Speciation_rb.isSelected()) {
                this.node.setDuplication(false);
            } else {
                this.node.setDuplicationOrSpecAssigned(false);
            }
        }
        if (this.node.isExternal()) {
            if (this.orthologous_tf.getText().trim().length() > 0) {
                bl = false;
                try {
                    n = Integer.parseInt(this.orthologous_tf.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    this.message = "NumberFormatException. ";
                }
                if (!bl) {
                    if (n > 0) {
                        this.node.setOrthologous(n);
                    } else {
                        this.node.setOrthologous(0);
                    }
                }
            } else {
                this.node.setOrthologous(0);
            }
            if (this.super_orthologous_tf.getText().trim().length() > 0) {
                bl = false;
                try {
                    n = Integer.parseInt(this.super_orthologous_tf.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    this.message = "NumberFormatException. ";
                }
                if (!bl) {
                    if (n > 0) {
                        this.node.setSuperOrthologous(n);
                    } else {
                        this.node.setSuperOrthologous(0);
                    }
                }
            } else {
                this.node.setSuperOrthologous(0);
            }
        }
        if (this.message.length() > 1) {
            Toolkit.getDefaultToolkit().beep();
            this.message_label.setText(this.message);
            this.message = " ";
        } else {
            this.reset();
        }
    }
}

