/*
 * Decompiled with CFR 0.152.
 */
package forester.tree;

import java.io.Serializable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class Node
implements Serializable {
    static final long serialVersionUID = -896584903030L;
    public static final double DISTANCE_DEFAULT = -99.0;
    public static final int BOOTSTRAP_DEFAULT = -99;
    public static final int TAXO_ID_DEFAULT = -99;
    public static final double DISTANCE_NULL = -100.0;
    public static final int SEQ_X = -11;
    public static final int ORTHOLOGOUS_DEFAULT = 0;
    private static int node_count = 0;
    private int indicator;
    private int id = 0;
    private int taxo_id;
    private int bootstrap;
    private int sum_ext_nodes;
    private int orthologous;
    private int super_orthologous;
    private int x;
    private int y;
    private String seq_name;
    private String ec_number;
    private String species;
    private double distance_parent;
    private float lnL_on_parent_branch;
    private boolean lnL_on_parent_branch_assigned;
    private boolean significantly_worse;
    private boolean duplication_or_spec_assigned;
    private boolean duplication;
    private boolean collapse;
    private Node next_ext_node = null;
    private Node prev_ext_node = null;
    private Node child1 = null;
    private Node child2 = null;
    private Node parent = null;
    private Node link;
    private Vector vector;

    public Node() {
        this.deleteData();
        this.setID(Node.getNodeCount());
        Node.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    public Node(String string) throws Exception {
        this.deleteData();
        if (string != null && string.length() > 0) {
            int n = 0;
            int n2 = 0;
            String string2 = "";
            String string3 = "";
            StringTokenizer stringTokenizer = null;
            n = string.indexOf("[");
            n2 = string.indexOf("]");
            if (n > -1) {
                string2 = "";
                string3 = "";
                if (n2 < 0) {
                    throw new Exception("Node( String ): Error in NHX format: No closing ]");
                }
                if (string.indexOf("&&NHX") == n + 1) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 6, n2);
                } else {
                    string2 = string.substring(0, n);
                }
                string = String.valueOf(string2) + string3;
                if (string.indexOf("[") > -1 || string.indexOf("]") > -1) {
                    throw new Exception("Node( String ): Error in NHX format: More than one ] or [");
                }
            }
            if ((stringTokenizer = new StringTokenizer(string, ":")).countTokens() >= 1) {
                if (!string.startsWith(":")) {
                    this.setSeqName(stringTokenizer.nextToken());
                }
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (string.startsWith("S=")) {
                        this.setSpecies(string.substring(2));
                        continue;
                    }
                    if (string.startsWith("E=")) {
                        this.setECnumber(string.substring(2));
                        continue;
                    }
                    if (string.startsWith("L=")) {
                        this.setLnLonParentBranch(Float.valueOf(string.substring(2)).floatValue());
                        continue;
                    }
                    if (string.startsWith("D=")) {
                        if (string.charAt(2) == 'Y') {
                            this.setDuplication(true);
                            continue;
                        }
                        if (string.charAt(2) == 'N') {
                            this.setDuplication(false);
                            continue;
                        }
                        throw new Exception("Node( String ): Error in NHX format: :D=Y or :D=N");
                    }
                    if (string.startsWith("Sw=")) {
                        if (string.charAt(3) == 'Y') {
                            this.setSignificantlyWorse(true);
                            continue;
                        }
                        if (string.charAt(3) == 'N') {
                            this.setSignificantlyWorse(false);
                            continue;
                        }
                        throw new Exception("Node( String ): Error in NHX format: :Sw=Y or :Sw=N");
                    }
                    if (string.startsWith("Co=")) {
                        if (string.charAt(3) == 'Y') {
                            this.setCollapse(true);
                            continue;
                        }
                        if (string.charAt(3) == 'N') {
                            this.setCollapse(false);
                            continue;
                        }
                        throw new Exception("Node( String ): Error in NHX format: :Co=Y or :Co=N");
                    }
                    if (string.startsWith("B=")) {
                        this.setBootstrap(Integer.parseInt(string.substring(2)));
                        continue;
                    }
                    if (string.startsWith("T=")) {
                        this.setTaxonomyID(Integer.parseInt(string.substring(2)));
                        continue;
                    }
                    if (string.startsWith("O=")) {
                        this.setOrthologous(Integer.parseInt(string.substring(2)));
                        continue;
                    }
                    if (string.startsWith("SO=")) {
                        this.setSuperOrthologous(Integer.parseInt(string.substring(3)));
                        continue;
                    }
                    if (string.startsWith("Bp=")) continue;
                    if (this.distance_parent != -99.0) {
                        throw new Exception("Node( String ): Error in NHX format: More than one distance to parent or non existing tag used.");
                    }
                    this.setDistanceToParent(Double.valueOf(string));
                }
            }
        }
        this.setID(Node.getNodeCount());
        Node.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    void addExtNode(String string) throws Exception {
        Node node = this.getLastExtNode();
        node.setNextExtNode(new Node(string));
        node.getNextExtNode().setPrevExtNode(node);
    }

    public boolean collapse() {
        return this.collapse;
    }

    public static boolean compareArraysOfNodes(Node[] nodeArray, Node[] nodeArray2) throws Exception {
        int n = 0;
        int n2 = 0;
        Node[] nodeArray3 = null;
        if (nodeArray.length != nodeArray2.length) {
            return false;
        }
        nodeArray3 = new Node[nodeArray2.length];
        n = 0;
        while (n < nodeArray2.length) {
            nodeArray3[n] = nodeArray2[n].copyNodeData();
            ++n;
        }
        n = 0;
        while (n < nodeArray.length) {
            block5: {
                n2 = 0;
                while (n2 < nodeArray3.length) {
                    if (!nodeArray[n].equals(nodeArray2[n2])) {
                        ++n2;
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            nodeArray3[n2] = null;
            ++n;
        }
        return true;
    }

    void connect(String string) throws Exception {
        Node node;
        Node node2 = this.getLastExtNode();
        Node node3 = node2.getRoot();
        while (node3 == (node = (node2 = node2.getPrevExtNode()).getRoot())) {
        }
        node3.setParent(new Node(string));
        node.setParent(node3.getParent());
        node3.getParent().setChild1(node);
        node3.getParent().setChild2(node3);
        node3.getParent().setSumExtNodes(node3.getSumExtNodes() + node.getSumExtNodes());
    }

    /*
     * Unable to fully structure code
     */
    public Node[] copyAllExtChildren() throws Exception {
        block4: {
            var1_1 = 1;
            var3_2 = this;
            var4_3 = this;
            if (!this.isExternal()) ** GOTO lbl8
            var5_4 = new Node[]{this.copyNodeData()};
            break block4;
lbl-1000:
            // 1 sources

            {
                var3_2 = var3_2.getChild1();
lbl8:
                // 2 sources

                ** while (!var3_2.isExternal())
            }
lbl9:
            // 2 sources

            while (!var4_3.isExternal()) {
                var4_3 = var4_3.getChild2();
            }
            var2_5 = var3_2;
            do {
                var2_5 = var2_5.getNextExtNode();
                ++var1_1;
            } while (var2_5 != var4_3);
            var5_4 = new Node[var1_1];
            var2_5 = var3_2;
            var1_1 = 0;
            while (var1_1 < var5_4.length) {
                var5_4[var1_1] = var2_5.copyNodeData();
                var2_5 = var2_5.getNextExtNode();
                ++var1_1;
            }
        }
        return var5_4;
    }

    public Node copyNodeData() {
        Node node = null;
        node = new Node();
        Node.decreaseNodeCount();
        node.id = this.id;
        node.bootstrap = this.bootstrap;
        node.sum_ext_nodes = this.sum_ext_nodes;
        node.indicator = this.indicator;
        node.x = this.x;
        node.y = this.y;
        node.duplication = this.duplication;
        node.seq_name = this.seq_name;
        node.ec_number = this.ec_number;
        node.species = this.species;
        node.taxo_id = this.taxo_id;
        node.orthologous = this.orthologous;
        node.super_orthologous = this.super_orthologous;
        node.distance_parent = this.distance_parent;
        node.lnL_on_parent_branch = this.lnL_on_parent_branch;
        node.lnL_on_parent_branch_assigned = this.lnL_on_parent_branch_assigned;
        node.significantly_worse = this.significantly_worse;
        node.duplication_or_spec_assigned = this.duplication_or_spec_assigned;
        node.collapse = this.collapse;
        node.link = this.link;
        node.vector = this.vector;
        return node;
    }

    static Node copyTree(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = node.copyNodeData();
        node2.child1 = Node.copyTree(node.child1);
        node2.child2 = Node.copyTree(node.child2);
        return node2;
    }

    static void decreaseNodeCount() {
        --node_count;
    }

    public void deleteData() {
        this.indicator = 0;
        this.taxo_id = -99;
        this.bootstrap = -99;
        this.orthologous = 0;
        this.super_orthologous = 0;
        this.x = 0;
        this.y = 0;
        this.seq_name = "";
        this.ec_number = "";
        this.species = "";
        this.distance_parent = -99.0;
        this.lnL_on_parent_branch = 0.0f;
        this.lnL_on_parent_branch_assigned = false;
        this.significantly_worse = true;
        this.duplication_or_spec_assigned = false;
        this.duplication = false;
        this.collapse = false;
        this.link = null;
        this.vector = null;
    }

    public boolean equals(Node node) {
        return node != null && this.getSeqName().equals(node.getSeqName()) && this.getSpecies().equals(node.getSpecies()) && this.getECnumber().equals(node.getECnumber()) && this.getTaxonomyID() == node.getTaxonomyID();
    }

    public Vector getAllChildren() {
        Vector<Node> vector = new Vector<Node>();
        if (this.isExternal()) {
            return null;
        }
        Node node = this;
        while (!node.isExternal()) {
            node = node.getChild1();
        }
        Node node2 = this;
        while (!node2.isExternal()) {
            node2 = node2.getChild2();
        }
        this.setIndicatorsToZero();
        do {
            Node node3 = node;
            do {
                if (node3.getIndicator() != 0) continue;
                node3.setIndicator(1);
                if (node3.isPseudoNode() || node3 == this) continue;
                vector.addElement(node3);
            } while ((node3 = node3.getParent()) != this);
        } while ((node = node.getNextExtNode()) != null && node.getPrevExtNode() != node2);
        vector.trimToSize();
        return vector;
    }

    public Vector getAllExternalChildren() {
        Vector<Node> vector = new Vector<Node>();
        Node node = null;
        Node node2 = null;
        if (this.isExternal()) {
            vector.addElement(this);
            vector.trimToSize();
            return vector;
        }
        node = this;
        while (!node.isExternal()) {
            node = node.getChild1();
        }
        node2 = this;
        while (!node2.isExternal()) {
            node2 = node2.getChild2();
        }
        do {
            vector.addElement(node);
        } while ((node = node.getNextExtNode()) != node2);
        vector.addElement(node);
        vector.trimToSize();
        return vector;
    }

    public int getBootstrap() {
        return this.bootstrap;
    }

    public Node getChild1() {
        return this.child1;
    }

    public Node getChild2() {
        return this.child2;
    }

    public double getDistanceToParent() {
        return this.distance_parent;
    }

    public String getECnumber() {
        return this.ec_number;
    }

    public int getID() {
        return this.id;
    }

    public int getIndicator() {
        return this.indicator;
    }

    Node getLastExtNode() {
        Node node = this;
        while (!node.isExternal()) {
            node = node.getChild1();
        }
        while (node.getNextExtNode() != null) {
            node = node.getNextExtNode();
        }
        return node;
    }

    public Node getLink() {
        return this.link;
    }

    public float getLnLonParentBranch() {
        return this.lnL_on_parent_branch;
    }

    public Node getNextExtNode() {
        return this.next_ext_node;
    }

    public static int getNodeCount() {
        return node_count;
    }

    public int getOrthologous() {
        return this.orthologous;
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getPrevExtNode() {
        return this.prev_ext_node;
    }

    Node getRoot() {
        Node node = this;
        while (!node.isRoot()) {
            node = node.getParent();
        }
        return node;
    }

    public String getSeqName() {
        return this.seq_name;
    }

    public String getSpecies() {
        return this.species;
    }

    public int getSumExtNodes() {
        return this.sum_ext_nodes;
    }

    public int getSuperOrthologous() {
        return this.super_orthologous;
    }

    public int getTaxonomyID() {
        return this.taxo_id;
    }

    public Vector getVector() {
        return this.vector;
    }

    public int getXcoord() {
        return this.x;
    }

    public int getYcoord() {
        return this.y;
    }

    public static void increaseNodeCount() {
        ++node_count;
    }

    public boolean isChild1() {
        return this.getParent() != null && this.getParent().getChild2() != this;
    }

    public boolean isDuplication() {
        return this.duplication;
    }

    public boolean isDuplicationOrSpecAssigned() {
        return this.duplication_or_spec_assigned;
    }

    public boolean isExternal() {
        return this.getChild1() == null;
    }

    public boolean isLnLonParentBranchAssigned() {
        return this.lnL_on_parent_branch_assigned;
    }

    public boolean isPseudoNode() {
        return this.getDistanceToParent() == -100.0;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public void preorderPrint() {
        System.out.println(String.valueOf(String.valueOf(this)) + "\n");
        if (this.getChild1() != null) {
            this.getChild1().preorderPrint();
        }
        if (this.getChild2() != null) {
            this.getChild2().preorderPrint();
        }
    }

    public void setBootstrap(int n) {
        if (n < 0 && n != -99) {
            this.bootstrap = 0;
            System.err.print("Node: setBootstrap( int ): WARNING: Negative ");
            System.err.println("bootstrap has been replaced by bootstrap 0!\n");
        } else {
            this.bootstrap = n;
        }
    }

    public void setChild1(Node node) {
        this.child1 = node;
    }

    public void setChild2(Node node) {
        this.child2 = node;
    }

    public void setCollapse(boolean bl) {
        this.collapse = bl;
    }

    public void setDistanceToParent(double d) {
        this.distance_parent = d < 0.0 && d != -99.0 && d != -100.0 ? 0.0 : d;
    }

    public void setDuplication(boolean bl) {
        this.duplication = bl;
        this.setDuplicationOrSpecAssigned(true);
    }

    public void setDuplicationOrSpecAssigned(boolean bl) {
        this.duplication_or_spec_assigned = bl;
    }

    public void setECnumber(String string) {
        this.ec_number = string.trim();
    }

    public void setID(int n) {
        this.id = n;
    }

    public void setIndicator(int n) {
        this.indicator = n;
    }

    void setIndicatorsToZero() {
        Stack<Node> stack = new Stack<Node>();
        Node node = this;
        stack.push(node);
        while (!stack.empty()) {
            node = (Node)stack.pop();
            node.setIndicator(0);
            if (node.getChild1() != null) {
                stack.push(node.getChild1());
            }
            if (node.getChild2() == null) continue;
            stack.push(node.getChild2());
        }
    }

    public void setLink(Node node) {
        this.link = node;
    }

    public void setLnLonParentBranch(float f) {
        this.lnL_on_parent_branch = f;
        this.setLnLonParentBranchAssigned(true);
    }

    public void setLnLonParentBranchAssigned(boolean bl) {
        this.lnL_on_parent_branch_assigned = bl;
    }

    public void setNextExtNode(Node node) {
        this.next_ext_node = node;
    }

    public static void setNodeCount(int n) {
        node_count = n;
    }

    public void setOrthologous(int n) {
        this.orthologous = n;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    void setParents() {
        Node node = this;
        Node node2 = this;
        Node node3 = null;
        boolean bl = false;
        if (this.isExternal()) {
            return;
        }
        node.setIndicatorsToZero();
        while (!bl) {
            if (node2 == node && node.getIndicator() == 2) {
                bl = true;
                continue;
            }
            if (node2.getIndicator() == 0 && !node2.isExternal()) {
                node2.setParent(node3);
                node3 = node2;
                node2.setIndicator(1);
                node2 = node2.getChild1();
                continue;
            }
            if (node2.getIndicator() == 1 && !node2.isExternal()) {
                node3 = node2;
                node2.setIndicator(2);
                node2 = node2.getChild2();
                continue;
            }
            if (node2.getIndicator() == 2 && !node2.isExternal()) {
                node2 = node2.getParent();
                continue;
            }
            if (!node2.isExternal()) continue;
            node2.setParent(node3);
            node2 = node3;
        }
    }

    public void setPrevExtNode(Node node) {
        this.prev_ext_node = node;
    }

    public void setSeqName(String string) {
        this.seq_name = string.trim();
    }

    public void setSignificantlyWorse(boolean bl) {
        this.significantly_worse = bl;
    }

    public void setSpecies(String string) {
        this.species = string.trim();
    }

    public void setSumExtNodes(int n) {
        this.sum_ext_nodes = n;
    }

    public void setSuperOrthologous(int n) {
        this.super_orthologous = n;
    }

    public void setTaxonomyID(int n) {
        this.taxo_id = n;
    }

    public void setVector(Vector vector) {
        this.vector = vector;
    }

    public void setXcoord(int n) {
        this.x = n;
    }

    public void setYcoord(int n) {
        this.y = n;
    }

    public boolean significantlyWorse() {
        return this.significantly_worse;
    }

    String toNewHampshireX() {
        StringBuffer stringBuffer = new StringBuffer(200);
        StringBuffer stringBuffer2 = new StringBuffer(200);
        if (!this.getSeqName().equals("")) {
            stringBuffer.append(this.getSeqName());
        }
        if (this.getDistanceToParent() >= 0.0) {
            stringBuffer.append(":");
            stringBuffer.append(this.getDistanceToParent());
        }
        if (!this.getSpecies().equals("")) {
            stringBuffer2.append(":S=");
            stringBuffer2.append(this.getSpecies());
        }
        if (this.getTaxonomyID() > 0) {
            stringBuffer2.append(":T=");
            stringBuffer2.append(this.getTaxonomyID());
        }
        if (!this.getECnumber().equals("")) {
            stringBuffer2.append(":E=");
            stringBuffer2.append(this.getECnumber());
        }
        if (this.isLnLonParentBranchAssigned()) {
            stringBuffer2.append(":L=");
            stringBuffer2.append(this.getLnLonParentBranch());
            if (this.significantlyWorse()) {
                stringBuffer2.append(":Sw=Y");
            } else {
                stringBuffer2.append(":Sw=N");
            }
        }
        if (!this.isExternal()) {
            if (this.isDuplicationOrSpecAssigned()) {
                if (this.isDuplication()) {
                    stringBuffer2.append(":D=Y");
                } else {
                    stringBuffer2.append(":D=N");
                }
            }
            if (this.getBootstrap() != -99) {
                stringBuffer2.append(":B=");
                stringBuffer2.append(this.getBootstrap());
            }
            if (this.collapse()) {
                stringBuffer2.append(":Co=Y");
            }
        } else {
            if (this.getSuperOrthologous() != 0) {
                stringBuffer2.append(":SO=");
                stringBuffer2.append(this.getSuperOrthologous());
            }
            if (this.getOrthologous() != 0) {
                stringBuffer2.append(":O=");
                stringBuffer2.append(this.getOrthologous());
            }
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("[&&NHX");
            stringBuffer.append((Object)stringBuffer2);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = "";
        string = !this.isPseudoNode() ? "\nSeq name                : " + this.getSeqName() : "\nSeq name                :  *pseudo node*";
        string = String.valueOf(string) + "\nEC number               : " + this.getECnumber();
        string = String.valueOf(string) + "\nSpecies                 : " + this.getSpecies();
        string = this.getTaxonomyID() > 0 ? String.valueOf(string) + "\nTaxonomy ID             : " + this.getTaxonomyID() : String.valueOf(string) + "\nTaxonomy ID             : n/a";
        string = !this.isPseudoNode() && this.getDistanceToParent() != -99.0 ? String.valueOf(string) + "\nDistance to parent      : " + this.getDistanceToParent() : String.valueOf(string) + "\nDistance to parent      : n/a";
        string = this.getBootstrap() != -99 ? String.valueOf(string) + "\nBootstrap value         : " + this.getBootstrap() : String.valueOf(string) + "\nBootstrap value         : n/a";
        string = this.isLnLonParentBranchAssigned() ? String.valueOf(string) + "\nlnL on parent branch    : " + this.getLnLonParentBranch() : String.valueOf(string) + "\nlnL on parent branch    : n/a";
        string = String.valueOf(string) + "\nL: Significantly worse  : " + this.significantlyWorse();
        string = this.isDuplicationOrSpecAssigned() ? String.valueOf(string) + "\nDuplication             : " + this.isDuplication() : String.valueOf(string) + "\nDuplication             : n/a";
        if (this.isExternal()) {
            if (this.getSuperOrthologous() != 0) {
                string = String.valueOf(string) + "\nSuper orthologous       : " + this.getSuperOrthologous();
            }
            if (this.getOrthologous() != 0) {
                string = String.valueOf(string) + "\nOrthologous             : " + this.getOrthologous();
            }
        }
        string = String.valueOf(string) + "\nSum of ext nodes\t: " + this.getSumExtNodes();
        string = String.valueOf(string) + "\nID                      : " + this.getID();
        string = !this.isRoot() ? String.valueOf(string) + "\nID of parent            : " + this.getParent().getID() : String.valueOf(string) + "\nID of parent            : n/a (root or pseudo root)";
        if (!this.isExternal()) {
            string = String.valueOf(string) + "\nID of child1            : " + this.getChild1().getID();
            string = String.valueOf(string) + "\nID of child2            : " + this.getChild2().getID();
        } else {
            string = String.valueOf(string) + "\nID of child             : n/a (external node)";
        }
        string = String.valueOf(string) + "\n";
        return string;
    }
}

