/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Vector;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class SixFrameRenderer
extends AbstractChangeable
implements SequenceRenderer {
    private double bandWidth = 25.0;
    private double blockWidth = 20.0;
    private Paint outline = Color.blue;
    private Paint fill = Color.red;
    private Paint lines = Color.black;
    StrandedFeature.Strand strand;
    boolean zigPrecedesBlock;
    boolean phaseKnown;
    Point2D.Double zigOriginP;
    int zigOriginS;
    int moduloFrame;
    double offsetPrevBlock;

    public double getDepth(SequenceRenderContext src) {
        return 6.0 * this.bandWidth + 1.0;
    }

    public double getMinimumLeader(SequenceRenderContext src) {
        return 0.0;
    }

    public double getMinimumTrailer(SequenceRenderContext src) {
        return 0.0;
    }

    private double frameOffset(int moduloFrame, StrandedFeature.Strand strand) {
        if (strand == StrandedFeature.NEGATIVE) {
            return this.bandWidth * (double)(moduloFrame + 3);
        }
        return this.bandWidth * (double)moduloFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFill(Paint p) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.REPAINT);
                cs.firePreChangeEvent(ce);
                this.fill = p;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.fill = p;
        }
    }

    public Paint getFill() {
        return this.fill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutline(Paint p) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.REPAINT);
                cs.firePreChangeEvent(ce);
                this.outline = p;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.outline = p;
        }
    }

    public Paint getOutline() {
        return this.outline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockWidth(double width) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT);
                cs.firePreChangeEvent(ce);
                this.blockWidth = width;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.blockWidth = width;
        }
    }

    public double getBlockWidth() {
        return this.blockWidth;
    }

    public void startZiggy(StrandedFeature.Strand strand) {
        System.out.println("startZiggy strand: " + strand);
        this.zigPrecedesBlock = false;
        this.phaseKnown = false;
        this.strand = strand;
    }

    public void startZiggy(StrandedFeature.Strand strand, int phase) {
        this.zigPrecedesBlock = false;
        this.phaseKnown = true;
        this.moduloFrame = phase;
        this.strand = strand;
    }

    public void renderLocation(Graphics2D g, SequenceRenderContext src, Location loc) {
        Paint prevPaint;
        double offset;
        int minS = loc.getMin();
        int maxS = loc.getMax();
        double minP = src.sequenceToGraphics(minS);
        double maxP = src.sequenceToGraphics(maxS);
        if (this.zigPrecedesBlock) {
            Point2D.Double terminal;
            Point2D.Double midpoint;
            double terminalSeqCoord = minP;
            this.moduloFrame = (this.moduloFrame + minS - 1 - this.zigOriginS) % 3;
            offset = this.frameOffset(this.moduloFrame, this.strand);
            double midpointOffset = this.strand == StrandedFeature.POSITIVE ? Math.min(offset, this.offsetPrevBlock) : Math.max(offset, this.offsetPrevBlock) + this.blockWidth;
            double terminalDrawCoord = offset + 0.5 * this.blockWidth;
            if (src.getDirection() == 0) {
                double midpointSeqCoord = 0.5 * (this.zigOriginP.getX() + terminalSeqCoord);
                midpoint = new Point2D.Double(midpointSeqCoord, midpointOffset);
                terminal = new Point2D.Double(terminalSeqCoord, terminalDrawCoord);
            } else {
                double midpointSeqCoord = 0.5 * (this.zigOriginP.getY() + terminalSeqCoord);
                midpoint = new Point2D.Double(midpointOffset, midpointSeqCoord);
                terminal = new Point2D.Double(terminalDrawCoord, terminalSeqCoord);
            }
            Paint prevPaint2 = g.getPaint();
            g.setPaint(this.outline);
            Line2D.Double line = new Line2D.Double(this.zigOriginP, midpoint);
            g.draw(line);
            line = new Line2D.Double(midpoint, terminal);
            g.draw(line);
            g.setPaint(prevPaint2);
        } else {
            if (!this.phaseKnown) {
                this.moduloFrame = minS % 3;
            }
            offset = this.frameOffset(this.moduloFrame, this.strand);
            this.zigPrecedesBlock = true;
        }
        Rectangle2D.Double block = new Rectangle2D.Double();
        if (src.getDirection() == 0) {
            block.setFrame(minP, offset, maxP - minP, this.blockWidth);
        } else {
            block.setFrame(offset, minP, this.blockWidth, maxP - minP);
        }
        if (this.fill != null) {
            prevPaint = g.getPaint();
            g.setPaint(this.fill);
            g.fill(block);
            g.setPaint(prevPaint);
        }
        if (this.outline != null) {
            prevPaint = g.getPaint();
            g.setPaint(this.outline);
            g.draw(block);
            g.setPaint(prevPaint);
        }
        double drawCoord = offset + 0.5 * this.blockWidth;
        double seqCoord = maxP;
        this.zigOriginS = maxS;
        this.offsetPrevBlock = offset;
        this.zigOriginP = src.getDirection() == 0 ? new Point2D.Double(seqCoord, drawCoord) : new Point2D.Double(drawCoord, seqCoord);
    }

    public List sequenceExtentOfPixels(SequenceRenderContext src) {
        RangeLocation rangeS = src.getRange();
        int minLocS = rangeS.getMin();
        int maxLocS = rangeS.getMax();
        int minP = (int)src.sequenceToGraphics(minLocS);
        int maxP = (int)src.sequenceToGraphics(maxLocS);
        Vector<RangeLocation> extentList = new Vector<RangeLocation>(maxP - minP + 1, 20);
        int currP = minP;
        while (currP < maxP) {
            int minRange = Math.max(src.graphicsToSequence(currP), minLocS);
            int maxRange = Math.min(src.graphicsToSequence(currP + 1) - 1, maxLocS);
            extentList.add(new RangeLocation(minRange, maxRange));
            ++currP;
        }
        return extentList;
    }

    public void drawLine(Graphics2D g, SequenceRenderContext src, int base, StrandedFeature.Strand strand) {
        Paint prevPaint = g.getPaint();
        g.setPaint(this.lines);
        int moduloFrame = base % 3;
        double offset = this.frameOffset(moduloFrame, strand);
        int lineP = (int)src.sequenceToGraphics(base);
        if (src.getDirection() == 0) {
            g.drawLine(lineP, (int)offset, lineP, (int)(offset + this.blockWidth));
        } else {
            g.drawLine((int)offset, lineP, (int)(offset + this.blockWidth), lineP);
        }
        g.setPaint(prevPaint);
    }

    public void paint(Graphics2D g, SequenceRenderContext src) {
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext src, MouseEvent me, List path) {
        path.add(this);
        int sPos = src.graphicsToSequence(me.getPoint());
        return new SequenceViewerEvent(this, null, sPos, me, path);
    }
}

