/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SixFrameRenderer;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleAssembly;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeVetoException;

public class SixFrameZiggyRenderer
extends AbstractChangeable
implements FeatureRenderer,
Serializable {
    private SixFrameRenderer pane;

    public SixFrameZiggyRenderer(SixFrameRenderer pane) {
        this.pane = pane;
    }

    public void setFill(Paint p) throws ChangeVetoException {
        this.pane.setFill(p);
    }

    public Paint getFill() {
        return this.pane.getFill();
    }

    public void setOutline(Paint p) throws ChangeVetoException {
        this.pane.setOutline(p);
    }

    public Paint getOutline() {
        return this.pane.getOutline();
    }

    public void setBlockDepth(double depth) throws ChangeVetoException {
        this.pane.setBlockWidth(depth);
    }

    public double getBlockDepth() {
        return this.pane.getBlockWidth();
    }

    public double getDepth(SequenceRenderContext src) {
        return this.pane.getDepth(src);
    }

    private boolean isStop(Sequence seq, int base, StrandedFeature.Strand strand) {
        if (strand == StrandedFeature.POSITIVE) {
            if (seq.symbolAt(base) != DNATools.t()) {
                return false;
            }
            if (seq.symbolAt(base + 1) == DNATools.c()) {
                return false;
            }
            if (seq.symbolAt(base + 1) == DNATools.t()) {
                return false;
            }
            if (seq.symbolAt(base + 1) == DNATools.g()) {
                if (seq.symbolAt(base + 2) != DNATools.a()) {
                    return false;
                }
            } else {
                if (seq.symbolAt(base + 2) == DNATools.c()) {
                    return false;
                }
                if (seq.symbolAt(base + 2) == DNATools.t()) {
                    return false;
                }
            }
            return true;
        }
        if (seq.symbolAt(base) != DNATools.a()) {
            return false;
        }
        if (seq.symbolAt(base - 1) == DNATools.a()) {
            return false;
        }
        if (seq.symbolAt(base - 1) == DNATools.g()) {
            return false;
        }
        if (seq.symbolAt(base - 1) == DNATools.c()) {
            if (seq.symbolAt(base - 2) != DNATools.t()) {
                return false;
            }
        } else {
            if (seq.symbolAt(base - 2) == DNATools.a()) {
                return false;
            }
            if (seq.symbolAt(base - 2) == DNATools.g()) {
                return false;
            }
        }
        return true;
    }

    private int findORF(Sequence seq, StrandedFeature.Strand strand) {
        int currORFSize;
        int endSearch;
        int startSearch;
        int[] lastStop = new int[]{0, 0, 0};
        int bestPhase = 0;
        int highestORFSize = 0;
        int length = seq.length();
        if (length < 4) {
            return 0;
        }
        if (strand == StrandedFeature.POSITIVE) {
            startSearch = 1;
            endSearch = length - 2;
        } else {
            startSearch = 3;
            endSearch = length;
        }
        int i = startSearch;
        while (i <= endSearch) {
            if (this.isStop(seq, i, strand)) {
                int phase = i % 3;
                currORFSize = i - lastStop[phase];
                if (currORFSize > highestORFSize) {
                    bestPhase = phase;
                    highestORFSize = currORFSize;
                }
                lastStop[phase] = i;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < 3) {
            currORFSize = endSearch - lastStop[i2];
            if (currORFSize > highestORFSize) {
                bestPhase = i2;
                highestORFSize = currORFSize;
            }
            ++i2;
        }
        return bestPhase;
    }

    private Sequence assembleFusedSequence(Feature[] block, Sequence seq) {
        SimpleAssembly sa = new SimpleAssembly("temp", "temp");
        ComponentFeature.Template cft = new ComponentFeature.Template();
        cft.annotation = Annotation.EMPTY_ANNOTATION;
        cft.strand = StrandedFeature.POSITIVE;
        cft.componentSequence = seq;
        int last = 0;
        int j = 0;
        while (j < block.length) {
            Feature thisExon = block[j];
            cft.componentLocation = thisExon.getLocation();
            int length = cft.componentLocation.getMax() - cft.componentLocation.getMin() + 1;
            cft.location = new RangeLocation(last + 1, last + length);
            last += length;
            try {
                sa.createFeature(cft);
            }
            catch (BioException be) {
                throw new BioError(be, "Couldn't merge exons.");
            }
            catch (ChangeVetoException cve) {
                throw new BioError(cve, "Couldn't merge exons.");
            }
            ++j;
        }
        return sa;
    }

    public void renderFeature(Graphics2D g, Feature f, SequenceRenderContext context) {
        if (!(f instanceof StrandedFeature)) {
            return;
        }
        FeatureFilter.ByType filt = new FeatureFilter.ByType("exon");
        FeatureHolder exons = f.filter(filt, false);
        int featureCount = exons.countFeatures();
        Feature[] orderedExons = new Feature[featureCount];
        int i = 0;
        Iterator fi = exons.features();
        while (fi.hasNext()) {
            orderedExons[i++] = (Feature)fi.next();
        }
        Arrays.sort(orderedExons, new Feature.ByLocationComparator());
        Sequence fused = this.assembleFusedSequence(orderedExons, f.getSequence());
        StrandedFeature.Strand strand = ((StrandedFeature)f).getStrand();
        int phase = this.findORF(fused, strand);
        Location loc = null;
        i = 0;
        while (i < orderedExons.length) {
            loc = orderedExons[i].getLocation();
            if (i == 0) {
                this.pane.startZiggy(strand, (2 + loc.getMin() + phase) % 3);
                this.pane.renderLocation(g, context, loc);
            } else {
                this.pane.renderLocation(g, context, loc);
            }
            ++i;
        }
    }

    public FeatureHolder processMouseEvent(FeatureHolder hits, SequenceRenderContext src, MouseEvent me) {
        return hits;
    }
}

