/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceTools;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.projection.Projection;
import org.biojava.bio.seq.projection.ProjectionUtils;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.utils.ChangeVetoException;

public class RevCompSequence
extends SimpleSequence {
    private ProjectedFeatureHolder pfh;
    protected Sequence origSeq;

    public RevCompSequence(Sequence seq) throws IllegalAlphabetException {
        this(seq, seq.getURN(), seq.getName(), seq.getAnnotation());
    }

    public RevCompSequence(Sequence seq, String urn, String name, Annotation annotation) throws IllegalAlphabetException {
        super(DNATools.reverseComplement(seq), urn, name, annotation);
        this.pfh = new ProjectedFeatureHolder(seq, this, seq.length() + 1, true);
        this.origSeq = seq;
    }

    public void edit(Edit e) throws ChangeVetoException, IndexOutOfBoundsException {
        int pos = this.length() - (e.pos + e.length) + 2;
        Edit newE = null;
        try {
            newE = new Edit(pos, e.length, DNATools.reverseComplement(e.replacement));
            this.origSeq.edit(newE);
        }
        catch (IllegalAlphabetException iae) {
            throw new BioError("Error while editing RevCompSequence " + iae.getMessage());
        }
    }

    public Iterator features() {
        return this.pfh.features();
    }

    public int countFeatures() {
        return this.pfh.countFeatures();
    }

    public boolean containsFeature(Feature f) {
        return this.pfh.containsFeature(f) || this.origSeq.containsFeature(f);
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        this.pfh.removeFeature(f);
    }

    public Feature createFeature(Feature.Template ft) throws ChangeVetoException, BioException {
        ft.location = ProjectionUtils.transformLocation(ft.location, this.length() + 1, true);
        if (ft instanceof StrandedFeature.Template) {
            ((StrandedFeature.Template)ft).strand = ProjectionUtils.flipStrand(((StrandedFeature.Template)ft).strand);
        }
        Feature featureOnOrig = this.origSeq.createFeature(ft);
        return this.pfh.projectFeature(featureOnOrig);
    }

    public Feature getFeatureFromOriginal(Feature f) {
        return ((Projection)((Object)f)).getViewedFeature();
    }

    public Object clone() {
        SimpleSymbolList sl = new SimpleSymbolList(this);
        SimpleSequence newSeq = new SimpleSequence(sl, this.getURN(), this.getName(), this.getAnnotation());
        try {
            SequenceTools.addAllFeatures(newSeq, this);
        }
        catch (BioException e) {
            throw new BioError("Error while cloning RevCompSequenece: " + e.getMessage());
        }
        catch (ChangeVetoException cve) {
            throw new BioError(cve, "Couldn't modify newly created SimpleSequence");
        }
        return newSeq;
    }
}

