/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.categories;

import JSci.maths.categories.Category;
import JSci.maths.categories.Homset;
import JSci.maths.categories.Morphism;
import JSci.maths.categories.UndefinedCompositionException;

public final class Preorder
implements Category {
    private final int N;

    public Preorder(int n) {
        this.N = n;
    }

    public Morphism identity(Object object) {
        return new Relation((Integer)object, (Integer)object);
    }

    public Object cardinality(Object object) {
        return object;
    }

    public Homset homset(Object object, Object object2) {
        Integer n = (Integer)object;
        Integer n2 = (Integer)object2;
        if (n.compareTo(n2) <= 0) {
            return new RelationSet(n, n2);
        }
        return new RelationSet();
    }

    public Object initial() {
        return new Integer(0);
    }

    public Object terminal() {
        return new Integer(this.N - 1);
    }

    public int ordinal() {
        return this.N;
    }

    public class Relation
    implements Morphism {
        private final Integer from;
        private final Integer to;

        public Relation(Integer n, Integer n2) {
            this.from = n;
            this.to = n2;
        }

        public Object domain() {
            return this.from;
        }

        public Object codomain() {
            return this.to;
        }

        public Object map(Object object) {
            return this.to;
        }

        public Morphism compose(Morphism morphism) {
            if (morphism instanceof Relation) {
                Relation relation = (Relation)morphism;
                if (this.to.equals(relation.from)) {
                    return new Relation(this.from, relation.to);
                }
                throw new UndefinedCompositionException();
            }
            throw new IllegalArgumentException("Morphism is not a Relation.");
        }
    }

    public class RelationSet
    implements Homset {
        public final Relation morphism;

        public RelationSet() {
            this.morphism = null;
        }

        public RelationSet(Integer n, Integer n2) {
            this.morphism = new Relation(n, n2);
        }
    }
}

