/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class COA
extends AbstractAlgorithm {
    private boolean stop = false;
    public FloatMatrix Org;
    private int numNeighbors;
    private float factor = 1.0f;
    public Matrix N;
    public double[] R;
    public double[] C;
    public double N_Sum = 0.0;
    public double[][] P;
    public Matrix X;
    public Matrix Xt;
    public Matrix DcRoot;
    public Matrix Dr;
    public Matrix B;
    public Matrix geneUMatrix;
    public Matrix exptUMatrix;
    public FloatMatrix gene;
    public FloatMatrix expt;
    public double[] G_Sums;
    public Matrix G;
    private int numGenes;
    private int numExps;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.numNeighbors = algorithmParameters.getInt("numNeighbors", 10);
        this.Org = algorithmData.getMatrix("experiment");
        this.numGenes = this.Org.getRowDimension();
        this.numExps = this.Org.getColumnDimension();
        AlgorithmData algorithmData2 = this.Analysis(this.Org);
        return algorithmData2;
    }

    public Matrix diagonal(double[] dArray) {
        int n;
        System.out.println("Entered diagonal method");
        Matrix matrix = new Matrix(dArray.length, dArray.length);
        System.out.println("Created diagonal matrix");
        for (n = 0; n < matrix.getRowDimension(); ++n) {
            for (int i = 0; i < matrix.getColumnDimension(); ++i) {
                matrix.set(n, i, 0.0);
            }
        }
        for (n = 0; n < matrix.getRowDimension(); ++n) {
            matrix.set(n, n, Math.sqrt(dArray[n]));
        }
        return matrix;
    }

    public Matrix diagonalRoot(double[] dArray) {
        int n;
        Matrix matrix = new Matrix(dArray.length, dArray.length);
        for (n = 0; n < matrix.getRowDimension(); ++n) {
            for (int i = 0; i < matrix.getColumnDimension(); ++i) {
                matrix.set(n, i, 0.0);
            }
        }
        for (n = 0; n < matrix.getRowDimension(); ++n) {
            matrix.set(n, n, dArray[n]);
        }
        return matrix;
    }

    public double mean(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d / (double)dArray.length;
    }

    private FloatMatrix imputeKNearestMatrix(FloatMatrix floatMatrix, int n) throws AlgorithmException {
        int n2 = floatMatrix.getRowDimension();
        int n3 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n2, n3);
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numGenes);
        algorithmEvent.setDescription("Imputing missing values");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        for (int i = 0; i < n2; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            if (this.isMissingValues(floatMatrix, i)) {
                Vector<Integer> vector = new Vector<Integer>();
                for (int j = 0; j < n3; ++j) {
                    if (Float.isNaN(floatMatrix.A[i][j])) continue;
                    vector.add(new Integer(j));
                }
                Vector vector2 = this.getValidGenes(i, floatMatrix, vector);
                Vector vector3 = this.getKNearestGenes(i, n, floatMatrix, vector2, vector);
                for (int j = 0; j < n3; ++j) {
                    floatMatrix2.A[i][j] = !Float.isNaN(floatMatrix.A[i][j]) ? floatMatrix.A[i][j] : this.getExptWeightedMean(i, j, vector3, floatMatrix);
                }
                continue;
            }
            for (int j = 0; j < n3; ++j) {
                floatMatrix2.A[i][j] = floatMatrix.A[i][j];
            }
        }
        return this.imputeRowAverageMatrix(floatMatrix2);
    }

    private FloatMatrix imputeRowAverageMatrix(FloatMatrix floatMatrix) throws AlgorithmException {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        for (int i = 0; i < n; ++i) {
            int n3;
            if (this.stop) {
                throw new AbortException();
            }
            float[] fArray = new float[n2];
            float[] fArray2 = new float[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                fArray[n3] = floatMatrix.A[i][n3];
                fArray2[n3] = floatMatrix.A[i][n3];
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (!Float.isNaN(floatMatrix.A[i][n3])) continue;
                fArray[n3] = this.getMean(fArray2);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                floatMatrix2.A[i][n3] = fArray[n3];
            }
        }
        return floatMatrix2;
    }

    private boolean isMissingValues(FloatMatrix floatMatrix, int n) {
        for (int i = 0; i < floatMatrix.getColumnDimension(); ++i) {
            if (!Float.isNaN(floatMatrix.A[n][i])) continue;
            return true;
        }
        return false;
    }

    private Vector getValidGenes(int n, FloatMatrix floatMatrix, Vector vector) {
        int n2;
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n2 = 0; n2 < floatMatrix.getRowDimension(); ++n2) {
            if (!this.hasAllExpts(n2, floatMatrix, vector) || n == n2) continue;
            vector2.add(new Integer(n2));
        }
        if (vector2.size() < this.numNeighbors) {
            n2 = this.numNeighbors - vector2.size();
            Vector vector3 = this.getAdditionalGenes(n, n2, vector2, floatMatrix);
            for (int i = 0; i < vector3.size(); ++i) {
                vector2.add((Integer)vector3.get(i));
            }
        }
        return vector2;
    }

    private Vector getAdditionalGenes(int n, int n2, Vector vector, FloatMatrix floatMatrix) {
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        Vector<Float> vector4 = new Vector<Float>();
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            if (i == n) continue;
            float f = ExperimentUtil.geneEuclidianDistance(floatMatrix, null, i, n, this.factor);
            vector4.add(new Float(f));
            vector3.add(new Integer(i));
        }
        float[] fArray = new float[vector4.size()];
        for (int i = 0; i < vector4.size(); ++i) {
            float f;
            fArray[i] = f = ((Float)vector4.get(i)).floatValue();
        }
        QSort qSort = new QSort(fArray);
        float[] fArray2 = qSort.getSorted();
        int[] nArray = qSort.getOrigIndx();
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            int n5 = (Integer)vector3.get(n4);
            if (this.belongsIn(vector, n5)) continue;
            vector2.add(new Integer(n5));
            if (++n3 >= n2) break;
        }
        return vector2;
    }

    public void groups(int[][] nArray, int n) {
        int n2;
        this.G = new Matrix(this.N.getRowDimension(), n);
        this.G_Sums = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            int n3;
            double[][] dArray = this.N.getMatrix(0, this.N.getRowDimension() - 1, nArray[n2]).getArrayCopy();
            for (n3 = 0; n3 < this.G.getRowDimension(); ++n3) {
                this.G.set(n3, n2, this.mean(dArray[n3]));
            }
            for (n3 = 0; n3 < nArray[n2].length; ++n3) {
                int n4 = n2;
                this.G_Sums[n4] = this.G_Sums[n4] + this.C[nArray[n2][n3]];
            }
        }
        System.out.println("G:");
        for (n2 = 0; n2 < this.G.getRowDimension(); ++n2) {
            for (int i = 0; i < this.G.getColumnDimension(); ++i) {
                System.out.println("i: " + n2 + " , j: " + i + " , " + this.G.get(n2, i));
            }
        }
        System.out.println();
        System.out.println("G_Sums:");
        for (n2 = 0; n2 < this.G_Sums.length; ++n2) {
            System.out.println("i: " + n2 + " , " + this.G_Sums[n2]);
        }
        System.out.println();
    }

    public AlgorithmData Analysis(FloatMatrix floatMatrix) throws AlgorithmException {
        double d;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        floatMatrix = this.imputeKNearestMatrix(floatMatrix, this.numNeighbors);
        this.N = new Matrix(floatMatrix.getRowDimension(), floatMatrix.getColumnDimension());
        boolean bl = false;
        block0: for (n6 = 0; n6 < floatMatrix.getRowDimension() && !bl; ++n6) {
            for (n5 = 0; n5 < floatMatrix.getColumnDimension(); ++n5) {
                if (!(floatMatrix.get(n6, n5) < 0.0f)) continue;
                bl = true;
                continue block0;
            }
        }
        if (bl) {
            float f = Float.POSITIVE_INFINITY;
            for (n5 = 0; n5 < floatMatrix.getRowDimension(); ++n5) {
                for (int i = 0; i < floatMatrix.getColumnDimension(); ++i) {
                    f = Math.min(f, floatMatrix.get(n5, i));
                }
            }
            double d2 = -1.0 * (double)f;
            for (n4 = 0; n4 < floatMatrix.getRowDimension(); ++n4) {
                for (n3 = 0; n3 < floatMatrix.getColumnDimension(); ++n3) {
                    this.N.set(n4, n3, (double)floatMatrix.get(n4, n3) + d2);
                }
            }
        } else {
            for (n6 = 0; n6 < floatMatrix.getRowDimension(); ++n6) {
                for (n5 = 0; n5 < floatMatrix.getColumnDimension(); ++n5) {
                    this.N.set(n6, n5, (double)floatMatrix.get(n6, n5));
                }
            }
        }
        for (n2 = 0; n2 < this.N.getRowDimension(); ++n2) {
            for (int i = 0; i < this.N.getColumnDimension(); ++i) {
                this.N_Sum += this.N.get(n2, i);
            }
        }
        this.R = new double[this.N.getRowDimension()];
        for (n2 = 0; n2 < this.N.getRowDimension(); ++n2) {
            double d3 = 0.0;
            for (n4 = 0; n4 < this.N.getColumnDimension(); ++n4) {
                d3 += this.N.get(n2, n4);
            }
            this.R[n2] = d3 / this.N_Sum;
        }
        this.C = new double[this.N.getColumnDimension()];
        for (n2 = 0; n2 < this.N.getColumnDimension(); ++n2) {
            double d4 = 0.0;
            for (n4 = 0; n4 < this.N.getRowDimension(); ++n4) {
                d4 += this.N.get(n4, n2);
            }
            this.C[n2] = d4 / this.N_Sum;
        }
        this.P = new double[this.N.getRowDimension()][this.N.getColumnDimension()];
        this.X = new Matrix(this.N.getRowDimension(), this.N.getColumnDimension());
        for (n2 = 0; n2 < this.N.getRowDimension(); ++n2) {
            for (int i = 0; i < this.N.getColumnDimension(); ++i) {
                this.P[n2][i] = this.N.get(n2, i) / this.N_Sum;
                double d5 = (this.P[n2][i] - this.R[n2] * this.C[i]) / Math.sqrt(this.R[n2] * this.C[i]);
                this.X.set(n2, i, d5);
            }
        }
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(this.X);
        Matrix matrix = singularValueDecomposition.getU();
        Matrix matrix2 = singularValueDecomposition.getS();
        Matrix matrix3 = singularValueDecomposition.getV();
        this.geneUMatrix = matrix.times(matrix2);
        this.exptUMatrix = matrix3.times(matrix2);
        for (n3 = 0; n3 < this.geneUMatrix.getRowDimension(); ++n3) {
            for (n = 0; n < this.geneUMatrix.getColumnDimension(); ++n) {
                d = this.geneUMatrix.get(n3, n);
                this.geneUMatrix.set(n3, n, d / Math.sqrt(this.R[n3]));
            }
        }
        for (n3 = 0; n3 < this.exptUMatrix.getRowDimension(); ++n3) {
            for (n = 0; n < this.exptUMatrix.getColumnDimension(); ++n) {
                d = this.exptUMatrix.get(n3, n);
                this.exptUMatrix.set(n3, n, d / Math.sqrt(this.C[n3]));
            }
        }
        this.gene = new FloatMatrix(this.geneUMatrix.getRowDimension(), this.geneUMatrix.getColumnDimension());
        for (n3 = 0; n3 < this.gene.getRowDimension(); ++n3) {
            for (n = 0; n < this.gene.getColumnDimension(); ++n) {
                this.gene.set(n3, n, (float)this.geneUMatrix.get(n3, n));
            }
        }
        this.expt = new FloatMatrix(this.exptUMatrix.getRowDimension(), this.exptUMatrix.getColumnDimension());
        for (n3 = 0; n3 < this.expt.getRowDimension(); ++n3) {
            for (n = 0; n < this.expt.getColumnDimension(); ++n) {
                this.expt.set(n3, n, (float)this.exptUMatrix.get(n3, n));
            }
        }
        FloatMatrix floatMatrix2 = new FloatMatrix(matrix2.getRowDimension(), 1);
        for (n = 0; n < matrix2.getRowDimension(); ++n) {
            floatMatrix2.set(n, 0, (float)matrix2.get(n, n));
        }
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addMatrix("gene", this.gene);
        algorithmData.addMatrix("expt", this.expt);
        algorithmData.addMatrix("lambdaValues", floatMatrix2);
        return algorithmData;
    }

    Vector getKNearestGenes(int n, int n2, FloatMatrix floatMatrix, Vector vector, Vector vector2) {
        float f;
        int n3;
        Vector<Integer> vector3 = new Vector<Integer>();
        Vector<Integer> vector4 = new Vector<Integer>();
        Vector<Float> vector5 = new Vector<Float>();
        for (int i = 0; i < vector.size(); ++i) {
            n3 = (Integer)vector.get(i);
            if (n == n3) continue;
            f = ExperimentUtil.geneEuclidianDistance(floatMatrix, null, n, n3, this.factor);
            vector5.add(new Float(f));
            vector3.add(new Integer(n3));
        }
        float[] fArray = new float[vector5.size()];
        for (n3 = 0; n3 < vector5.size(); ++n3) {
            fArray[n3] = f = ((Float)vector5.get(n3)).floatValue();
        }
        QSort qSort = new QSort(fArray);
        float[] fArray2 = qSort.getSorted();
        int[] nArray = qSort.getOrigIndx();
        for (int i = 0; i < n2; ++i) {
            int n4 = nArray[i];
            int n5 = (Integer)vector3.get(n4);
            vector4.add(new Integer(n5));
        }
        return vector4;
    }

    private float getExptWeightedMean(int n, int n2, Vector vector, FloatMatrix floatMatrix) {
        int n3;
        float f = 0.0f;
        int n4 = 0;
        float f2 = 0.0f;
        float[] fArray = new float[vector.size()];
        for (int i = 0; i < fArray.length; ++i) {
            n3 = (Integer)vector.get(i);
            if (!Float.isNaN(floatMatrix.A[n3][n2])) {
                float f3 = ExperimentUtil.geneEuclidianDistance(floatMatrix, null, n, n3, this.factor);
                if (f3 == 0.0f) {
                    f3 = Float.MIN_VALUE;
                }
                fArray[i] = 1.0f / f3;
                f2 += fArray[i] * floatMatrix.A[n3][n2];
                ++n4;
                continue;
            }
            fArray[i] = 0.0f;
        }
        float f4 = 0.0f;
        for (n3 = 0; n3 < fArray.length; ++n3) {
            f4 += fArray[n3];
        }
        f = f2 / f4;
        return f;
    }

    private float getMean(float[] fArray) {
        float f = 0.0f;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f += fArray[i];
            ++n;
        }
        if (n == 0) {
            n = 1;
        }
        return f /= (float)n;
    }

    private boolean hasAllExpts(int n, FloatMatrix floatMatrix, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = (Integer)vector.get(i);
            if (!Float.isNaN(floatMatrix.A[n][n2])) continue;
            return false;
        }
        return true;
    }

    private boolean belongsIn(Vector vector, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = (Integer)vector.get(i);
            if (n != n2) continue;
            return true;
        }
        return false;
    }
}

