/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.ArrayList;
import java.util.Random;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.mev.cluster.algorithm.impl.SOMMatrix;
import org.tigr.util.FloatMatrix;

public class SOM
extends AbstractAlgorithm {
    private static final int INDEX_X = 0;
    private static final int INDEX_Y = 1;
    private static final int WINNER_INFO_SIZE = 2;
    private boolean stop = false;
    private int function;
    private int dim_x;
    private int dim_y;
    private float factor;
    private boolean absolute;
    private String topology;
    private boolean somGenes;
    private int number_of_genes;
    private int number_of_samples;
    private FloatMatrix expMatrix;
    private float[][][] somCodes;
    private int validN;
    private int hcl_function;
    private boolean hcl_absolute;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        this.somGenes = algorithmParameters.getBoolean("som-cluster-genes", true);
        this.dim_x = algorithmParameters.getInt("dimension-x", 0);
        this.dim_y = algorithmParameters.getInt("dimension-y", 0);
        int n = algorithmParameters.getInt("iterations", 0);
        this.topology = algorithmParameters.getString("topology");
        boolean bl = this.topology != null ? this.topology.compareTo("rectangular") == 0 : true;
        boolean bl2 = algorithmParameters.getBoolean("is_neighborhood_bubble", true);
        boolean bl3 = algorithmParameters.getBoolean("is_random_vector", true);
        float f = algorithmParameters.getFloat("radius", 0.0f);
        float f2 = algorithmParameters.getFloat("alpha", 0.0f);
        boolean bl4 = algorithmParameters.getBoolean("hierarchical-tree", false);
        int n2 = algorithmParameters.getInt("method-linkage", 0);
        boolean bl5 = algorithmParameters.getBoolean("calculate-genes", false);
        boolean bl6 = algorithmParameters.getBoolean("calculate-experiments", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.hcl_function = algorithmParameters.getInt("hcl-distance-function", 4);
        this.hcl_absolute = algorithmParameters.getBoolean("hcl-distance-absolute", false);
        this.number_of_genes = this.expMatrix.getRowDimension();
        this.number_of_samples = this.expMatrix.getColumnDimension();
        this.somCodes = bl3 ? this.randomVectorInit() : this.randomGeneInit();
        int[] nArray = new int[2];
        float f3 = f;
        float f4 = f2;
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, 200, "Training...");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        algorithmEvent.setIntValue(0);
        int n3 = 0;
        long l = n / 200;
        for (int i = 0; i < n; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            if ((long)i % l == 0L) {
                algorithmEvent.setIntValue(algorithmEvent.getIntValue() + 1);
                this.fireValueChanged(algorithmEvent);
            }
            f3 = 1.0f + (f - 1.0f) * (float)(n - i) / (float)n;
            f4 = this.linearAlpha(i, n, f2);
            this.findWinnerEuclidean(nArray, n3);
            if (bl2) {
                this.bubbleAdapt(n3, nArray, f3, f4, bl);
            } else {
                this.gaussianAdapt(n3, nArray, f3, f4, bl);
            }
            if (++n3 < this.number_of_genes) continue;
            n3 = 0;
        }
        SOMMatrix sOMMatrix = new SOMMatrix(this.dim_x, this.dim_y, 0);
        FloatMatrix floatMatrix = new FloatMatrix(this.dim_x, this.dim_y);
        this.calculateClusters(sOMMatrix, floatMatrix);
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix2 = new FloatMatrix(this.dim_x * this.dim_y, this.number_of_samples);
        for (int i = 0; i < this.number_of_samples; ++i) {
            for (int j = 0; j < this.dim_x; ++j) {
                for (int k = 0; k < this.dim_y; ++k) {
                    floatMatrix2.set(j * this.dim_y + k, i, this.somCodes[j][k][i]);
                }
            }
        }
        algorithmData2.addMatrix("codes", floatMatrix2);
        FloatMatrix floatMatrix3 = new FloatMatrix(this.dim_x * this.dim_y, this.number_of_samples);
        FloatMatrix floatMatrix4 = new FloatMatrix(this.dim_x * this.dim_y, this.number_of_samples);
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < this.dim_x; ++i) {
            for (int j = 0; j < this.dim_y; ++j) {
                int[] nArray2 = this.getFeatures(sOMMatrix.getArrayList(i, j));
                int n4 = i * this.dim_y + j;
                this.fillMean(floatMatrix3.A[n4], nArray2);
                this.fillVariance(floatMatrix4.A[n4], floatMatrix3.A[n4], nArray2);
                Node node = new Node(nArray2);
                nodeList.addNode(node);
            }
        }
        if (bl4) {
            this.calculateHierarchicalTrees(cluster, n2, bl5, bl6);
        }
        algorithmData2.addCluster("cluster", cluster);
        algorithmData2.addMatrix("clusters_means", floatMatrix3);
        algorithmData2.addMatrix("clusters_variances", floatMatrix4);
        algorithmData2.addMatrix("u_matrix", floatMatrix);
        return algorithmData2;
    }

    private void calculateHierarchicalTrees(Cluster cluster, int n, boolean bl, boolean bl2) throws AlgorithmException {
        NodeList nodeList = cluster.getNodeList();
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, nodeList.getSize(), "Calculate Hierarchical Trees");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        for (int i = 0; i < nodeList.getSize(); ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            algorithmEvent.setIntValue(i);
            this.fireValueChanged(algorithmEvent);
            Node node = nodeList.getNode(i);
            node.setValues(this.calculateHierarchicalTree(node.getFeaturesIndexes(), n, bl, bl2));
        }
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.somGenes ? this.getSubExperiment(this.expMatrix, nArray) : this.getSubExperimentReducedCols(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        algorithmData2.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", (Object)algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", (Object)algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", (Object)algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", (Object)algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = floatMatrix.copy();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, floatMatrix2.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = floatMatrix2.A[nArray[i]];
        }
        floatMatrix3 = floatMatrix3.transpose();
        return floatMatrix3;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    public void abort() {
        this.stop = true;
    }

    private int[] getFeatures(ArrayList arrayList) {
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((Float)arrayList.get(i)).intValue();
        }
        return nArray;
    }

    private float[][][] randomGeneInit() {
        Random random = new Random(System.currentTimeMillis());
        float[][][] fArray = new float[this.dim_x][this.dim_y][this.number_of_samples];
        for (int i = 0; i < this.dim_y; ++i) {
            for (int j = 0; j < this.dim_x; ++j) {
                int n = (int)(random.nextFloat() * (float)this.number_of_genes);
                for (int k = 0; k < this.number_of_samples; ++k) {
                    fArray[j][i][k] = this.expMatrix.get(n, k);
                }
            }
        }
        return fArray;
    }

    private float[][][] randomVectorInit() {
        int n;
        int n2;
        float[][][] fArray = new float[this.dim_x][this.dim_y][this.number_of_samples];
        float[] fArray2 = new float[this.number_of_samples];
        float[] fArray3 = new float[this.number_of_samples];
        for (n2 = 0; n2 < this.number_of_samples; ++n2) {
            fArray3[n2] = Float.MAX_VALUE;
            fArray2[n2] = Float.MIN_VALUE;
        }
        for (n2 = 0; n2 < this.number_of_genes; ++n2) {
            for (n = 0; n < this.number_of_samples; ++n) {
                float f = this.expMatrix.get(n2, n);
                if (Float.isNaN(f)) continue;
                if (fArray2[n] < f) {
                    fArray2[n] = f;
                }
                if (!(fArray3[n] > f)) continue;
                fArray3[n] = f;
            }
        }
        Random random = new Random(System.currentTimeMillis());
        for (n2 = 0; n2 < this.dim_x; ++n2) {
            for (n = 0; n < this.dim_y; ++n) {
                for (int i = 0; i < this.number_of_samples; ++i) {
                    float f;
                    fArray[n2][n][i] = f = fArray3[i] + (fArray2[i] - fArray3[i]) * random.nextFloat();
                }
            }
        }
        return fArray;
    }

    private final float findWinnerEuclidean(int[] nArray, int n) {
        nArray[0] = -1;
        nArray[1] = -1;
        float f = -1.0f;
        if (this.number_of_samples == 1) {
            return f;
        }
        double d = Double.MAX_VALUE;
        FloatMatrix floatMatrix = new FloatMatrix(1, this.number_of_samples);
        for (int i = 0; i < this.dim_y; ++i) {
            for (int j = 0; j < this.dim_x; ++j) {
                for (int k = 0; k < this.number_of_samples; ++k) {
                    floatMatrix.set(0, k, this.somCodes[j][i][k]);
                }
                double d2 = ExperimentUtil.geneDistance(this.expMatrix, floatMatrix, n, 0, this.function, this.factor, this.absolute);
                if (!(d2 <= d)) continue;
                nArray[0] = j;
                nArray[1] = i;
                d = d2;
                f = (float)d2;
            }
        }
        return f;
    }

    private void bubbleAdapt(int n, int[] nArray, float f, float f2, boolean bl) {
        long l = 0L;
        for (int i = 0; i < this.dim_y; ++i) {
            for (int j = 0; j < this.dim_x; ++j) {
                if (bl) {
                    if (!(this.rectangularDistance(nArray, j, i) <= f)) continue;
                    this.adaptVector(n, j, i, f2);
                    continue;
                }
                if (!(this.hexagonalDistance(nArray, j, i) <= f)) continue;
                this.adaptVector(n, j, i, f2);
            }
        }
    }

    private void gaussianAdapt(int n, int[] nArray, float f, float f2, boolean bl) {
        long l = 0L;
        for (int i = 0; i < this.dim_y; ++i) {
            for (int j = 0; j < this.dim_x; ++j) {
                float f3 = bl ? this.rectangularDistance(nArray, j, i) : this.hexagonalDistance(nArray, j, i);
                float f4 = f2 * (float)Math.exp((float)((double)(-f3 * f3) / (2.0 * (double)f * (double)f)));
                this.adaptVector(n, j, i, f4);
            }
        }
    }

    private float rectangularDistance(int[] nArray, int n, int n2) {
        float f = nArray[0] - n;
        float f2 = f * f;
        f = nArray[1] - n2;
        f2 += f * f;
        f2 = (float)Math.sqrt(f2);
        return f2;
    }

    private float hexagonalDistance(int[] nArray, int n, int n2) {
        float f = nArray[0] - n;
        if ((nArray[1] - n2) % 2 != 0) {
            f = nArray[1] % 2 == 0 ? (float)((double)f - 0.5) : (float)((double)f + 0.5);
        }
        float f2 = f * f;
        f = nArray[1] - n2;
        f2 = (float)((double)f2 + 0.75 * (double)f * (double)f);
        f2 = (float)Math.sqrt(f2);
        return f2;
    }

    private void adaptVector(int n, int n2, int n3, float f) {
        for (int i = 0; i < this.number_of_samples; ++i) {
            if (Float.isNaN(this.expMatrix.get(n, i))) continue;
            this.somCodes[n2][n3][i] = this.somCodes[n2][n3][i] + f * (this.expMatrix.get(n, i) - this.somCodes[n2][n3][i]);
        }
    }

    private float linearAlpha(long l, long l2, float f) {
        return f * (float)(l2 - l) / (float)l2;
    }

    private void calculateClusters(SOMMatrix sOMMatrix, FloatMatrix floatMatrix) throws AlgorithmException {
        int n;
        int n2;
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.number_of_genes, "Creation of the clusters...");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        SOMMatrix sOMMatrix2 = new SOMMatrix(this.dim_x, this.dim_y, 0);
        for (int i = 0; i < this.dim_y; ++i) {
            for (int j = 0; j < this.dim_x; ++j) {
                floatMatrix.set(j, i, 0.0f);
            }
        }
        float f = 0.0f;
        int[] nArray = new int[2];
        for (n2 = 0; n2 < this.number_of_genes; ++n2) {
            if (this.stop) {
                throw new AbortException();
            }
            float f2 = this.findWinnerEuclidean(nArray, n2);
            if (nArray[0] != -1 && nArray[1] != -1) {
                f = Math.max(f2, f);
                if (f2 > floatMatrix.get(nArray[0], nArray[1])) {
                    floatMatrix.set(nArray[0], nArray[1], f2);
                }
                int n3 = 0;
                for (n = 0; n < sOMMatrix2.getDimension(nArray[0], nArray[1]) && !(f2 < sOMMatrix2.getValue(nArray[0], nArray[1], n)); ++n) {
                    ++n3;
                }
                sOMMatrix2.insertValue(nArray[0], nArray[1], n3, f2);
                sOMMatrix.insertValue(nArray[0], nArray[1], n3, n2);
            }
            algorithmEvent.setIntValue(n2);
            this.fireValueChanged(algorithmEvent);
        }
        for (n2 = 0; n2 < this.dim_y; ++n2) {
            for (n = 0; n < this.dim_x; ++n) {
                floatMatrix.set(n, n2, floatMatrix.get(n, n2) / f);
            }
        }
    }

    private void fillMean(float[] fArray, int[] nArray) {
        int n = nArray.length;
        this.validN = 0;
        for (int i = 0; i < this.number_of_samples; ++i) {
            float f = 0.0f;
            this.validN = 0;
            for (int j = 0; j < n; ++j) {
                float f2 = this.expMatrix.get(nArray[j], i);
                if (Float.isNaN(f2)) continue;
                f += f2;
                ++this.validN;
            }
            fArray[i] = f / (float)this.validN;
        }
    }

    private void fillVariance(float[] fArray, float[] fArray2, int[] nArray) {
        for (int i = 0; i < this.number_of_samples; ++i) {
            fArray[i] = this.getSampleVariance(nArray, i, fArray2[i]);
        }
    }

    private float getSampleNormalizedSum(int[] nArray, int n, float f) {
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < nArray.length; ++i) {
            float f3 = this.expMatrix.get(nArray[i], n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(int[] nArray, int n, float f) {
        if (this.validN > 1) {
            return (float)Math.sqrt(this.getSampleNormalizedSum(nArray, n, f) / (float)(this.validN - 1));
        }
        return 0.0f;
    }
}

