/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.awt.Dimension;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.mev.cluster.algorithm.impl.SOTACell;
import org.tigr.util.FloatMatrix;

public class SOTA
extends AbstractAlgorithm {
    private AlgorithmData inData;
    private FloatMatrix dataMatrix;
    private int numberOfGenes;
    private int numberOfSamples;
    public int cycleNum;
    private int numberOfClusters;
    private int utilCounter;
    private float initDivSum;
    private SOTACell root;
    private SOTACell head;
    private SOTACell mostDiverseCell;
    private SOTACell mostVariableCell;
    public SOTACell[] myNucleus;
    private double treeDiversity;
    private Vector cycleDiversity;
    Cluster clusters;
    boolean sotaGenes = true;
    int maxNumEpochs;
    int maxNumCycles;
    float epochCriteria;
    float endCriteria;
    float migW;
    float migP;
    float migS;
    int neighborhoodLevel;
    boolean useClusterVariance;
    float pValue;
    boolean runToMaxCycles;
    boolean stop = false;
    int function;
    float factor;
    float myFactor;
    boolean absolute;
    boolean calcClusterHCL;
    boolean calcFullTreeHCL;
    boolean calculate_genes;
    boolean calculate_experiments;
    int method;
    private int hcl_function;
    private boolean hcl_absolute;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        int n;
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.sotaGenes = algorithmParameters.getBoolean("sota-cluster-genes", true);
        this.maxNumEpochs = algorithmParameters.getInt("max-epochs-per-cycle", 1000);
        this.maxNumCycles = algorithmParameters.getInt("max-number-of-cycles", 10);
        this.epochCriteria = algorithmParameters.getFloat("epoch-improvement-cutoff");
        this.endCriteria = algorithmParameters.getFloat("end-training-diversity");
        this.runToMaxCycles = algorithmParameters.getBoolean("run-to-max-cycles");
        this.useClusterVariance = algorithmParameters.getBoolean("use-cluster-variance", false);
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", true);
        this.calcClusterHCL = algorithmParameters.getBoolean("calcClusterHCL", false);
        this.calculate_genes = algorithmParameters.getBoolean("calculate-genes", false);
        this.calculate_experiments = algorithmParameters.getBoolean("calculate-experiments", false);
        this.calcFullTreeHCL = algorithmParameters.getBoolean("calcFullTreeHCL", false);
        this.method = algorithmParameters.getInt("method-linkage", 0);
        this.pValue = algorithmParameters.getFloat("pValue", 0.05f);
        this.migW = algorithmParameters.getFloat("mig_w", 0.01f);
        this.migP = algorithmParameters.getFloat("mig_p", 0.005f);
        this.migS = algorithmParameters.getFloat("mig_s", 0.001f);
        this.neighborhoodLevel = algorithmParameters.getInt("neighborhood-level", 5);
        this.hcl_function = algorithmParameters.getInt("hcl-distance-function", 4);
        this.hcl_absolute = algorithmParameters.getBoolean("hcl-distance-absolute", false);
        this.inData = algorithmData;
        this.myFactor = this.function == 1 || this.function == 6 || this.function == 7 || this.function == 2 || this.function == 3 || this.function == 5 || this.function == 9 || this.function == 10 ? -1.0f : 1.0f;
        this.factor = 1.0f;
        this.inData.addParam("factor", String.valueOf(this.myFactor));
        this.endCriteria *= this.myFactor;
        this.treeDiversity = Double.POSITIVE_INFINITY;
        this.dataMatrix = algorithmData.getMatrix("experiment");
        this.numberOfGenes = this.dataMatrix.getRowDimension();
        this.numberOfSamples = this.dataMatrix.getColumnDimension();
        this.myNucleus = new SOTACell[this.numberOfGenes];
        this.cycleDiversity = new Vector();
        if (this.maxNumCycles >= this.numberOfGenes) {
            this.maxNumCycles = this.numberOfGenes - 1;
        }
        if (this.useClusterVariance) {
            this.endCriteria = this.resampleAndGetNewCutoff(this.dataMatrix, this.pValue);
        }
        this.root = new SOTACell(this.numberOfSamples, this.dataMatrix);
        this.root.right = new SOTACell(this.numberOfSamples, this.dataMatrix);
        this.root.left = new SOTACell(this.numberOfSamples, this.dataMatrix);
        this.numberOfClusters = 2;
        this.root.left.parent = this.root;
        this.root.right.parent = this.root;
        this.head = this.root.left;
        this.root.left.succ = this.root.right;
        this.root.right.pred = this.root.left;
        int[] nArray = new int[this.numberOfSamples];
        for (n = 0; n < this.numberOfSamples; ++n) {
            nArray[n] = 0;
        }
        for (n = 0; n < this.numberOfSamples; ++n) {
            this.root.centroidGene.set(0, n, 0.0f);
        }
        for (n = 0; n < this.numberOfGenes; ++n) {
            this.root.members.add(new Integer(n));
            this.myNucleus[n] = this.root;
            for (int i = 0; i < this.numberOfSamples; ++i) {
                if (Float.isNaN(this.dataMatrix.get(n, i))) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 1;
                this.root.centroidGene.set(0, i, this.root.centroidGene.get(0, i) + this.dataMatrix.get(n, i));
            }
        }
        this.mostDiverseCell = this.root;
        this.mostVariableCell = this.root;
        for (n = 0; n < this.numberOfSamples; ++n) {
            this.root.centroidGene.set(0, n, this.root.centroidGene.get(0, n) / (float)nArray[n]);
            this.root.left.centroidGene.set(0, n, this.root.centroidGene.get(0, n));
            this.root.right.centroidGene.set(0, n, this.root.centroidGene.get(0, n));
        }
        this.initDivSum = this.getNodeDiversitySum(this.root);
        this.cycleDiversity.add(new Float(this.initDivSum));
        this.root.cellDiversity = this.initDivSum / (float)this.numberOfGenes;
        if (this.useClusterVariance) {
            this.root.cellVariance = this.getNodeVariance(this.root);
        }
        if (this.runToMaxCycles) {
            this.growSOTUnrestricted();
        } else {
            this.growSOT();
        }
        if (this.calcFullTreeHCL) {
            this.calcFullTreeHCL();
        }
        if (this.calcClusterHCL) {
            this.calculateClusterHCL();
        }
        return this.inData;
    }

    private float resampleAndGetNewCutoff(FloatMatrix floatMatrix, float f) {
        int n;
        int n2;
        FloatMatrix floatMatrix2 = this.randomizeMatrix(floatMatrix);
        int n3 = floatMatrix.getRowDimension();
        int n4 = floatMatrix.getColumnDimension();
        int n5 = 500;
        int n6 = 0;
        float[][] fArray = new float[n3][n3];
        for (int i = 0; i < n3 - 1; ++i) {
            for (int j = 0; j < i; ++j) {
                fArray[i][j] = ExperimentUtil.geneDistance(floatMatrix2, null, i, j, this.function, this.factor, this.absolute);
            }
        }
        float[] fArray2 = this.getMinAndMax(fArray, n3);
        float f2 = fArray2[0];
        float f3 = fArray2[1];
        float[] fArray3 = new float[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            fArray3[n2] = 0.0f;
        }
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            for (n = 0; n < n2; ++n) {
                int n7 = (int)((float)(n5 - 1) * (fArray[n2][n] - f2) / (f3 - f2));
                fArray3[n7] = fArray3[n7] + 1.0f;
                ++n6;
            }
        }
        n2 = 0;
        while (n2 < n5) {
            int n8 = n2++;
            fArray3[n8] = fArray3[n8] / (float)n6;
        }
        float f4 = 0.0f;
        n = 0;
        while (f4 < f) {
            f4 += fArray3[n];
            ++n;
        }
        return ((float)n - 0.5f) / (float)n5 * (f3 - f2) + f2;
    }

    private float[] getMinAndMax(float[][] fArray, int n) {
        float[] fArray2 = new float[2];
        float f = Float.NEGATIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < i; ++j) {
                float f3 = fArray[i][j];
                if (f3 > f) {
                    f = f3;
                }
                if (!(f3 < f2)) continue;
                f2 = f3;
            }
        }
        fArray2[0] = f2;
        fArray2[1] = f;
        return fArray2;
    }

    private FloatMatrix randomizeMatrix(FloatMatrix floatMatrix) {
        FloatMatrix floatMatrix2 = floatMatrix.copy();
        int n = floatMatrix2.getRowDimension();
        int n2 = floatMatrix2.getColumnDimension();
        int n3 = n2 - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = n2 - 1; j > 0; --j) {
                int n4 = (int)(Math.random() * (double)j);
                float f = floatMatrix2.get(i, j);
                floatMatrix2.set(i, j, floatMatrix2.get(i, n4));
                floatMatrix2.set(i, n4, f);
                --n3;
            }
        }
        return floatMatrix2;
    }

    private void calcFullTreeHCL() throws AlgorithmException {
        AlgorithmEvent algorithmEvent = null;
        algorithmEvent = new AlgorithmEvent((Object)this, 1, 1, "Calculate Hierarchical Tree, Clustering Experiments");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setIntValue(0);
        algorithmEvent.setId(2);
        this.fireValueChanged(algorithmEvent);
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        int[] nArray = new int[this.numberOfGenes];
        for (int i = 0; i < this.numberOfGenes; ++i) {
            nArray[i] = i;
        }
        int[] nArray2 = new int[this.numberOfSamples];
        for (int i = 0; i < this.numberOfSamples; ++i) {
            nArray2[i] = i;
        }
        if (this.stop) {
            throw new AbortException();
        }
        Node node = new Node(nArray2);
        nodeList.addNode(node);
        node.setValues(this.calculateHierarchicalTree(nArray, this.method, false, true));
        algorithmEvent.setIntValue(1);
        this.fireValueChanged(algorithmEvent);
        if (cluster != null) {
            this.inData.addCluster("full-tree-sample-HCL", cluster);
        }
    }

    private void calculateClusterHCL() throws AlgorithmException {
        AlgorithmEvent algorithmEvent = null;
        algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numberOfClusters, "Calculate Hierarchical Trees SOTA Cluster Members");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setIntValue(0);
        algorithmEvent.setId(2);
        this.fireValueChanged(algorithmEvent);
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        NodeList nodeList2 = this.clusters.getNodeList();
        for (int i = 0; i < this.numberOfClusters; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            Node node = nodeList2.getNode(i);
            int[] nArray = node.getProbesIndexes();
            Node node2 = new Node(nArray);
            nodeList.addNode(node2);
            node2.setValues(this.calculateHierarchicalTree(nArray, this.method, this.calculate_genes, this.calculate_experiments));
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
        }
        if (cluster != null) {
            this.inData.addCluster("hcl-result-clusters", cluster);
        }
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.sotaGenes ? this.getSubExperiment(this.dataMatrix, nArray) : this.getSubExperimentReducedCols(this.dataMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        algorithmData2.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = floatMatrix.copy();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, floatMatrix2.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = floatMatrix2.A[nArray[i]];
        }
        floatMatrix3 = floatMatrix3.transpose();
        return floatMatrix3;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", (Object)algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", (Object)algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", (Object)algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", (Object)algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    public SOTACell getRoot() {
        return this.root;
    }

    public int getPopulation(SOTACell sOTACell) {
        this.utilCounter = 0;
        this.getPop(sOTACell);
        return this.utilCounter;
    }

    private void getPop(SOTACell sOTACell) {
        if (sOTACell != null) {
            if (sOTACell.left == null && sOTACell.right == null) {
                ++this.utilCounter;
            }
            this.getPop(sOTACell.left);
            this.getPop(sOTACell.right);
        }
    }

    private void growSOT() {
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.maxNumCycles);
        this.fireValueChanged(algorithmEvent);
        AlgorithmEvent algorithmEvent2 = new AlgorithmEvent((Object)this, 1, this.maxNumCycles, "Growing Tree");
        this.fireValueChanged(algorithmEvent2);
        algorithmEvent2.setIntValue(0);
        algorithmEvent2.setId(2);
        this.fireValueChanged(algorithmEvent2);
        boolean bl = false;
        if (!this.useClusterVariance && this.mostDiverseCell.cellDiversity < (double)this.endCriteria) {
            bl = true;
        } else if (this.useClusterVariance && this.mostVariableCell.cellVariance < (double)this.endCriteria) {
            bl = true;
        }
        this.cycleNum = 0;
        while (this.cycleNum < this.maxNumCycles && !bl) {
            this.runCycle(this.maxNumEpochs, this.epochCriteria);
            this.setDiversities();
            this.cycleDiversity.add(new Float(this.treeDiversity));
            if (!this.useClusterVariance) {
                if (this.mostDiverseCell.cellDiversity > (double)this.endCriteria && this.cycleNum < this.maxNumCycles - 1) {
                    this.divideCell(this.mostDiverseCell);
                } else {
                    bl = true;
                }
            } else if (this.mostVariableCell.cellVariance > (double)this.endCriteria && this.cycleNum < this.maxNumCycles - 1) {
                this.divideCell(this.mostVariableCell);
            } else {
                bl = true;
            }
            algorithmEvent2.setId(2);
            algorithmEvent2.setIntValue(this.cycleNum + 1);
            this.fireValueChanged(algorithmEvent2);
            ++this.cycleNum;
        }
        this.trainLeaves(this.maxNumEpochs, this.epochCriteria);
        this.getResults();
    }

    private void growSOTUnrestricted() {
        boolean bl = false;
        this.cycleNum = 0;
        while (this.cycleNum < this.maxNumCycles && !bl) {
            this.runCycle(this.maxNumEpochs, this.epochCriteria);
            this.setDiversities();
            this.cycleDiversity.add(new Float(this.treeDiversity));
            if (this.cycleNum < this.maxNumCycles - 1) {
                this.divideCell(this.mostDiverseCell);
            } else {
                bl = true;
            }
            ++this.cycleNum;
        }
        this.trainLeaves(this.maxNumEpochs, this.epochCriteria);
        this.getResults();
    }

    public int getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    private int[] getGenesPerCluster() {
        SOTACell sOTACell = this.head;
        int n = 0;
        int n2 = 0;
        while (sOTACell != null) {
            ++n;
            sOTACell = sOTACell.succ;
        }
        int[] nArray = new int[n];
        sOTACell = this.head;
        while (sOTACell != null) {
            nArray[n2] = sOTACell.members.size();
            ++n2;
            sOTACell = sOTACell.succ;
        }
        return nArray;
    }

    public int getFunction() {
        return this.function;
    }

    public boolean getAbsolute() {
        return this.absolute;
    }

    public float getFactor() {
        return this.myFactor;
    }

    private void runCycle(int n, double d) {
        boolean bl = false;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = this.treeDiversity;
        double d5 = Double.POSITIVE_INFINITY;
        SOTACell sOTACell = !this.useClusterVariance ? this.mostDiverseCell : this.mostVariableCell;
        boolean bl2 = false;
        for (int i = 0; i < n && !bl2; ++i) {
            d4 = this.treeDiversity;
            Dimension dimension = this.runNodeEpoch(sOTACell);
            d2 = d3;
            d3 = this.getInputError(sOTACell);
            d5 = d2 != 0.0 ? Math.abs((d3 - d2) / d2) : 0.0;
            if (!(d5 < d) || !(d5 >= 0.0) || dimension.getHeight() == 0.0 || dimension.getWidth() == 0.0) continue;
            bl2 = true;
        }
        this.assignGenesToCells(sOTACell);
    }

    private void assignGenesToCells(SOTACell sOTACell) {
        int n = sOTACell.members.size();
        SOTACell sOTACell2 = null;
        for (int i = 0; i < n; ++i) {
            int n2 = (Integer)sOTACell.members.elementAt(i);
            sOTACell2 = this.findMyCellInSubTree(sOTACell, n2, this.neighborhoodLevel);
        }
    }

    private void getResults() {
        float f;
        SOTACell sOTACell = this.head;
        int n = 0;
        FloatMatrix floatMatrix = new FloatMatrix(this.numberOfClusters, this.numberOfSamples);
        FloatMatrix floatMatrix2 = new FloatMatrix(this.numberOfClusters, this.numberOfSamples);
        int[] nArray = new int[this.numberOfClusters];
        FloatMatrix floatMatrix3 = new FloatMatrix(this.numberOfClusters, 1);
        int n2 = this.cycleDiversity.size();
        FloatMatrix floatMatrix4 = new FloatMatrix(n2, 1);
        int[] nArray2 = new int[this.numberOfClusters];
        this.clusters = new Cluster();
        NodeList nodeList = this.clusters.getNodeList();
        while (sOTACell.succ != null) {
            sOTACell = sOTACell.succ;
        }
        while (n <= this.numberOfClusters && sOTACell != null) {
            int n3;
            int n4;
            for (n4 = 0; n4 < this.numberOfSamples; ++n4) {
                floatMatrix.set(n, n4, sOTACell.centroidGene.get(0, n4));
                floatMatrix2.set(n, n4, sOTACell.getColumnVar(n4));
            }
            nArray[n] = n3 = sOTACell.members.size();
            floatMatrix3.set(n, 0, (float)sOTACell.cellDiversity * this.myFactor);
            nArray2[n] = n;
            int[] nArray3 = new int[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                nArray3[n4] = (Integer)sOTACell.members.elementAt(n4);
            }
            Node node = new Node();
            node.setProbesIndexes(nArray3);
            nodeList.addNode(node);
            ++n;
            sOTACell = sOTACell.pred;
        }
        if (this.myFactor == 1.0f) {
            f = ((Float)this.cycleDiversity.elementAt(0)).floatValue();
            for (int i = 0; i < n2; ++i) {
                floatMatrix4.set(i, 0, ((Float)this.cycleDiversity.elementAt(i)).floatValue() / f);
            }
        } else {
            f = (float)this.numberOfGenes * this.myFactor;
            float f2 = ((Float)this.cycleDiversity.elementAt(0)).floatValue() + Math.abs(f);
            for (int i = 0; i < n2; ++i) {
                floatMatrix4.set(i, 0, (((Float)this.cycleDiversity.elementAt(i)).floatValue() + Math.abs(f)) / f2);
            }
        }
        this.inData.addParam("cycles", String.valueOf(this.numberOfClusters));
        this.inData.addCluster("cluster", this.clusters);
        this.inData.addMatrix("centroid-matrix", floatMatrix);
        this.inData.addMatrix("cluster-variances", floatMatrix2);
        this.inData.addMatrix("cluster-diversity", floatMatrix3);
        this.inData.addMatrix("cycle-diversity", floatMatrix4);
        this.inData.addIntArray("cluster-population", nArray);
        float[] fArray = new float[this.numberOfClusters * 2];
        int[] nArray4 = new int[this.numberOfClusters * 2];
        int[] nArray5 = new int[fArray.length * 2];
        int[] nArray6 = new int[fArray.length * 2];
        this.initializeReturnValues(fArray, nArray4, nArray5, nArray6);
        this.utilCounter = 0;
        this.loadReturnValues(this.root, 0, fArray, nArray4, nArray5, nArray6);
        this.inData.addMatrix("node-heights", new FloatMatrix(fArray, fArray.length));
        this.inData.addIntArray("left-child", nArray5);
        this.inData.addIntArray("right-child", nArray6);
        this.inData.addIntArray("node-population", nArray4);
        if (this.useClusterVariance) {
            this.inData.addParam("computed-var-cutoff", String.valueOf(this.endCriteria));
        }
    }

    private void initializeReturnValues(float[] fArray, int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = -1.0f;
            nArray3[i] = -1;
            nArray2[i] = -1;
            nArray[i] = -1;
        }
        for (int i = i; i < nArray2.length; ++i) {
            nArray3[i] = -1;
            nArray2[i] = -1;
        }
    }

    private void loadReturnValues(SOTACell sOTACell, int n, float[] fArray, int[] nArray, int[] nArray2, int[] nArray3) {
        nArray[n] = sOTACell.members.size();
        fArray[n] = sOTACell == this.root ? 0.0f : ExperimentUtil.geneDistance(sOTACell.centroidGene, sOTACell.parent.centroidGene, 0, 0, this.function, this.factor, this.absolute);
        if (sOTACell.left != null) {
            nArray2[n] = this.utilCounter + 1;
            ++this.utilCounter;
            this.loadReturnValues(sOTACell.left, this.utilCounter, fArray, nArray, nArray2, nArray3);
            nArray3[n] = this.utilCounter + 1;
            ++this.utilCounter;
            this.loadReturnValues(sOTACell.right, this.utilCounter, fArray, nArray, nArray2, nArray3);
        }
    }

    private double getInputError(SOTACell sOTACell) {
        int n = sOTACell.members.size();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2;
            int n2 = (Integer)sOTACell.members.elementAt(i);
            double d3 = ExperimentUtil.geneDistance(this.dataMatrix, sOTACell.left.centroidGene, n2, 0, this.function, this.factor, this.absolute);
            if (d3 <= (d2 = (double)ExperimentUtil.geneDistance(this.dataMatrix, sOTACell.right.centroidGene, n2, 0, this.function, this.factor, this.absolute))) {
                d += d3;
                continue;
            }
            d += d2;
        }
        return d / (double)n;
    }

    private Dimension runNodeEpoch(SOTACell sOTACell) {
        SOTACell sOTACell2 = null;
        SOTACell sOTACell3 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < sOTACell.members.size(); ++i) {
            n3 = (Integer)sOTACell.members.elementAt(i);
            sOTACell2 = this.findMyDaughterCell(sOTACell, n3);
            if (sOTACell2 == sOTACell.left) {
                ++n2;
            } else {
                ++n;
            }
            sOTACell2.migrateCentroid(n3, this.migW);
            sOTACell3 = this.findSister(sOTACell2);
            if (sOTACell3.left != null || sOTACell3.right != null) continue;
            sOTACell2.parent.migrateCentroid(n3, this.migP);
            sOTACell3.migrateCentroid(n3, this.migS);
        }
        return new Dimension(n2, n);
    }

    private SOTACell findMyDaughterCell(SOTACell sOTACell, int n) {
        float f;
        float f2 = ExperimentUtil.geneDistance(this.dataMatrix, sOTACell.left.centroidGene, n, 0, this.function, this.factor, this.absolute);
        if (f2 <= (f = ExperimentUtil.geneDistance(this.dataMatrix, sOTACell.right.centroidGene, n, 0, this.function, this.factor, this.absolute))) {
            return sOTACell.left;
        }
        return sOTACell.right;
    }

    private void setDiversities() {
        SOTACell sOTACell = this.head;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = -1.0;
        double d5 = -1.0;
        int n = 0;
        double d6 = 0.0;
        this.mostDiverseCell = this.head;
        this.mostVariableCell = this.head;
        while (sOTACell != null) {
            int n2;
            ++n;
            d = 0.0;
            for (n2 = 0; n2 < sOTACell.members.size(); ++n2) {
                d += (double)ExperimentUtil.geneDistance(this.dataMatrix, sOTACell.centroidGene, (Integer)sOTACell.members.elementAt(n2), 0, this.function, this.factor, this.absolute);
            }
            sOTACell.cellDiversity = d / (double)sOTACell.members.size();
            if (sOTACell.cellDiversity > d4 && sOTACell.members.size() > 1) {
                d4 = sOTACell.cellDiversity;
                this.mostDiverseCell = sOTACell;
            }
            d3 += d;
            if (this.useClusterVariance) {
                d2 = 0.0;
                d6 = 0.0;
                if (sOTACell.changedMembership) {
                    for (n2 = 0; n2 < sOTACell.members.size(); ++n2) {
                        for (int i = 0; i < sOTACell.members.size(); ++i) {
                            d6 = ExperimentUtil.geneDistance(this.dataMatrix, null, (Integer)sOTACell.members.elementAt(n2), (Integer)sOTACell.members.elementAt(i), this.function, this.factor, this.absolute);
                            if (!(d6 > d2)) continue;
                            d2 = d6;
                        }
                    }
                    sOTACell.cellVariance = d2;
                } else {
                    d2 = sOTACell.cellVariance;
                }
                if (d2 > d5 && sOTACell.members.size() > 1) {
                    d5 = d2;
                    this.mostVariableCell = sOTACell;
                }
            }
            sOTACell.changedMembership = false;
            sOTACell = sOTACell.succ;
        }
        this.treeDiversity = d3;
    }

    private float getNodeDiversitySum(SOTACell sOTACell) {
        float f = 0.0f;
        int n = sOTACell.members.size();
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            int n2 = (Integer)sOTACell.members.elementAt(i);
            float f3 = ExperimentUtil.geneDistance(this.dataMatrix, sOTACell.centroidGene, n2, 0, this.function, this.factor, this.absolute);
            if (Float.isNaN(f3)) continue;
            f2 += f3;
        }
        return f2;
    }

    private float getNodeDiversity(SOTACell sOTACell) {
        float f = 0.0f;
        int n = sOTACell.members.size();
        float f2 = 0.0f;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = (Integer)sOTACell.members.elementAt(i);
            float f3 = ExperimentUtil.geneDistance(this.dataMatrix, sOTACell.centroidGene, n3, 0, this.function, this.factor, this.absolute);
            if (Float.isNaN(f3)) continue;
            f2 += f3;
            ++n2;
        }
        return f2 / (float)n2;
    }

    private float getNodeVariance(SOTACell sOTACell) {
        float f = 0.0f;
        int n = sOTACell.members.size();
        float f2 = 0.0f;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int n2;
                int n3 = (Integer)sOTACell.members.elementAt(i);
                float f3 = ExperimentUtil.geneDistance(this.dataMatrix, null, n3, n2 = ((Integer)sOTACell.members.elementAt(j)).intValue(), this.function, this.factor, this.absolute);
                if (Float.isNaN(f3) || !(f3 > f2)) continue;
                f2 = f3;
            }
        }
        return f2;
    }

    private void trainLeaves(int n, double d) {
        double d2 = this.treeDiversity;
        double d3 = Double.POSITIVE_INFINITY;
        SOTACell sOTACell = this.head;
        while (sOTACell != null) {
            d3 = Double.POSITIVE_INFINITY;
            for (int i = 0; i < n && d3 > d; ++i) {
                d2 = this.getNodeDiversity(sOTACell);
                this.runLeafEpoch(sOTACell);
                d3 = Math.abs(((double)this.getNodeDiversity(sOTACell) - d2) / d2);
            }
            sOTACell = sOTACell.succ;
        }
        this.setDiversities();
    }

    private void runLeafEpoch(SOTACell sOTACell) {
        Object var2_2 = null;
        Object var3_3 = null;
        int n = 0;
        for (int i = 0; i < sOTACell.members.size(); ++i) {
            n = (Integer)sOTACell.members.elementAt(i);
            this.myNucleus[n].migrateCentroid(n, this.migW);
        }
    }

    private SOTACell findMyCellInSubTree(SOTACell sOTACell, int n, int n2) {
        SOTACell sOTACell2 = sOTACell;
        SOTACell sOTACell3 = sOTACell;
        for (int i = 0; sOTACell2.parent != null && i < n2; ++i) {
            sOTACell2 = sOTACell2.parent;
        }
        Vector vector = new Vector();
        this.getCellsBelow(vector, sOTACell2);
        float f = Float.POSITIVE_INFINITY;
        for (int i = 0; i < vector.size(); ++i) {
            sOTACell2 = (SOTACell)vector.elementAt(i);
            float f2 = ExperimentUtil.geneDistance(this.dataMatrix, sOTACell2.centroidGene, n, 0, this.function, this.factor, this.absolute);
            if (!(f2 < f)) continue;
            f = f2;
            sOTACell3 = sOTACell2;
        }
        if (this.myNucleus[n] != sOTACell3) {
            this.myNucleus[n] = sOTACell3;
            sOTACell3.addMember(n);
        }
        return sOTACell3;
    }

    private void getCellsBelow(Vector vector, SOTACell sOTACell) {
        if (sOTACell == null) {
            return;
        }
        if (sOTACell.left == null && sOTACell.right == null) {
            vector.add(sOTACell);
        } else {
            this.getCellsBelow(vector, sOTACell.right);
            this.getCellsBelow(vector, sOTACell.left);
        }
    }

    private SOTACell findMyCell(int n) {
        SOTACell sOTACell = this.head;
        SOTACell sOTACell2 = this.head;
        double d = Double.POSITIVE_INFINITY;
        double d2 = 0.0;
        while (sOTACell != null) {
            d2 = ExperimentUtil.geneDistance(this.dataMatrix, sOTACell.centroidGene, n, 0, this.function, this.factor, this.absolute);
            if (d2 <= d) {
                d = d2;
                sOTACell2 = sOTACell;
            }
            sOTACell = sOTACell.succ;
        }
        if (this.myNucleus[n] != sOTACell2) {
            this.myNucleus[n] = sOTACell2;
            sOTACell2.addMember(n);
        }
        return sOTACell2;
    }

    private SOTACell findSister(SOTACell sOTACell) {
        if (sOTACell != null) {
            if (sOTACell.parent.left == sOTACell) {
                return sOTACell.parent.right;
            }
            return sOTACell.parent.left;
        }
        return null;
    }

    private void divideCell(SOTACell sOTACell) {
        sOTACell.left = new SOTACell(this.numberOfSamples, this.dataMatrix);
        sOTACell.right = new SOTACell(this.numberOfSamples, this.dataMatrix);
        ++this.numberOfClusters;
        sOTACell.left.parent = sOTACell;
        sOTACell.right.parent = sOTACell;
        sOTACell.right.pred = sOTACell.left;
        sOTACell.left.succ = sOTACell.right;
        if (sOTACell.pred != null) {
            sOTACell.left.pred = sOTACell.pred;
            sOTACell.left.pred.succ = sOTACell.left;
        } else {
            sOTACell.left.pred = null;
        }
        if (sOTACell.succ != null) {
            sOTACell.right.succ = sOTACell.succ;
            sOTACell.right.succ.pred = sOTACell.right;
        } else {
            sOTACell.right.succ = null;
        }
        if (sOTACell == this.head) {
            this.head = sOTACell.left;
        }
        sOTACell.succ = null;
        sOTACell.pred = null;
        for (int i = 0; i < this.numberOfSamples; ++i) {
            sOTACell.left.centroidGene.set(0, i, sOTACell.centroidGene.get(0, i));
            sOTACell.right.centroidGene.set(0, i, sOTACell.centroidGene.get(0, i));
        }
    }

    public double getMaxLeafToRootPath() {
        SOTACell sOTACell;
        SOTACell sOTACell2 = sOTACell = this.head;
        double d = -1.0;
        while (sOTACell != null) {
            sOTACell2 = sOTACell;
            double d2 = 0.0;
            while (sOTACell2 != null) {
                if (sOTACell2.parent != null) {
                    d2 += (double)ExperimentUtil.geneDistance(sOTACell2.parent.centroidGene, sOTACell2.centroidGene, 0, 0, this.function, this.factor, this.absolute);
                }
                sOTACell2 = sOTACell2.parent;
            }
            if (d2 < d) {
                d = d2;
            }
            sOTACell = sOTACell.succ;
        }
        return d;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }
}

